/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.persistent.comms.hibernate;

import gov.va.med.esr.common.model.comms.CommsTemplate;
import gov.va.med.esr.common.persistent.comms.CommsTemplateDAO;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.AbstractDAOImpl;
import java.math.BigDecimal;
import java.util.List;

public class CommsTemplateDAOImpl
extends AbstractDAOImpl
implements CommsTemplateDAO {
    private static final long serialVersionUID = 7174484969506507125L;

    @Override
    public CommsTemplate findTemplateById(BigDecimal templateId) throws DAOException {
        try {
            List lst = super.getHibernateTemplate().find("from CommsTemplate tmpl where tmpl.identifier = ?", (Object)templateId);
            if (lst != null && lst.size() > 0) {
                return (CommsTemplate)lst.get(0);
            }
        }
        catch (Exception e) {
            throw new DAOException("Failed to find comms template by id", (Throwable)e);
        }
        return null;
    }

    @Override
    public List findTemplateListByFormNumber(String formNumber) throws DAOException {
        try {
            List lst = super.getHibernateTemplate().find("from CommsTemplate tmpl where tmpl.commsTemplateFormNumber = ? order by tmpl.identifier", (Object)formNumber);
            return lst;
        }
        catch (Exception e) {
            throw new DAOException("Failed to find comms template list by form number!", (Throwable)e);
        }
    }

    @Override
    public List findTemplateListByLetterType(String letterTypeCd) throws DAOException {
        try {
            List lst = super.getHibernateTemplate().find("from CommsTemplate tmpl where tmpl.letterType.code = ?", (Object)letterTypeCd);
            return lst;
        }
        catch (Exception e) {
            throw new DAOException("Failed to find comms template list by letter type!", (Throwable)e);
        }
    }

    @Override
    public void insert(CommsTemplate template) throws DAOException {
        super.saveObject((Object)template);
    }
}

