/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.persistent.comms.hibernate;

import gov.va.med.esr.common.model.comms.CommsLogEntry;
import gov.va.med.esr.common.model.comms.CommsLogSearchQueryInfo;
import gov.va.med.esr.common.model.comms.HecRejectReason;
import gov.va.med.esr.common.model.comms.MailingStatusLink;
import gov.va.med.esr.common.model.lookup.ComMailingStatusType;
import gov.va.med.esr.common.persistent.comms.CommsLogEntryDAO;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.UniqueIdentifierGenerator;
import gov.va.med.esr.service.UnknownLookupCodeException;
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.MaxRecordsExceededException;
import gov.va.med.fw.persistent.hibernate.AbstractDAOAction;
import gov.va.med.fw.persistent.hibernate.GenericDAOImpl;
import gov.va.med.fw.persistent.hibernate.PaginatedQueryExecutor;
import gov.va.med.fw.service.pagination.SearchQueryInfo;
import gov.va.med.fw.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateSystemException;

public class CommsLogEntryDAOImpl
extends GenericDAOImpl
implements CommsLogEntryDAO {
    private static final String FIND_BY_BARCODE = "commsLogQuery_FindByBarcode";
    private static final String FIND_BY_PERSON_ID = "commsLogQuery_FindByPersonId";
    private static final String[] barcodeParamFields = new String[]{"barcode"};
    private static final String[] personIdParamFields = new String[]{"personId"};
    private UniqueIdentifierGenerator generator = null;
    protected LookupService lookupService = null;
    private static final long serialVersionUID = 7401171707522279133L;

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    @Override
    public CommsLogEntry findCommsLogEntryByBarcode(String barcode) throws DAOException {
        barcode = barcode.trim().toUpperCase();
        Object[] barcodeParamValues = new String[]{barcode};
        try {
            List results = super.getHibernateTemplate().findByNamedQueryAndNamedParam(FIND_BY_BARCODE, barcodeParamFields, barcodeParamValues);
            if (results != null && results.size() > 0) {
                return (CommsLogEntry)((Object)results.get(0));
            }
        }
        catch (Exception ex) {
            throw new DAOException("Failed to find CommsLogEntry by barcode: " + barcode, (Throwable)ex);
        }
        return null;
    }

    @Override
    public List findCommsLogListByPersonId(String personId) throws DAOException {
        Object[] personIdParamValues = new BigDecimal[]{new BigDecimal(personId)};
        try {
            return super.getHibernateTemplate().findByNamedQueryAndNamedParam(FIND_BY_PERSON_ID, personIdParamFields, personIdParamValues);
        }
        catch (Exception ex) {
            throw new DAOException("Failed to find CommsLogEntries based on person Id: " + personId, (Throwable)ex);
        }
    }

    @Override
    public void update(CommsLogEntry log) throws DAOException {
        super.getHibernateTemplate().update((Object)log);
    }

    @Override
    public void merge(CommsLogEntry log) throws DAOException {
        super.getHibernateTemplate().merge((Object)log);
    }

    @Override
    public void insert(CommsLogEntry log) throws DAOException {
        log.setBarcode(this.generateBarcode(log));
        this.saveObject((Object)log);
    }

    protected String generateBarcode(CommsLogEntry log) {
        Validate.notNull((Object)((Object)log), (String)"A CommsLogEntry is required to generate a barcode.");
        Validate.notNull((Object)((Object)log.getLetterType()), (String)"A letter type is required to generate a barcode.");
        Validate.notEmpty((String)log.getLetterType().getDescription(), (String)"A letter type description is required to generate a barcode.");
        String year = String.valueOf(Calendar.getInstance().get(1));
        return log.getLetterType().getDescription().substring(0, 1) + year.substring(year.length() - 2, year.length()) + this.generator.generate().toString();
    }

    @Override
    public void insertMailingStatus(MailingStatusLink mailStat) throws DAOException {
        this.insertObject((Object)mailStat);
    }

    @Override
    public void insertHecRejectReason(HecRejectReason rejReason) throws DAOException {
        this.insertObject((Object)rejReason);
    }

    @Override
    public List find(CommsLogSearchQueryInfo searchQueryInfo) throws DAOException, MaxRecordsExceededException {
        HashMap<String, CommsLogSearchQueryInfo> contextData = new HashMap<String, CommsLogSearchQueryInfo>();
        contextData.put("searchQueryInfo", searchQueryInfo);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) throws DAOException {
                String whereClause;
                ArrayList paramList = new ArrayList();
                ArrayList valueList = new ArrayList();
                CommsLogSearchQueryInfo targetQueryInfo = (CommsLogSearchQueryInfo)this.getContextData().get("searchQueryInfo");
                try {
                    whereClause = CommsLogEntryDAOImpl.this.createWhereClause(targetQueryInfo, paramList, valueList);
                }
                catch (Exception e) {
                    throw new DAOException(e.getMessage(), (Throwable)e);
                }
                Query countQuery = session.createQuery("select count(*) from CommsLogEntry log join log.mailingStatusLinks status" + whereClause);
                Query dataQuery = session.createQuery("select log from CommsLogEntry log join log.mailingStatusLinks status" + whereClause);
                for (int i = 0; i < paramList.size(); ++i) {
                    countQuery.setParameter((String)paramList.get(i), valueList.get(i));
                    dataQuery.setParameter((String)paramList.get(i), valueList.get(i));
                }
                PaginatedQueryExecutor queryExecutor = new PaginatedQueryExecutor(countQuery, dataQuery, (SearchQueryInfo)targetQueryInfo);
                try {
                    return queryExecutor.executeQuery();
                }
                catch (MaxRecordsExceededException e) {
                    throw new DAOException("max records exceeded", (Throwable)e);
                }
            }
        };
        try {
            return this.getHibernateTemplate().executeFind((HibernateCallback)callback);
        }
        catch (HibernateSystemException e) {
            MaxRecordsExceededException rootCause = (MaxRecordsExceededException)this.getRootExceptionOfType(e, MaxRecordsExceededException.class);
            if (rootCause != null) {
                throw rootCause;
            }
            throw e;
        }
    }

    private String createWhereClause(CommsLogSearchQueryInfo searchQueryInfo, List paramList, List valueList) throws UnknownLookupTypeException, UnknownLookupCodeException {
        ArrayList<String> criteriaList = new ArrayList<String>();
        ComMailingStatusType statusType = this.lookupService.getComMailingStatusTypeByCode(ComMailingStatusType.MAILED_BY_AAC.getName());
        criteriaList.add("status.mailingStatus.identifier = " + statusType.getIdentifier());
        if (!StringUtils.isEmpty((String)searchQueryInfo.getBarcode())) {
            String barcode = searchQueryInfo.getBarcode().trim().toUpperCase();
            criteriaList.add("log.barcode = :barcode");
            paramList.add("barcode");
            valueList.add(barcode);
        }
        if (!StringUtils.isEmpty((String)searchQueryInfo.getSSN())) {
            criteriaList.add("log.ssn.ssnText = :ssn");
            paramList.add("ssn");
            valueList.add(searchQueryInfo.getSSN());
        }
        if (!StringUtils.isEmpty((String)searchQueryInfo.getGivenName())) {
            criteriaList.add("upper(log.name.givenName) = upper(:givenName)");
            paramList.add("givenName");
            valueList.add(searchQueryInfo.getGivenName());
        }
        if (!StringUtils.isEmpty((String)searchQueryInfo.getMiddleName())) {
            criteriaList.add("upper(log.name.middleName) = upper(:middleName)");
            paramList.add("middleName");
            valueList.add(searchQueryInfo.getMiddleName());
        }
        if (!StringUtils.isEmpty((String)searchQueryInfo.getFamilyName())) {
            criteriaList.add("upper(log.name.familyName) = upper(:familyName)");
            paramList.add("familyName");
            valueList.add(searchQueryInfo.getFamilyName());
        }
        if (searchQueryInfo.getFormNumber() != null && !StringUtils.isEmpty((String)searchQueryInfo.getFormNumber().getCode())) {
            criteriaList.add("upper(log.template.commsTemplateFormNumber) = upper(:formNumber)");
            paramList.add("formNumber");
            valueList.add(searchQueryInfo.getFormNumber().getCode());
        }
        if (searchQueryInfo.getCaseNumber() != null) {
            criteriaList.add("log.workflowCaseId = :caseNumber");
            paramList.add("caseNumber");
            valueList.add(searchQueryInfo.getCaseNumber());
        }
        if (searchQueryInfo.getDateMailed() != null) {
            criteriaList.add("trunc(log.mailingDate) = :dateMailed");
            paramList.add("dateMailed");
            valueList.add(searchQueryInfo.getDateMailed());
        }
        if (!StringUtils.isEmpty((String)searchQueryInfo.getAddressLine1())) {
            criteriaList.add("upper(log.address.line1) = upper(:addressLine1)");
            paramList.add("addressLine1");
            valueList.add(searchQueryInfo.getAddressLine1());
        }
        if (!StringUtils.isEmpty((String)searchQueryInfo.getAddressLine2())) {
            criteriaList.add("upper(log.address.line2) = upper(:addressLine2)");
            paramList.add("addressLine2");
            valueList.add(searchQueryInfo.getAddressLine2());
        }
        if (!StringUtils.isEmpty((String)searchQueryInfo.getAddressLine3())) {
            criteriaList.add("upper(log.address.line3) = upper(:addressLine3)");
            paramList.add("addressLine3");
            valueList.add(searchQueryInfo.getAddressLine3());
        }
        if (!StringUtils.isEmpty((String)searchQueryInfo.getCity())) {
            criteriaList.add("upper(log.address.city) = upper(:city)");
            paramList.add("city");
            valueList.add(searchQueryInfo.getCity());
        }
        if (searchQueryInfo.getState() != null && !StringUtils.isEmpty((String)searchQueryInfo.getState().getCode())) {
            criteriaList.add("upper(log.address.state) = upper(:state)");
            paramList.add("state");
            valueList.add(searchQueryInfo.getState().getCode());
        }
        if (!StringUtils.isEmpty((String)searchQueryInfo.getCounty())) {
            criteriaList.add("upper(log.address.county) = upper(:county)");
            paramList.add("county");
            valueList.add(searchQueryInfo.getCounty());
        }
        if (!StringUtils.isEmpty((String)searchQueryInfo.getProvince())) {
            criteriaList.add("upper(log.address.province) = upper(:province)");
            paramList.add("province");
            valueList.add(searchQueryInfo.getProvince());
        }
        if (!StringUtils.isEmpty((String)searchQueryInfo.getPostalCode())) {
            criteriaList.add("upper(log.address.postalCode) = upper(:postalCode)");
            paramList.add("postalCode");
            valueList.add(searchQueryInfo.getPostalCode());
        }
        if (!StringUtils.isEmpty((String)searchQueryInfo.getZipPlus4())) {
            criteriaList.add("upper(log.address.zipPlus4) = upper(:zipPlus4)");
            paramList.add("zipPlus4");
            valueList.add(searchQueryInfo.getZipPlus4());
        }
        if (!StringUtils.isEmpty((String)searchQueryInfo.getCountry())) {
            criteriaList.add("upper(log.address.country) = upper(:country)");
            paramList.add("country");
            valueList.add(searchQueryInfo.getCountry());
        }
        if (!StringUtils.isEmpty((String)searchQueryInfo.getZipCode())) {
            criteriaList.add("upper(log.address.zipCode) = upper(:zipCode)");
            paramList.add("zipCode");
            valueList.add(searchQueryInfo.getZipCode());
        }
        criteriaList.add("EXISTS (SELECT 1 FROM MailingStatusLink status1 WHERE status1.commsLog.identifier = status.commsLog.identifier GROUP BY status1.commsLog.identifier HAVING MAX (status1.identifier) = status.identifier)");
        StringBuffer whereClause = new StringBuffer();
        if (!criteriaList.isEmpty()) {
            whereClause.append(" where ").append(criteriaList.get(0));
            for (int index = 1; index < criteriaList.size(); ++index) {
                whereClause.append(" and ").append(criteriaList.get(index));
            }
        }
        return whereClause.toString();
    }

    public UniqueIdentifierGenerator getGenerator() {
        return this.generator;
    }

    public void setGenerator(UniqueIdentifierGenerator generator) {
        this.generator = generator;
    }
}

