/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.security;

import gov.va.med.esr.common.model.lookup.Capability;
import gov.va.med.esr.common.model.security.AbstractPermission;
import gov.va.med.esr.common.model.security.CapabilitySetCapability;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class CapabilitySet
extends AbstractPermission
implements Comparable {
    private static final long serialVersionUID = 4731870603981647496L;
    private Set internalCapabilities;

    public Set getCapabilities() {
        HashSet<Capability> capabilities = new HashSet<Capability>();
        Iterator i = this.getInternalCapabilities().iterator();
        while (i.hasNext()) {
            capabilities.add(((CapabilitySetCapability)((Object)i.next())).getCapability());
        }
        return capabilities;
    }

    public List getActiveCapabilities() {
        ArrayList capabilities = new ArrayList();
        if (this.isActive()) {
            capabilities.addAll(this.getCapabilities());
        }
        return capabilities;
    }

    public void addCapability(Capability capability) {
        Validate.notNull((Object)capability, (String)"Can not add null capability");
        if (this.findCapability(capability) == null) {
            CapabilitySetCapability capabilitySetCapability = new CapabilitySetCapability(this, capability);
            this.getInternalCapabilities().add(capabilitySetCapability);
        }
    }

    public void removeCapability(Capability capability) {
        Validate.notNull((Object)capability, (String)"Can not remove null Capability");
        CapabilitySetCapability capabilitySetCapability = this.findCapability(capability);
        if (capabilitySetCapability != null) {
            this.getInternalCapabilities().remove((Object)capabilitySetCapability);
        }
    }

    public void removeAllCapabilities() {
        this.getInternalCapabilities().clear();
    }

    @Override
    public int compareTo(Object o) {
        if (o != null && o instanceof CapabilitySet) {
            return this.getName().compareTo(((CapabilitySet)o).getName());
        }
        return 1;
    }

    private CapabilitySetCapability findCapability(Capability capability) {
        for (CapabilitySetCapability capabilitySetCapability : this.getInternalCapabilities()) {
            if (!capability.equals(capabilitySetCapability.getCapability()) && !capability.getCode().equals(capabilitySetCapability.getCapability().getCode())) continue;
            return capabilitySetCapability;
        }
        return null;
    }

    @Override
    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("internalCapabilities", (Object)this.internalCapabilities);
    }

    public Set getInternalCapabilities() {
        if (this.internalCapabilities == null) {
            this.internalCapabilities = new HashSet();
        }
        return this.internalCapabilities;
    }

    private void setInternalCapabilities(Set internalCapabilities) {
        this.internalCapabilities = internalCapabilities;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.setInternalCapabilities(null);
    }
}

