/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.security;

import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.util.DateUtils;
import java.util.Date;
import org.apache.commons.lang.builder.ToStringBuilder;

public class AbstractPermission
extends AbstractKeyedEntity
implements Comparable {
    private static final long serialVersionUID = -5541905456916221664L;
    private String name;
    private String description;
    private Date activeDate;
    private Date inactiveDate;
    private Boolean assigned;

    public Date getActiveDate() {
        return this.activeDate;
    }

    public void setActiveDate(Date activeDate) {
        this.activeDate = activeDate;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getInactiveDate() {
        return this.inactiveDate;
    }

    public void setInactiveDate(Date inactiveDate) {
        this.inactiveDate = inactiveDate;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getAssigned() {
        return this.assigned;
    }

    public Boolean isAssigned() {
        return this.getAssigned() == null ? Boolean.FALSE : this.getAssigned();
    }

    public void setAssigned(Boolean assigned) {
        this.assigned = assigned;
    }

    public boolean isActive() {
        return AbstractPermission.isActive(this.activeDate, this.inactiveDate);
    }

    public boolean isAssignable() {
        return AbstractPermission.isAssignable(this.activeDate, this.inactiveDate);
    }

    public int compareTo(Object o) {
        if (o != null && o instanceof AbstractPermission) {
            return this.getName().compareTo(((AbstractPermission)o).getName());
        }
        return 1;
    }

    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("name", (Object)this.name);
        builder.append("description", (Object)this.description);
        builder.append("activeDate", (Object)this.activeDate);
        builder.append("inactiveDate", (Object)this.inactiveDate);
        builder.append("assigned", (Object)this.assigned);
    }

    public static boolean isActive(Date starteDate, Date endDate) {
        Date today = DateUtils.getCurrentDate();
        return (starteDate == null || !starteDate.after(today)) && (endDate == null || endDate.after(today));
    }

    public static boolean isAssignable(Date starteDate, Date endDate) {
        Date today = DateUtils.getCurrentDate();
        return endDate == null || endDate.after(today);
    }
}

