/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.person;

import gov.va.med.esr.common.model.ee.VoaFileAttachment;
import gov.va.med.esr.common.model.lookup.AuthenticationLevel;
import gov.va.med.esr.common.model.lookup.Gender;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.lookup.VOAApplicationStatus;
import gov.va.med.esr.common.model.lookup.VOAFormType;
import gov.va.med.esr.common.model.lookup.VeteranIdentifierType;
import gov.va.med.esr.common.model.person.VOAApplicationData;
import gov.va.med.esr.common.model.person.VOAResubmissionData;
import gov.va.med.fw.model.AbstractKeyedEntity;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class VOAApplication
extends AbstractKeyedEntity {
    private static final long serialVersionUID = 7947904918962959457L;
    private BigDecimal applicationId = null;
    private BigDecimal personId = null;
    private String lastName = null;
    private String firstName = null;
    private String middleName = null;
    private Date dateOfBirth = null;
    private String ssn = null;
    private Date responseTimeStamp = null;
    private String errorText = null;
    private String fullQualifiedId = null;
    private Date receiveTimeStamp = null;
    private VAFacility preferredFacility = null;
    private VOAFormType formType = null;
    private VOAApplicationStatus applicationStatus = null;
    private Gender gender = null;
    private AuthenticationLevel authenticationLevel = null;
    private VeteranIdentifierType identityType = null;
    private Set internalFileAttachments = null;
    private Set internalVOAApplicationData = null;
    private Set internalVOAResubmissionApps = null;
    private int hashValue = 0;

    public VOAApplicationStatus getApplicationStatus() {
        return this.applicationStatus;
    }

    public void setApplicationStatus(VOAApplicationStatus applicationStatus) {
        this.applicationStatus = applicationStatus;
    }

    public AuthenticationLevel getAuthenticationLevel() {
        return this.authenticationLevel;
    }

    public void setAuthenticationLevel(AuthenticationLevel authenticationLevel) {
        this.authenticationLevel = authenticationLevel;
    }

    public Date getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(Date dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public String getErrorText() {
        return this.errorText;
    }

    public void setErrorText(String errorText) {
        this.errorText = errorText;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public VOAFormType getFormType() {
        return this.formType;
    }

    public void setFormType(VOAFormType formType) {
        this.formType = formType;
    }

    public String getFullQualifiedId() {
        return this.fullQualifiedId;
    }

    public void setFullQualifiedId(String fullQualifiedId) {
        this.fullQualifiedId = fullQualifiedId;
    }

    public Gender getGender() {
        return this.gender;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    public BigDecimal getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(BigDecimal applicationId) {
        this.applicationId = applicationId;
    }

    public VeteranIdentifierType getIdentityType() {
        return this.identityType;
    }

    public void setIdentityType(VeteranIdentifierType identityType) {
        this.identityType = identityType;
    }

    private Set getInternalFileAttachments() {
        if (this.internalFileAttachments == null) {
            this.internalFileAttachments = new HashSet();
        }
        return this.internalFileAttachments;
    }

    private void setInternalFileAttachments(Set internalFileAttachments) {
        this.internalFileAttachments = internalFileAttachments;
    }

    public Set getFileAttachments() {
        return Collections.unmodifiableSet(this.getInternalFileAttachments());
    }

    public void addFileAttachment(VoaFileAttachment attachment) {
        Validate.notNull((Object)((Object)attachment), (String)"Null attachment specified.");
        this.getInternalFileAttachments().add(attachment);
        attachment.setVoaApplication(this);
    }

    public void removeAllVoaAttachments() {
        Iterator it = this.getInternalFileAttachments().iterator();
        while (it.hasNext()) {
            ((VoaFileAttachment)((Object)it.next())).setVoaApplication(null);
        }
        this.getInternalFileAttachments().clear();
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public BigDecimal getPersonId() {
        return this.personId;
    }

    public void setPersonId(BigDecimal personId) {
        this.personId = personId;
    }

    public VAFacility getPreferredFacility() {
        return this.preferredFacility;
    }

    public void setPreferredFacility(VAFacility preferredFacility) {
        this.preferredFacility = preferredFacility;
    }

    public Date getReceiveTimeStamp() {
        return this.receiveTimeStamp;
    }

    public void setReceiveTimeStamp(Date receiveTimeStamp) {
        this.receiveTimeStamp = receiveTimeStamp;
    }

    public Date getResponseTimeStamp() {
        return this.responseTimeStamp;
    }

    public void setResponseTimeStamp(Date responseTimeStamp) {
        this.responseTimeStamp = responseTimeStamp;
    }

    public String getSsn() {
        return this.ssn;
    }

    public void setSsn(String ssn) {
        this.ssn = ssn;
    }

    private Set getInternalVOAApplicationData() {
        if (this.internalVOAApplicationData == null) {
            this.internalVOAApplicationData = new HashSet();
        }
        return this.internalVOAApplicationData;
    }

    private void setInternalVOAApplicationData(Set internalVOAApplicationData) {
        this.internalVOAApplicationData = internalVOAApplicationData;
    }

    public VOAApplicationData getVOAApplicationData() {
        Set appData = this.getInternalVOAApplicationData();
        if (appData.size() > 0) {
            return (VOAApplicationData)((Object)appData.iterator().next());
        }
        return null;
    }

    public void setVOAApplicationData(VOAApplicationData appData) {
        Set ad = this.getInternalVOAApplicationData();
        ad.clear();
        if (appData != null) {
            ad.add(appData);
            appData.setVoaApplication(this);
        }
    }

    private Set getInternalVOAResubmissionApps() {
        if (this.internalVOAResubmissionApps == null) {
            this.internalVOAResubmissionApps = new HashSet();
        }
        return this.internalVOAResubmissionApps;
    }

    private void setInternalVOAResubmissionApps(Set internalVOAResubmissionApps) {
        this.internalVOAResubmissionApps = internalVOAResubmissionApps;
    }

    public VOAResubmissionData getVOAResubmissionData() {
        Set appData = this.getInternalVOAResubmissionApps();
        if (appData.size() > 0) {
            return (VOAResubmissionData)((Object)appData.iterator().next());
        }
        return null;
    }

    public void setVOAResubmissionData(VOAResubmissionData appData) {
        Set ad = this.getInternalVOAResubmissionApps();
        ad.clear();
        if (appData != null) {
            ad.add(appData);
            appData.setVoaApplicationId((BigDecimal)this.getIdentifier());
        }
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        if (rhs == this) {
            return true;
        }
        if (rhs.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        VOAApplication that = (VOAApplication)((Object)rhs);
        return this.isEqual(this.getIdentifier(), that.getIdentifier()) && this.isEqual(this.personId, that.personId) && this.isEqual((Object)this.applicationStatus, (Object)that.applicationStatus) && this.isEqual(this.internalVOAApplicationData, that.internalVOAApplicationData);
    }

    private boolean isEqual(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return b == null ? false : a.equals(b);
    }

    public int hashCode() {
        if (this.hashValue == 0) {
            int result = 17;
            int idValue = this.getIdentifier() == null ? 0 : this.getIdentifier().hashCode();
            result = result * 37 + idValue;
            result = result * 37 + this.applicationStatus.hashCode();
            result = result * 37 + this.ssn.hashCode();
            if (this.personId != null) {
                result = result * 37 + this.personId.hashCode();
            }
            result = result * 37 + this.applicationStatus.hashCode();
            if (this.internalVOAApplicationData != null) {
                result = result * 37 + ((Object)this.internalVOAApplicationData).hashCode();
            }
            this.hashValue = result;
        }
        return this.hashValue;
    }

    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("formType", (Object)this.formType);
        builder.append("applicationStatus", (Object)this.applicationStatus);
        builder.append("personId", (Object)this.personId);
        builder.append("responseTimeStamp", (Object)this.responseTimeStamp);
        builder.append("receiveTimeStamp", (Object)this.receiveTimeStamp);
        builder.append("lastName", (Object)this.lastName);
        builder.append("firstName", (Object)this.firstName);
        builder.append("middleName", (Object)this.middleName);
        builder.append("dateOfBirth", (Object)this.dateOfBirth);
        builder.append("ssn", (Object)this.ssn);
        builder.append("gender", (Object)this.gender);
    }
}

