/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.person;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.lookup.EmploymentStatus;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.party.Phone;
import gov.va.med.esr.common.model.person.Employment;
import gov.va.med.esr.common.model.person.Relation;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Spouse
extends Relation {
    private static final long serialVersionUID = -4441058118001402944L;
    private String maidenName = null;
    private Set internalEmployments = null;
    private Set internalAddresses = null;
    private Set internalPhones = null;
    private EmploymentStatus employmentStatus = null;

    public EmploymentStatus getEmploymentStatus() {
        return this.employmentStatus;
    }

    public void setEmploymentStatus(EmploymentStatus employmentStatus) {
        this.employmentStatus = employmentStatus;
    }

    public String getMaidenName() {
        return this.maidenName;
    }

    public void setMaidenName(String maidenName) {
        this.maidenName = maidenName;
    }

    public ImpreciseDate getMarriageDate() {
        return this.getStartDate();
    }

    public void setMarriageDate(ImpreciseDate marriageDate) {
        this.setStartDate(marriageDate);
    }

    private void setInternalAddresses(Set addresses) {
        this.internalAddresses = addresses;
    }

    private Set getInternalAddresses() {
        if (this.internalAddresses == null) {
            this.internalAddresses = new HashSet();
        }
        return this.internalAddresses;
    }

    private void addAddress(Address address) {
        Validate.notNull((Object)address, (String)"Null address specified.");
        this.getInternalAddresses().add(address);
        address.setSpouse(this);
    }

    private void removeAddress(Address address) {
        Validate.notNull((Object)address, (String)"Null address specified.");
        this.getInternalAddresses().remove(address);
    }

    public Address getAddress() {
        Set addresses = this.getInternalAddresses();
        if (addresses.size() > 0) {
            return (Address)addresses.iterator().next();
        }
        return null;
    }

    public void setAddress(Address address) {
        Set addresses = this.getInternalAddresses();
        addresses.clear();
        if (address != null) {
            this.addAddress(address);
        }
    }

    private Set getInternalPhones() {
        if (this.internalPhones == null) {
            this.internalPhones = new HashSet();
        }
        return this.internalPhones;
    }

    private void setInternalPhones(Set phones) {
        this.internalPhones = phones;
    }

    private void addPhone(Phone phone) {
        Validate.notNull((Object)((Object)phone), (String)"Null phone specified.");
        this.getInternalPhones().add(phone);
        phone.setSpouse(this);
    }

    public void setHomePhone(Phone phone) {
        Set phones = this.getInternalPhones();
        phones.clear();
        if (phone != null) {
            this.addPhone(phone);
        }
    }

    public Phone getHomePhone() {
        Set phones = this.getInternalPhones();
        if (phones.size() > 0) {
            return (Phone)((Object)phones.iterator().next());
        }
        return null;
    }

    public Employment getEmployment() {
        Set employments = this.getInternalEmployments();
        return employments.size() > 0 ? (Employment)((Object)employments.iterator().next()) : null;
    }

    public void setEmployment(Employment employment) {
        Set employments = this.getInternalEmployments();
        Iterator iter = employments.iterator();
        if (iter.hasNext()) {
            Employment e = (Employment)((Object)iter.next());
            employments.remove((Object)e);
            e.setSpouse(null);
        }
        if (employment != null) {
            employments.add(employment);
            employment.setSpouse(this);
        }
    }

    private Set getInternalEmployments() {
        if (this.internalEmployments == null) {
            this.internalEmployments = new HashSet();
        }
        return this.internalEmployments;
    }

    private void setInternalEmployments(Set employments) {
        this.internalEmployments = employments;
    }

    public void removeEmployment(Employment employment) {
        Validate.notNull((Object)((Object)employment), (String)"Employment cannot be null");
        this.getInternalEmployments().remove((Object)employment);
    }

    @Override
    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("marriageDate", (Object)this.getMarriageDate());
        builder.append("maidenName", (Object)this.maidenName);
    }
}

