/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.person;

import gov.va.med.esr.common.model.lookup.NameType;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.util.StringUtils;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Name
extends AbstractEntity
implements Comparable {
    private static final long serialVersionUID = 6236325865733264677L;
    public static final StandardFormat NAME_FORMAT_FIRST_SPACE_LAST = new StandardFormat("1");
    public static final StandardFormat NAME_FORMAT_LAST_COMMA_FIRST = new StandardFormat("2");
    private String prefix = null;
    private String givenName = null;
    private String middleName = null;
    private String familyName = null;
    private String suffix = null;
    private NameType type = null;

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public NameType getType() {
        return this.type;
    }

    public void setType(NameType type) {
        this.type = type;
    }

    protected void buildToString(ToStringBuilder builder) {
        builder.append("prefix", (Object)this.prefix);
        builder.append("givenName", (Object)this.givenName);
        builder.append("middleName", (Object)this.middleName);
        builder.append("familyName", (Object)this.familyName);
        builder.append("suffix", (Object)this.suffix);
        builder.append("type", (Object)this.type);
    }

    public static Name getNameOfType(Set names, String typeCode) {
        Validate.notNull((Object)names, (String)"The set of Name's must not be null");
        Validate.notNull((Object)typeCode, (String)"Name type's code must not be null");
        for (Name name : names) {
            NameType nameType = name.getType();
            if (nameType == null || !nameType.getCode().equals(typeCode)) continue;
            return name;
        }
        return null;
    }

    public int compareTo(Object nameObject) {
        Name otherName = (Name)nameObject;
        return StringUtils.compareTo((String)this.getFormattedName(), (String)otherName.getFormattedName());
    }

    public String getFormattedName() {
        return this.getFormattedName(NAME_FORMAT_LAST_COMMA_FIRST);
    }

    public String getFormattedName(StandardFormat format) {
        StringBuffer buf = new StringBuffer();
        if (format != null) {
            if (format != null && NAME_FORMAT_FIRST_SPACE_LAST.getCode().equals(format.getCode())) {
                if (StringUtils.isNotBlank((String)this.givenName)) {
                    buf.append(this.givenName);
                }
                if (StringUtils.isNotBlank((String)this.familyName)) {
                    buf.append(" ").append(this.familyName);
                }
            } else {
                if (StringUtils.isNotBlank((String)this.familyName)) {
                    buf.append(this.familyName);
                }
                if (StringUtils.isNotBlank((String)this.givenName)) {
                    if (buf.length() > 0) {
                        buf.append(", ");
                    }
                    buf.append(this.givenName);
                }
            }
        }
        return buf.toString().toUpperCase();
    }

    public static class StandardFormat
    extends AbstractCode {
        private static final long serialVersionUID = -8139709996478085470L;

        private StandardFormat(String code) {
            super(code);
        }
    }
}

