/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.person;

import gov.va.med.esr.common.model.lookup.AssociationType;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.util.DateUtils;
import gov.va.med.fw.util.StringUtils;
import java.util.Date;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Association
extends AbstractKeyedEntity
implements Comparable {
    private static final long serialVersionUID = 7361250873555917782L;
    private Person person = null;
    private AssociationType type = null;
    private String organizationName = null;
    private Name representativeName = null;
    private String relationship = null;
    private Address address = null;
    private String primaryPhone = null;
    private String alternatePhone = null;
    private Date primaryPhoneChangeDate = null;
    private Date deactivationDate;
    private Date alternatePhoneChangeDate = null;
    private Date lastUpdateDate = null;

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.validateOwner(this.person, person);
        this.person = person;
    }

    public AssociationType getType() {
        return this.type;
    }

    public void setType(AssociationType type) {
        this.type = type;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public Name getRepresentativeName() {
        return this.representativeName;
    }

    public void setRepresentativeName(Name representativeName) {
        this.representativeName = representativeName;
    }

    public String getRelationship() {
        return this.relationship;
    }

    public void setRelationship(String relationship) {
        this.relationship = relationship;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        if (this.address != null) {
            this.address.setAssociation(null);
        }
        if (address != null) {
            address.setAssociation(this);
        }
        this.address = address;
    }

    public String getAlternatePhone() {
        return this.alternatePhone;
    }

    public void setAlternatePhone(String alternatePhone) {
        this.alternatePhone = alternatePhone;
    }

    public Date getAlternatePhoneChangeDate() {
        return this.alternatePhoneChangeDate;
    }

    public void setAlternatePhoneChangeDate(Date alternatePhoneChangeDate) {
        this.alternatePhoneChangeDate = alternatePhoneChangeDate;
    }

    public String getPrimaryPhone() {
        return this.primaryPhone;
    }

    public void setPrimaryPhone(String primaryPhone) {
        this.primaryPhone = primaryPhone;
    }

    public Date getPrimaryPhoneChangeDate() {
        return this.primaryPhoneChangeDate;
    }

    public void setPrimaryPhoneChangeDate(Date primaryPhoneChangeDate) {
        this.primaryPhoneChangeDate = primaryPhoneChangeDate;
    }

    private void isRepresentativeName() {
        if (this.representativeName == null) {
            this.representativeName = new Name();
        }
    }

    public String getFirstName() {
        return this.representativeName == null ? "" : this.representativeName.getGivenName();
    }

    public void setFirstName(String firstName) {
        this.isRepresentativeName();
        this.representativeName.setGivenName(firstName);
    }

    public String getLastName() {
        return this.representativeName == null ? "" : this.representativeName.getFamilyName();
    }

    public void setLastName(String lastName) {
        this.isRepresentativeName();
        this.representativeName.setFamilyName(lastName);
    }

    public String getMiddleName() {
        return this.representativeName == null ? "" : this.representativeName.getMiddleName();
    }

    public void setMiddleName(String middleName) {
        this.isRepresentativeName();
        this.representativeName.setMiddleName(middleName);
    }

    public Date getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    public void setLastUpdateDate(Date lastUpdateDate) {
        this.lastUpdateDate = lastUpdateDate;
    }

    public boolean isExpired() {
        Date today = DateUtils.getCurrentDate();
        Date deactiveDate = this.getDeactivationDate();
        return deactiveDate != null && deactiveDate.before(today);
    }

    public int compareTo(Object associationObject) {
        Association otherAssociation = (Association)associationObject;
        String thisCompareValue = this.getRepresentativeName() != null ? this.getRepresentativeName().getFormattedName().trim() : "";
        String otherCompareValue = otherAssociation.getRepresentativeName() != null ? otherAssociation.getRepresentativeName().getFormattedName().trim() : "";
        thisCompareValue = thisCompareValue + (this.getOrganizationName() != null ? this.getOrganizationName().trim() : "");
        otherCompareValue = otherCompareValue + (otherAssociation.getOrganizationName() != null ? otherAssociation.getOrganizationName().trim() : "");
        return StringUtils.compareTo((String)thisCompareValue, (String)otherCompareValue);
    }

    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("type", (Object)this.type);
        builder.append("organizationName", (Object)this.organizationName);
        builder.append("representativeName", (Object)this.representativeName);
        builder.append("address", (Object)this.address);
        builder.append("relationship", (Object)this.relationship);
        builder.append("deactivationDate", (Object)this.deactivationDate);
    }

    public static Association getAssociationOfType(Set associations, String typeCode) {
        Validate.notNull((Object)associations, (String)"The set of associations must not be null");
        Validate.notNull((Object)typeCode, (String)"Association type's code must not be null");
        for (Association association : associations) {
            AssociationType associationType;
            if (association.getDeactivationDate() != null || (associationType = association.getType()) == null || !associationType.getCode().equals(typeCode)) continue;
            return association;
        }
        return null;
    }

    public Date getDeactivationDate() {
        return this.deactivationDate;
    }

    public void setDeactivationDate(Date deactivationDate) {
        this.deactivationDate = deactivationDate;
    }
}

