/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.party;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.insurance.InsurancePolicy;
import gov.va.med.esr.common.model.lookup.AddressChangeSource;
import gov.va.med.esr.common.model.lookup.AddressType;
import gov.va.med.esr.common.model.lookup.BadAddressReason;
import gov.va.med.esr.common.model.lookup.NcoaDeliveryCode;
import gov.va.med.esr.common.model.lookup.NcoaStatus;
import gov.va.med.esr.common.model.lookup.NcoaZipMatch;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.lookup.ZipPlus4NoMatchReason;
import gov.va.med.esr.common.model.party.SimpleAddress;
import gov.va.med.esr.common.model.person.Association;
import gov.va.med.esr.common.model.person.Employment;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.Spouse;
import java.util.Date;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Address
extends SimpleAddress {
    private static final long serialVersionUID = -7981129128811594778L;
    private Person person = null;
    private Spouse spouse = null;
    private Employment employment = null;
    private Association association = null;
    private InsurancePolicy insurancePolicy = null;
    private AddressChangeSource changeSource;
    private VAFacility changeSite;
    private Date changeDate;
    private ImpreciseDate startDate;
    private ImpreciseDate endDate;
    private String phoneNumber;
    private BadAddressReason badAddressReason;
    private Date dateCheckedByNCOA;
    private Date ncoaInvalidUndeliverableDate;
    private NcoaStatus ncoaStatus;
    private NcoaDeliveryCode ncoaDeliveryCode;
    private NcoaZipMatch ncoaZipPlus4MatchCode;
    private ZipPlus4NoMatchReason zipPlus4NoMatchReason;
    private boolean isActive = true;

    public Association getAssociation() {
        return this.association;
    }

    public void setAssociation(Association association) {
        this.association = association;
    }

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.validateOwner(this.person, person);
        this.person = person;
    }

    public Spouse getSpouse() {
        return this.spouse;
    }

    public void setSpouse(Spouse spouse) {
        this.validateOwner(this.spouse, spouse);
        this.spouse = spouse;
    }

    public Employment getEmployment() {
        return this.employment;
    }

    public void setEmployment(Employment employment) {
        this.employment = employment;
    }

    public InsurancePolicy getInsurancePolicy() {
        return this.insurancePolicy;
    }

    public void setInsurancePolicy(InsurancePolicy insurancePolicy) {
        this.validateOwner(this.insurancePolicy, insurancePolicy);
        this.insurancePolicy = insurancePolicy;
    }

    public Date getChangeDate() {
        return this.changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }

    public AddressChangeSource getChangeSource() {
        return this.changeSource;
    }

    public void setChangeSource(AddressChangeSource changeSource) {
        this.changeSource = changeSource;
    }

    public VAFacility getChangeSite() {
        return this.changeSite;
    }

    public void setChangeSite(VAFacility changeSite) {
        this.changeSite = changeSite;
    }

    public ImpreciseDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(ImpreciseDate endDate) {
        this.endDate = endDate;
    }

    public ImpreciseDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(ImpreciseDate startDate) {
        this.startDate = startDate;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phone) {
        this.phoneNumber = phone;
    }

    public BadAddressReason getBadAddressReason() {
        return this.badAddressReason;
    }

    public void setBadAddressReason(BadAddressReason reason) {
        this.badAddressReason = reason;
    }

    public Date getDateCheckedByNCOA() {
        return this.dateCheckedByNCOA;
    }

    public void setDateCheckedByNCOA(Date date) {
        this.dateCheckedByNCOA = date;
    }

    public Date getNcoaInvalidUndeliverableDate() {
        return this.ncoaInvalidUndeliverableDate;
    }

    public void setNcoaInvalidUndeliverableDate(Date ncoaInvalidUndeliverableDate) {
        this.ncoaInvalidUndeliverableDate = ncoaInvalidUndeliverableDate;
    }

    public NcoaStatus getNcoaStatus() {
        return this.ncoaStatus;
    }

    public void setNcoaStatus(NcoaStatus status) {
        this.ncoaStatus = status;
    }

    public NcoaDeliveryCode getNcoaDeliveryCode() {
        return this.ncoaDeliveryCode;
    }

    public void setNcoaDeliveryCode(NcoaDeliveryCode code) {
        this.ncoaDeliveryCode = code;
    }

    public NcoaZipMatch getNcoaZipPlus4MatchCode() {
        return this.ncoaZipPlus4MatchCode;
    }

    public void setNcoaZipPlus4MatchCode(NcoaZipMatch code) {
        this.ncoaZipPlus4MatchCode = code;
    }

    public ZipPlus4NoMatchReason getZipPlus4NoMatchReason() {
        return this.zipPlus4NoMatchReason;
    }

    public void setZipPlus4NoMatchReason(ZipPlus4NoMatchReason reason) {
        this.zipPlus4NoMatchReason = reason;
    }

    @Override
    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("changeDate", (Object)this.changeDate);
        builder.append("changeSource", (Object)this.changeSource);
        builder.append("changeSite", (Object)this.changeSite);
        builder.append("changeDate", (Object)this.changeDate);
        builder.append("startDate", (Object)this.startDate);
        builder.append("endDate", (Object)this.phoneNumber);
        builder.append("phoneNumber", (Object)this.phoneNumber);
        builder.append("badAddressReason", (Object)this.badAddressReason);
        builder.append("dateCheckedByNCOA", (Object)this.dateCheckedByNCOA);
        builder.append("ncoaInvalidUndeliverableDate", (Object)this.ncoaInvalidUndeliverableDate);
        builder.append("ncoaStatus", (Object)this.ncoaStatus);
        builder.append("ncoaZipPlus4MatchCode", (Object)this.ncoaZipPlus4MatchCode);
        builder.append("zipPlus4NoMatchReason", (Object)this.zipPlus4NoMatchReason);
    }

    public static Address getAddressOfType(Set addresses, String typeCode) {
        Validate.notNull((Object)addresses, (String)"The set of addresses must not be null");
        Validate.notNull((Object)typeCode, (String)"Address type's code must not be null");
        for (Address addr : addresses) {
            AddressType addrType = addr.getType();
            if (addrType == null || !addrType.getCode().equals(typeCode)) continue;
            return addr;
        }
        return null;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }
}

