/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.lookup;

import gov.va.med.esr.service.UnknownLookupCodeException;
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class TransactionType
extends AbstractNamedActiveLookup {
    private static final long serialVersionUID = -7620439254254633591L;
    public static final Code CODE_INSERT = new Code(gov.va.med.fw.model.lookup.TransactionType.CODE_INSERT.getCode());
    public static final Code CODE_UPDATE = new Code(gov.va.med.fw.model.lookup.TransactionType.CODE_UPDATE.getCode());
    public static final Code CODE_DELETE = new Code(gov.va.med.fw.model.lookup.TransactionType.CODE_DELETE.getCode());

    public boolean isDeleted() {
        return CODE_DELETE.getName().equals(this.getCode());
    }

    public boolean isUpdated() {
        return CODE_UPDATE.getName().equals(this.getCode());
    }

    public boolean isInserted() {
        return CODE_INSERT.getName().equals(this.getCode());
    }

    public static TransactionType getTransactionTypeByCode(Code code) {
        TransactionType transactionType = new TransactionType();
        try {
            Method method = TransactionType.class.getDeclaredMethod("setCode", String.class);
            method.setAccessible(true);
            method.invoke((Object)transactionType, code.getName());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create TransactionType", e);
        }
        return transactionType;
    }

    public static List getAllTransactionTypes() throws UnknownLookupTypeException, UnknownLookupCodeException {
        ArrayList<TransactionType> types = new ArrayList<TransactionType>(3);
        types.add(TransactionType.getTransactionTypeByCode(CODE_INSERT));
        types.add(TransactionType.getTransactionTypeByCode(CODE_UPDATE));
        types.add(TransactionType.getTransactionTypeByCode(CODE_DELETE));
        return types;
    }

    public static class Code
    extends AbstractCode {
        private static final long serialVersionUID = 99554460612580929L;

        private Code(String code) {
            super(code);
        }

        public static Code getByCode(String code) {
            return (Code)Code.getCode(Code.class, (String)code);
        }
    }
}

