/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.hbp;

import gov.va.med.esr.common.model.hbp.HealthBenefitPlanDescription;
import gov.va.med.esr.common.model.hbp.HealthBenefitPlanName;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.util.StringUtils;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;

public class HealthBenefitPlanDefinition
extends AbstractKeyedEntity
implements Comparable<HealthBenefitPlanDefinition> {
    private static final long serialVersionUID = -7555944516436868437L;
    private HealthBenefitPlanName planName;
    private String planCode;
    private String coverageCode;
    private Date effectiveDate = null;
    private Date expirationDate = null;
    private Boolean automated = Boolean.FALSE;
    private Set<HealthBenefitPlanDescription> internalPlanDescriptions = null;

    public HealthBenefitPlanName getPlanName() {
        return this.planName;
    }

    public void setPlanName(HealthBenefitPlanName planName) {
        this.validateOwner(this.planName, planName);
        this.planName = planName;
    }

    public String getPlanCode() {
        return this.planCode;
    }

    public void setPlanCode(String planCode) {
        this.planCode = planCode;
    }

    public String getCoverageCode() {
        return this.coverageCode;
    }

    public void setCoverageCode(String coverageCode) {
        this.coverageCode = coverageCode;
    }

    public Date getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public Boolean getAutomated() {
        return this.automated;
    }

    public void setAutomated(Boolean automated) {
        this.automated = automated;
    }

    public void isAutomated(Boolean automated) {
        this.automated = automated;
    }

    private Set<HealthBenefitPlanDescription> getInternalPlanDescriptions() {
        if (this.internalPlanDescriptions == null) {
            this.internalPlanDescriptions = new HashSet<HealthBenefitPlanDescription>();
        }
        return this.internalPlanDescriptions;
    }

    private void setInternalPlanDescriptions(Set<HealthBenefitPlanDescription> internalPlanDescriptions) {
        this.internalPlanDescriptions = internalPlanDescriptions;
    }

    public HealthBenefitPlanDescription getPlanDescription() {
        Set<HealthBenefitPlanDescription> descriptions = this.getInternalPlanDescriptions();
        return descriptions.size() > 0 ? descriptions.iterator().next() : null;
    }

    public void setPlanDescription(HealthBenefitPlanDescription description) {
        Set<HealthBenefitPlanDescription> descriptions = this.getInternalPlanDescriptions();
        Iterator<HealthBenefitPlanDescription> iter = descriptions.iterator();
        if (iter.hasNext()) {
            HealthBenefitPlanDescription o = iter.next();
            descriptions.remove(o);
            o.setPlanDefinition(null);
        }
        if (description != null) {
            descriptions.add(description);
            description.setPlanDefinition(this);
        }
    }

    @Override
    public int compareTo(HealthBenefitPlanDefinition o) {
        if (o != null) {
            if (!StringUtils.isEmpty((String)this.getCoverageCode())) {
                return this.getCoverageCode().compareTo(o.getCoverageCode());
            }
            if (!StringUtils.isEmpty((String)o.getCoverageCode())) {
                return -1;
            }
            return this.getPlanDescription().compareTo(o.getPlanDescription());
        }
        return 1;
    }

    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("planCode", (Object)this.planCode);
        builder.append("coverageCode", (Object)this.coverageCode);
        builder.append("description", (Object)this.getPlanDescription());
        builder.append("effectiveDate", (Object)this.effectiveDate);
        builder.append("expirationDate", (Object)this.expirationDate);
        builder.append("automated", (Object)this.automated);
    }
}

