/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.financials;

import gov.va.med.fw.model.AbstractKeyedEntity;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.time.DateUtils;

public class RelaxationPercentage
extends AbstractKeyedEntity {
    private static final long serialVersionUID = -3985020019182988848L;
    private BigDecimal value;
    private int incomeYear;
    private Date referenceStartDate;
    private Date referenceEndDate;

    RelaxationPercentage() {
    }

    public RelaxationPercentage(BigDecimal value, int incomeYear) {
        this.value = value;
        this.incomeYear = incomeYear;
        this.resetReferenceDatesBasedOnIncomeYear();
    }

    private void resetReferenceDatesBasedOnIncomeYear() {
        Calendar c = Calendar.getInstance();
        c.set(1, this.incomeYear + 1);
        c.set(6, c.getActualMinimum(6));
        c = DateUtils.truncate((Calendar)c, (int)5);
        this.referenceStartDate = c.getTime();
        c.set(6, c.getActualMaximum(6));
        c = DateUtils.truncate((Calendar)c, (int)5);
        this.referenceEndDate = c.getTime();
    }

    public String getValueForDisplay() {
        return this.value.toString() + "%";
    }

    public BigDecimal getMultiplicand() {
        return this.value.movePointLeft(2);
    }

    protected void buildToString(ToStringBuilder builder) {
        builder.append("incomeYear", this.incomeYear).append("value", (Object)this.getValueForDisplay()).append("referenceStartDate", (Object)this.referenceStartDate).append("referenceEndDate", (Object)this.referenceEndDate);
    }

    public int getIncomeYear() {
        return this.incomeYear;
    }

    public void setIncomeYear(int incomeYear) {
        this.incomeYear = incomeYear;
        this.resetReferenceDatesBasedOnIncomeYear();
    }

    public Date getReferenceEndDate() {
        return this.referenceEndDate;
    }

    protected void setReferenceEndDate(Date referenceEndDate) {
        this.referenceEndDate = referenceEndDate;
    }

    public Date getReferenceStartDate() {
        return this.referenceStartDate;
    }

    protected void setReferenceStartDate(Date referenceStartDate) {
        this.referenceStartDate = referenceStartDate;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public void setValue(BigDecimal value) {
        this.value = value;
    }
}

