/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.financials;

import gov.va.med.esr.common.model.financials.Financial;
import gov.va.med.esr.common.model.lookup.IncomeType;
import java.math.BigDecimal;
import java.util.Collection;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Income
extends Financial {
    private static final long serialVersionUID = -6382825487732311040L;
    private IncomeType type = null;

    public Income() {
    }

    public Income(BigDecimal amount) {
        super(amount);
    }

    public IncomeType getType() {
        return this.type;
    }

    protected void setType(IncomeType type) {
        this.type = type;
    }

    @Override
    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("type", (Object)this.type);
    }

    public static Income getIncomeOfType(Collection incomes, IncomeType.Code typeCode) {
        Validate.notNull((Object)incomes, (String)"The set of incomes must not be null");
        Validate.notNull((Object)((Object)typeCode), (String)"Income type code must not be null");
        for (Income income : incomes) {
            IncomeType incomeType = income.getType();
            if (incomeType == null || !incomeType.getCode().equals(typeCode.getName())) continue;
            return income;
        }
        return null;
    }
}

