/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.financials;

import gov.va.med.esr.common.model.financials.DependentFinancials;
import gov.va.med.esr.common.model.financials.FinancialInformation;
import gov.va.med.esr.common.model.financials.RelationFinancials;
import gov.va.med.esr.common.model.financials.SpouseFinancials;
import gov.va.med.esr.common.model.person.Dependent;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.Spouse;
import gov.va.med.fw.model.EntityKey;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class FinancialStatement
extends FinancialInformation {
    public static final Boolean DEFAULT_POST_2005_FORMAT = Boolean.TRUE;
    private Boolean marriedLastCalendarYear = Boolean.FALSE;
    private BigDecimal contributionToSpouse = null;
    private Boolean contributedToSpouseInd = null;
    private Boolean isPost2005Format = DEFAULT_POST_2005_FORMAT;
    private Integer numberOfDependentChildren = null;
    private Set internalSpouseFinancials = null;
    private Set internalDependentFinancials = null;
    private static final long serialVersionUID = -3030234876682631782L;

    public FinancialStatement() {
    }

    public FinancialStatement(Person person, Integer incomeYear) {
        this();
        this.setPerson(person);
        this.setIncomeYear(incomeYear);
    }

    @Override
    public void setPerson(Person person) {
        super.setPerson(person);
        this.setBackReferences(person, this.getIncomeYear());
    }

    @Override
    public Integer getIncomeYear() {
        return super.getIncomeYear();
    }

    @Override
    public void setIncomeYear(Integer incomeYear) {
        super.setIncomeYear(incomeYear);
        this.setBackReferences(this.getPerson(), incomeYear);
    }

    public Boolean getMarriedLastCalendarYear() {
        return this.marriedLastCalendarYear;
    }

    public void setMarriedLastCalendarYear(Boolean marriedLastCalendarYear) {
        this.marriedLastCalendarYear = marriedLastCalendarYear;
    }

    public BigDecimal getContributionToSpouse() {
        return this.contributionToSpouse;
    }

    public void setContributionToSpouse(BigDecimal contributionToSpouse) {
        this.contributionToSpouse = contributionToSpouse;
    }

    public Integer getNumberOfDependentChildren() {
        return this.numberOfDependentChildren;
    }

    public void setNumberOfDependentChildren(Integer numberOfDependentChildren) {
        this.numberOfDependentChildren = numberOfDependentChildren;
    }

    public Boolean getIsPost2005Format() {
        return this.isPost2005Format;
    }

    public void setIsPost2005Format(Boolean isPost2005Format) {
        this.isPost2005Format = isPost2005Format;
    }

    private Set getInternalSpouseFinancials() {
        if (this.internalSpouseFinancials == null) {
            this.internalSpouseFinancials = new HashSet();
        }
        return this.internalSpouseFinancials;
    }

    private void setInternalSpouseFinancials(Set internalSpouseFinancials) {
        this.internalSpouseFinancials = internalSpouseFinancials;
    }

    public Set getSpouseFinancials() {
        return Collections.unmodifiableSet(this.getInternalSpouseFinancials());
    }

    public SpouseFinancials getActiveSpouseFinancials() {
        Set financials = this.getInternalSpouseFinancials();
        for (SpouseFinancials spouseFinancials : financials) {
            if (!spouseFinancials.isActive()) continue;
            return spouseFinancials;
        }
        return null;
    }

    public SpouseFinancials getRecentSpouseFinancials() {
        Set financials = this.getInternalSpouseFinancials();
        SpouseFinancials sf = null;
        if (financials.size() > 0) {
            if (financials.size() == 1) {
                return (SpouseFinancials)((Object)financials.iterator().next());
            }
            sf = this.getActiveSpouseFinancials();
            if (sf != null) {
                return sf;
            }
            Iterator iter = financials.iterator();
            sf = (SpouseFinancials)((Object)iter.next());
            while (iter.hasNext()) {
                SpouseFinancials spouseFinancials = (SpouseFinancials)((Object)iter.next());
                if (!spouseFinancials.getEndDate().after(sf.getEndDate())) continue;
                sf = spouseFinancials;
            }
        }
        return sf;
    }

    public SpouseFinancials getSpouseFinancialsByEntityKey(EntityKey entityKey) {
        return (SpouseFinancials)FinancialStatement.getEntityByEntityKey((Collection)this.getInternalSpouseFinancials(), (EntityKey)entityKey);
    }

    public void removeActiveSpouseFinancials() {
        SpouseFinancials spouseFinancials = this.getActiveSpouseFinancials();
        if (spouseFinancials != null) {
            this.removeSpouseFinancials(spouseFinancials);
        }
    }

    public void removeSpouseFinancials(SpouseFinancials spouseFinancials) {
        Validate.notNull((Object)((Object)spouseFinancials), (String)"Null spouse financials specified.");
        this.getInternalSpouseFinancials().remove((Object)spouseFinancials);
        ArrayList<SpouseFinancials> stList = new ArrayList<SpouseFinancials>();
        for (SpouseFinancials tempSf : this.getInternalSpouseFinancials()) {
            if ((spouseFinancials.getEntityKey() == null || tempSf.getEntityKey() == null || spouseFinancials.getEntityKey().equals(tempSf.getEntityKey())) && spouseFinancials == tempSf && spouseFinancials.equals((Object)tempSf)) continue;
            stList.add(tempSf);
        }
        this.getInternalSpouseFinancials().clear();
        this.getInternalSpouseFinancials().addAll(stList);
        spouseFinancials.setFinancialStatement(null);
        spouseFinancials.setPerson(null);
    }

    public void removeSpouseFinancials() {
        Set financials = this.getInternalSpouseFinancials();
        financials.clear();
    }

    public void addSpouseFinancials(SpouseFinancials spouseFinancials) {
        Validate.notNull((Object)((Object)spouseFinancials), (String)"SpouseFinancials information cannot be null");
        this.getInternalSpouseFinancials().add(spouseFinancials);
        this.setRelationFinancialsBackReference(spouseFinancials);
    }

    private void setRelationFinancialsBackReference(RelationFinancials relationFinancials) {
        relationFinancials.setFinancialStatement(this);
        relationFinancials.setIncomeYear(this.getIncomeYear());
        relationFinancials.setPerson(this.getPerson());
    }

    private Set getInternalDependentFinancials() {
        if (this.internalDependentFinancials == null) {
            this.internalDependentFinancials = new HashSet();
        }
        return this.internalDependentFinancials;
    }

    private void setInternalDependentFinancials(Set internalDependentFinancials) {
        this.internalDependentFinancials = internalDependentFinancials;
    }

    public Set getDependentFinancials() {
        return Collections.unmodifiableSet(this.getInternalDependentFinancials());
    }

    public DependentFinancials getDependentFinancialsByEntityKey(EntityKey identifier) {
        return (DependentFinancials)FinancialStatement.getEntityByEntityKey((Collection)this.getDependentFinancials(), (EntityKey)identifier);
    }

    public void addDependentFinancials(DependentFinancials dependentFinancials) {
        Validate.notNull((Object)((Object)dependentFinancials), (String)"DependentFinancials information cannot be null");
        this.getInternalDependentFinancials().add(dependentFinancials);
        dependentFinancials.setFinancialStatement(this);
        dependentFinancials.setIncomeYear(this.getIncomeYear());
        dependentFinancials.setPerson(this.getPerson());
    }

    public void removeDependentFinancials(DependentFinancials dependentFinancials) {
        Validate.notNull((Object)((Object)dependentFinancials), (String)"DependentFinancials information cannot be null");
        ArrayList<DependentFinancials> stList = new ArrayList<DependentFinancials>();
        for (DependentFinancials tempDf : this.getInternalDependentFinancials()) {
            if ((dependentFinancials.getEntityKey() == null || tempDf.getEntityKey() == null || dependentFinancials.getEntityKey().equals(tempDf.getEntityKey())) && dependentFinancials == tempDf && dependentFinancials.equals((Object)tempDf)) continue;
            stList.add(tempDf);
        }
        this.getInternalDependentFinancials().clear();
        this.getInternalDependentFinancials().addAll(stList);
        dependentFinancials.setFinancialStatement(null);
        dependentFinancials.setPerson(null);
    }

    public void removeSpouseFinancials(Set dfSet) {
        if (dfSet != null && dfSet.size() > 0) {
            Iterator iter = dfSet.iterator();
            while (iter.hasNext()) {
                this.removeSpouseFinancials((SpouseFinancials)((Object)iter.next()));
            }
        }
    }

    public void removeDependentFinancials(Set dfSet) {
        if (dfSet != null) {
            Iterator iter = dfSet.iterator();
            while (iter.hasNext()) {
                this.removeDependentFinancials((DependentFinancials)((Object)iter.next()));
            }
        }
    }

    public void removeAllDependentFinancials() {
        this.getInternalDependentFinancials().clear();
    }

    public Boolean getContributedToSpouseInd() {
        return this.contributedToSpouseInd;
    }

    public void setContributedToSpouseInd(Boolean contributedToSpouseInd) {
        this.contributedToSpouseInd = contributedToSpouseInd;
    }

    private void setBackReferences(Person person, Integer incomeYear) {
        this.setSpousesBackReference(person, incomeYear);
        this.setDependentsBackReference(person, incomeYear);
    }

    private void setSpousesBackReference(Person person, Integer incomeYear) {
        if (this.internalSpouseFinancials != null) {
            Set spouseFinancials = this.getInternalSpouseFinancials();
            for (SpouseFinancials spouseFinancial : spouseFinancials) {
                this.setRelationFinancialsBackReference(spouseFinancial);
                Spouse reportedOn = spouseFinancial.getReportedOn();
                if (reportedOn == null) continue;
                reportedOn.setPerson(person);
            }
        }
    }

    private void setDependentsBackReference(Person person, Integer incomeYear) {
        if (this.internalDependentFinancials != null) {
            Set dependentFinancials = this.getInternalDependentFinancials();
            for (DependentFinancials dependentFinancial : dependentFinancials) {
                this.setRelationFinancialsBackReference(dependentFinancial);
                Dependent reportedOn = dependentFinancial.getReportedOn();
                if (reportedOn == null) continue;
                reportedOn.setPerson(person);
            }
        }
    }

    @Override
    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("marriedLastCalendarYear", (Object)this.marriedLastCalendarYear);
        builder.append("contributionToSpouse", (Object)this.contributionToSpouse);
        builder.append("numberOfDependentChildren", (Object)this.numberOfDependentChildren);
        builder.append("isPost2005Format", (Object)this.isPost2005Format);
    }
}

