/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.financials;

import gov.va.med.esr.common.model.financials.Asset;
import gov.va.med.esr.common.model.financials.Debt;
import gov.va.med.esr.common.model.financials.Expense;
import gov.va.med.esr.common.model.financials.Income;
import gov.va.med.esr.common.model.lookup.AssetType;
import gov.va.med.esr.common.model.lookup.ExpenseType;
import gov.va.med.esr.common.model.lookup.IncomeType;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.util.CommonDateUtils;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.util.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public abstract class FinancialInformation
extends AbstractKeyedEntity {
    private static final long serialVersionUID = -1370346746640850300L;
    private Person person = null;
    private Integer incomeYear = null;
    private Map internalAssets = null;
    private Map internalExpenses = null;
    private Map internalIncomes = null;
    private Set internalDebts = null;

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.validateOwner(this.person, person);
        this.person = person;
    }

    public Integer getIncomeYear() {
        return this.incomeYear;
    }

    protected void setIncomeYear(Integer incomeYear) {
        this.incomeYear = incomeYear;
    }

    private Map getInternalAssets() {
        if (this.internalAssets == null) {
            this.internalAssets = new HashMap();
        }
        return this.internalAssets;
    }

    private void resetAssetIfIncomeYear2009OrLatter(Map assets) {
        if (CommonDateUtils.isIncomeYear2009OrLatter(this.incomeYear)) {
            for (AssetType type : assets.keySet()) {
                this.discontinueAsset(type, (Asset)((Object)assets.get((Object)type)));
            }
        }
    }

    private void setInternalAssets(Map internalAssets) {
        this.internalAssets = internalAssets;
    }

    public Asset getCashAndBankAccountBalances() {
        return this.getAsset(AssetType.CODE_CASH);
    }

    public Asset getRealEstate() {
        return this.getAsset(AssetType.CODE_REAL_ESTATE);
    }

    public Asset getOtherPropertyOrAssets() {
        return this.getAsset(AssetType.CODE_OTHER);
    }

    public Map getAssets() {
        return Collections.unmodifiableMap(this.getInternalAssets());
    }

    public Asset getAsset(AssetType.Code typeCode) {
        for (AssetType type : this.getInternalAssets().keySet()) {
            if (!StringUtils.equals((String)type.getCode(), (String)typeCode.getCode())) continue;
            return this.getAsset(type);
        }
        return null;
    }

    public Asset getAsset(AssetType type) {
        return (Asset)((Object)this.getInternalAssets().get((Object)type));
    }

    public void setAsset(AssetType type, Asset asset) {
        this.setAsset(this.incomeYear, type, asset);
    }

    public void setAsset(Integer incomeYear, AssetType type, Asset asset) {
        Validate.notNull((Object)((Object)type), (String)"AssetType cannot be null");
        Asset currentAsset = this.getAsset(type);
        if (currentAsset != asset) {
            if (currentAsset != null) {
                this.getInternalAssets().remove((Object)type);
            }
            if (asset != null) {
                this.getInternalAssets().put(type, asset);
                asset.setFinancialInformation(this);
                asset.setType(type);
            }
        }
    }

    private void discontinueAsset(AssetType type, Asset asset) {
        if (AssetType.CODE_CASH.getCode().equals(type.getCode()) || AssetType.CODE_REAL_ESTATE.getCode().equals(type.getCode()) || AssetType.CODE_OTHER.getCode().equals(type.getCode())) {
            asset.setAmount(null);
        }
    }

    private Set getInternalDebts() {
        if (this.internalDebts == null) {
            this.internalDebts = new HashSet();
        }
        return this.internalDebts;
    }

    private void setInternalDebts(Set internalDebts) {
        this.internalDebts = internalDebts;
    }

    public Debt getDebt() {
        Set debts = this.getInternalDebts();
        if (debts.size() > 0) {
            return (Debt)((Object)this.getInternalDebts().iterator().next());
        }
        return null;
    }

    public void setDebt(Debt debt) {
        Set debts = this.getInternalDebts();
        debts.clear();
        if (debt != null) {
            this.getInternalDebts().add(debt);
            debt.setFinancialInformation(this);
        }
    }

    private Map getInternalExpenses() {
        if (this.internalExpenses == null) {
            this.internalExpenses = new HashMap();
        }
        return this.internalExpenses;
    }

    private void setInternalExpenses(Map internalExpenses) {
        this.internalExpenses = internalExpenses;
    }

    public Map getExpenses() {
        return Collections.unmodifiableMap(this.getInternalExpenses());
    }

    public Expense getExpense(ExpenseType type) {
        return (Expense)((Object)this.getInternalExpenses().get((Object)type));
    }

    public Expense getVeteranEducationExpense() {
        return this.getExpense(ExpenseType.EXPENSE_TYPE_COLLEGE_AND_VOCATION);
    }

    public Expense getEducationExpense() {
        return this.getExpense(ExpenseType.EXPENSE_TYPE_EDUCATIONAL_EXPENSES_BY_DEPENDENT);
    }

    public Expense getNonReimbursableExpense() {
        return this.getExpense(ExpenseType.EXPENSE_TYPE_NON_REIMBURSED_MEDICAL);
    }

    public Expense getAdjustedMedicalExpense() {
        return this.getExpense(ExpenseType.EXPENSE_TYPE_ADJUSTED_MEDICAL);
    }

    public Expense getFuneralBurialExpense() {
        return this.getExpense(ExpenseType.EXPENSE_TYPE_FUNERAL_AND_BURIAL);
    }

    public Expense getExpense(ExpenseType.Code typeCode) {
        for (ExpenseType type : this.getInternalExpenses().keySet()) {
            if (!StringUtils.equals((String)type.getCode(), (String)typeCode.getCode())) continue;
            return this.getExpense(type);
        }
        return null;
    }

    public void setExpense(ExpenseType type, Expense expense) {
        Validate.notNull((Object)((Object)type), (String)"ExpenseType cannot be null");
        Expense currentExpense = this.getExpense(type);
        if (currentExpense != expense) {
            if (currentExpense != null) {
                this.getInternalExpenses().remove((Object)type);
            }
            if (expense != null) {
                this.getInternalExpenses().put(type, expense);
                expense.setFinancialInformation(this);
                expense.setType(type);
            }
        }
    }

    private Map getInternalIncomes() {
        if (this.internalIncomes == null) {
            this.internalIncomes = new HashMap();
        }
        return this.internalIncomes;
    }

    private void setInternalIncomes(Map internalIncomes) {
        this.internalIncomes = internalIncomes;
    }

    public Map getIncomes() {
        return Collections.unmodifiableMap(this.getInternalIncomes());
    }

    public Map getIncome() {
        return Collections.unmodifiableMap(this.getInternalIncomes());
    }

    public Income getTotalEmploymentIncome() {
        return this.getIncome(IncomeType.INCOME_TYPE_TOTAL_INCOME_FROM_EMPLOYMENT);
    }

    public Income getFarmRanchBusinessIncome() {
        return this.getIncome(IncomeType.INCOME_TYPE_FARM_RANCH_PROPERTY_OR_BUSINESS_INCOME);
    }

    public Income getOtherIncome() {
        return this.getIncome(IncomeType.INCOME_TYPE_TOTAL_ALL_OTHER_INCOME);
    }

    public Income getIncome(IncomeType type) {
        return (Income)((Object)this.getInternalIncomes().get((Object)type));
    }

    public Income getIncome(IncomeType.Code typeCode) {
        for (IncomeType type : this.getInternalIncomes().keySet()) {
            if (!StringUtils.equals((String)type.getCode(), (String)typeCode.getCode())) continue;
            return this.getIncome(type);
        }
        return null;
    }

    public void setIncome(IncomeType type, Income income) {
        Validate.notNull((Object)((Object)type), (String)"IncomeType cannot be null");
        Income currentIncome = this.getIncome(type);
        if (currentIncome != income) {
            if (currentIncome != null) {
                this.getInternalIncomes().remove((Object)type);
            }
            if (income != null) {
                this.getInternalIncomes().put(type, income);
                income.setFinancialInformation(this);
                income.setType(type);
            }
        }
    }

    public void addIncome(IncomeType type, Income income) {
        this.setIncome(type, income);
    }

    public void addAsset(AssetType type, Asset asset) {
        this.setAsset(type, asset);
    }

    public void addExpense(ExpenseType type, Expense expense) {
        this.setExpense(type, expense);
    }

    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("incomeYear", (Object)this.incomeYear);
    }
}

