/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.financials;

import gov.va.med.esr.common.model.financials.Financial;
import gov.va.med.esr.common.model.lookup.AssetType;
import java.math.BigDecimal;
import java.util.Collection;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Asset
extends Financial {
    private static final long serialVersionUID = -4926096977860253675L;
    private AssetType type = null;

    public Asset() {
    }

    public Asset(BigDecimal amount) {
        super(amount);
    }

    public AssetType getType() {
        return this.type;
    }

    protected void setType(AssetType type) {
        this.type = type;
    }

    @Override
    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("type", (Object)this.type);
    }

    public static Asset getAssetOfType(Collection assets, AssetType.Code typeCode) {
        Validate.notNull((Object)assets, (String)"The set of assets must not be null");
        Validate.notNull((Object)((Object)typeCode), (String)"Asset type code must not be null");
        for (Asset asset : assets) {
            AssetType assetType = asset.getType();
            if (assetType == null || !assetType.getCode().equals(typeCode.getName())) continue;
            return asset;
        }
        return null;
    }
}

