/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.ee;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.workload.WorkflowCaseInfo;
import gov.va.med.fw.model.AbstractEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;

public class VerificationInfo
extends AbstractEntity {
    private static final long serialVersionUID = 1613147296614831932L;
    private String entitlementCode = null;
    private String messageType = null;
    private String dfn = null;
    private String textMessage = null;
    private List exceptions = null;
    private Integer combinedSCPercentage = null;
    private boolean triggerEnrollmentProcess = false;
    private boolean hasQualifyingMse = false;
    private String unsolicitedType = null;
    private WorkflowCaseInfo workflowCaseInfo = null;
    private String siteNumber = null;
    private String messageControlId = null;
    private ImpreciseDate msdsMessageDate = null;
    private boolean tempAddressUpdateMoreRecent = false;

    public VerificationInfo() {
        this(null, null);
    }

    public VerificationInfo(String messageType, String errorText) {
        this(null, messageType, errorText);
    }

    public VerificationInfo(String entitlementCode, String messageType, String errorText) {
        this(entitlementCode, messageType, errorText, null);
    }

    public VerificationInfo(String entitlementCode, String messageType, String errorText, Integer percentage) {
        this.entitlementCode = entitlementCode;
        this.messageType = messageType;
        this.textMessage = errorText;
        this.combinedSCPercentage = percentage;
        this.exceptions = Collections.synchronizedList(new ArrayList());
    }

    public String getEntitlementCode() {
        return this.entitlementCode;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public String getTextMessage() {
        return this.textMessage;
    }

    public void addException(Exception e) {
        if (e != null && !this.exceptions.contains(e)) {
            this.exceptions.add(e);
        }
    }

    public void removeException(Exception e) {
        if (e != null && this.exceptions.contains(e)) {
            this.exceptions.remove(e);
        }
    }

    public void clearExceptions() {
        this.exceptions.clear();
    }

    public void addExceptions(Collection list) {
        if (list != null) {
            this.exceptions.addAll(list);
        }
    }

    public List getExceptions() {
        return this.exceptions;
    }

    public Integer getCombinedSCPercentage() {
        return this.combinedSCPercentage;
    }

    public void setCombinedSCPercentage(Integer combinedSCPercentage) {
        this.combinedSCPercentage = combinedSCPercentage;
    }

    public String getDfn() {
        return this.dfn;
    }

    public void setDfn(String dfn) {
        this.dfn = dfn;
    }

    public boolean isTriggerEnrollmentProcess() {
        return this.triggerEnrollmentProcess;
    }

    public void setTriggerEnrollmentProcess(boolean triggerEnrollmentProcess) {
        this.triggerEnrollmentProcess = triggerEnrollmentProcess;
    }

    protected void buildToString(ToStringBuilder builder) {
        builder.append("context", (Object)this.messageType);
        builder.append("code", (Object)this.entitlementCode);
        builder.append("message", (Object)this.textMessage);
    }

    public WorkflowCaseInfo getWorkflowCaseInfo() {
        return this.workflowCaseInfo;
    }

    public void setWorkflowCaseInfo(WorkflowCaseInfo workflowCaseInfo) {
        this.workflowCaseInfo = workflowCaseInfo;
    }

    public String getUnsolicitedType() {
        return this.unsolicitedType;
    }

    public void setUnsolicitedType(String unsolicitedType) {
        this.unsolicitedType = unsolicitedType;
    }

    public String getSiteNumber() {
        return this.siteNumber;
    }

    public void setSiteNumber(String siteNumber) {
        this.siteNumber = siteNumber;
    }

    public String getMessageControlId() {
        return this.messageControlId;
    }

    public void setMessageControlId(String messageControlId) {
        this.messageControlId = messageControlId;
    }

    public boolean hasQualifyingMse() {
        return this.hasQualifyingMse;
    }

    public void setHasQualifyingMse(boolean hasQualifyingMse) {
        this.hasQualifyingMse = hasQualifyingMse;
    }

    public ImpreciseDate getMsdsMessageDate() {
        return this.msdsMessageDate;
    }

    public void setMsdsMessageDate(ImpreciseDate msdsMessageDate) {
        this.msdsMessageDate = msdsMessageDate;
    }

    public boolean isTempAddressUpdateMoreRecent() {
        return this.tempAddressUpdateMoreRecent;
    }

    public void setTempAddressUpdateMoreRecent(boolean tempAddressUpdateMoreRecent) {
        this.tempAddressUpdateMoreRecent = tempAddressUpdateMoreRecent;
    }
}

