/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.ee;

import gov.va.med.esr.common.model.ee.SHADDocument;
import gov.va.med.esr.common.model.lookup.Indicator;
import gov.va.med.esr.common.model.registry.Registry;
import gov.va.med.fw.model.EntityKey;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class SHAD
extends Registry {
    private static final long serialVersionUID = 8067965625445127187L;
    private Indicator shadIndicator = null;
    private String claimNumber;
    private Set internalDocuments = null;

    public Indicator getShadIndicator() {
        return this.shadIndicator;
    }

    public void setShadIndicator(Indicator shadIndicator) {
        this.shadIndicator = shadIndicator;
    }

    public String getClaimNumber() {
        return this.claimNumber;
    }

    public void setClaimNumber(String claimNumber) {
        this.claimNumber = claimNumber;
    }

    public Set getDocuments() {
        return Collections.unmodifiableSet(this.getInternalDocuments());
    }

    public void addDocument(SHADDocument document) {
        Validate.notNull((Object)((Object)document), (String)"document cannot be null");
        this.getInternalDocuments().add(document);
        document.setShad(this);
    }

    public void addAllDocuments(Set documents) {
        Validate.notEmpty((Collection)documents, (String)"SHAD documents cannot be null or empty");
        for (Object document : documents) {
            if (!(document instanceof SHADDocument)) continue;
            this.addDocument((SHADDocument)((Object)document));
        }
    }

    public void removeDocument(SHADDocument document) {
        Validate.notNull((Object)((Object)document), (String)"Document cannot be null");
        this.getInternalDocuments().remove((Object)document);
        document.setShad(null);
    }

    public SHADDocument getDocumentByEntityKey(EntityKey identifier) {
        return (SHADDocument)SHAD.getEntityByEntityKey((Collection)this.getDocuments(), (EntityKey)identifier);
    }

    public SHADDocument removeDocumentByEntityKey(EntityKey identifier) {
        return (SHADDocument)SHAD.removeEntityByEntityKey((Collection)this.getInternalDocuments(), (EntityKey)identifier);
    }

    public void removeAllDocuments() {
        this.getInternalDocuments().clear();
    }

    private Set getInternalDocuments() {
        if (this.internalDocuments == null) {
            this.internalDocuments = new HashSet();
        }
        return this.internalDocuments;
    }

    private void setInternalDocuments(Set internalDocuments) {
        this.internalDocuments = internalDocuments;
    }

    @Override
    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder.append("shadIndicator", (Object)this.shadIndicator).append("claimNumber", (Object)this.claimNumber));
    }
}

