/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.ee;

import gov.va.med.esr.common.model.ee.POWEpisode;
import gov.va.med.esr.common.model.lookup.Indicator;
import gov.va.med.esr.common.model.registry.Registry;
import gov.va.med.fw.model.EntityKey;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class PrisonerOfWar
extends Registry {
    private static final long serialVersionUID = -7790636942564256641L;
    private Indicator powIndicator = null;
    private String icn = null;
    private String user = null;
    private Date dateEntered = null;
    private Set internalEpisodes = null;

    public Indicator getPowIndicator() {
        return this.powIndicator;
    }

    public void setPowIndicator(Indicator powIndicator) {
        this.powIndicator = powIndicator;
    }

    public String getIcn() {
        return this.icn;
    }

    public void setIcn(String icn) {
        this.icn = icn;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public Date getDateEntered() {
        return this.dateEntered;
    }

    public void setDateEntered(Date dateEntered) {
        this.dateEntered = dateEntered;
    }

    public Set getEpisodes() {
        return Collections.unmodifiableSet(this.getInternalEpisodes());
    }

    public void addEpisode(POWEpisode episode) {
        Validate.notNull((Object)((Object)episode), (String)"episode cannot be null");
        this.getInternalEpisodes().add(episode);
        episode.setPrisonerOfWar(this);
    }

    public void addAllEpisodes(Set episodes) {
        Validate.notEmpty((Collection)episodes, (String)"POW episodes cannot be null or empty");
        for (Object episode : episodes) {
            if (!(episode instanceof POWEpisode)) continue;
            this.addEpisode((POWEpisode)((Object)episode));
        }
    }

    public void removeEpisode(POWEpisode episode) {
        Validate.notNull((Object)((Object)episode), (String)"Episode cannot be null");
        this.getInternalEpisodes().remove((Object)episode);
        episode.setPrisonerOfWar(null);
    }

    public POWEpisode getEpisodeByEntityKey(EntityKey identifier) {
        return (POWEpisode)PrisonerOfWar.getEntityByEntityKey((Collection)this.getEpisodes(), (EntityKey)identifier);
    }

    public POWEpisode removeEpisodeByEntityKey(EntityKey identifier) {
        return (POWEpisode)PrisonerOfWar.removeEntityByEntityKey((Collection)this.getInternalEpisodes(), (EntityKey)identifier);
    }

    public void removeAllEpisodes() {
        this.getInternalEpisodes().clear();
    }

    private Set getInternalEpisodes() {
        if (this.internalEpisodes == null) {
            this.internalEpisodes = new HashSet();
        }
        return this.internalEpisodes;
    }

    private void setInternalEpisodes(Set internalEpisodes) {
        this.internalEpisodes = internalEpisodes;
    }

    @Override
    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("powIndicator", (Object)this.powIndicator);
        builder.append("legacyICN", (Object)this.icn);
        builder.append("legacyUserName", (Object)this.user);
        builder.append("legacyEnteredDate", (Object)this.dateEntered);
    }
}

