/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.ee;

import gov.va.med.esr.common.model.ee.ConflictExperience;
import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.common.model.ee.MilitaryServiceEpisode;
import gov.va.med.esr.common.model.lookup.FilipinoVeteranProof;
import gov.va.med.esr.common.model.lookup.ServicePeriod;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.model.EntityKey;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections.set.UnmodifiableSet;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class MilitaryServiceSiteRecord
extends AbstractKeyedEntity {
    private static final long serialVersionUID = 906614410400008170L;
    private MilitaryService militaryService;
    private VAFacility site;
    private ServicePeriod servicePeriod = null;
    private FilipinoVeteranProof filipinoVeteranProof = null;
    private Set internalMilitaryServiceEpisodes = null;
    private Set internalConflictExperiences = null;

    public VAFacility getSite() {
        return this.site;
    }

    public void setSite(VAFacility site) {
        this.site = site;
    }

    public ServicePeriod getServicePeriod() {
        return this.servicePeriod;
    }

    public void setServicePeriod(ServicePeriod periodOfService) {
        this.servicePeriod = periodOfService;
    }

    public FilipinoVeteranProof getFilipinoVeteranProof() {
        return this.filipinoVeteranProof;
    }

    public void setFilipinoVeteranProof(FilipinoVeteranProof filipinoVeteranProof) {
        this.filipinoVeteranProof = filipinoVeteranProof;
    }

    private void setInternalMilitaryServiceEpisodes(Set militaryServiceEpisodes) {
        this.internalMilitaryServiceEpisodes = militaryServiceEpisodes;
    }

    private Set getInternalMilitaryServiceEpisodes() {
        if (this.internalMilitaryServiceEpisodes == null) {
            this.internalMilitaryServiceEpisodes = new HashSet();
        }
        return this.internalMilitaryServiceEpisodes;
    }

    public Set getMilitaryServiceEpisodes() {
        return UnmodifiableSet.decorate((Set)this.getInternalMilitaryServiceEpisodes());
    }

    public void addMilitaryServiceEpisode(MilitaryServiceEpisode militaryServiceEpisode) {
        this.getInternalMilitaryServiceEpisodes().add(militaryServiceEpisode);
        militaryServiceEpisode.setMilitaryServiceSiteRecord(this);
    }

    public void removeMilitaryServiceEpisode(MilitaryServiceEpisode militaryServiceEpisode) {
        Validate.notNull((Object)((Object)militaryServiceEpisode), (String)"Null Military Service Episode Record specified.");
        this.getInternalMilitaryServiceEpisodes().remove((Object)militaryServiceEpisode);
        militaryServiceEpisode.setMilitaryServiceSiteRecord(null);
    }

    public MilitaryServiceEpisode getMilitaryServiceEpisodeByEntityKey(EntityKey identifier) {
        return (MilitaryServiceEpisode)MilitaryServiceSiteRecord.getEntityByEntityKey((Collection)this.getMilitaryServiceEpisodes(), (EntityKey)identifier);
    }

    public MilitaryServiceEpisode removeMilitaryServiceEpisodeByEntityKey(EntityKey identifier) {
        return (MilitaryServiceEpisode)MilitaryServiceSiteRecord.removeEntityByEntityKey((Collection)this.getInternalMilitaryServiceEpisodes(), (EntityKey)identifier);
    }

    public void removeAllMilitaryServiceEpisodes() {
        this.getInternalMilitaryServiceEpisodes().clear();
    }

    public void addAllMilitaryServiceEpisodes(Set episodes) {
        Validate.notEmpty((Collection)episodes, (String)"MilitaryServiceEpisodes cannot be null or empty");
        for (Object episode : episodes) {
            if (!(episode instanceof MilitaryServiceEpisode)) continue;
            this.addMilitaryServiceEpisode((MilitaryServiceEpisode)((Object)episode));
        }
    }

    private void setInternalConflictExperiences(Set conflictExperiences) {
        this.internalConflictExperiences = conflictExperiences;
    }

    private Set getInternalConflictExperiences() {
        if (this.internalConflictExperiences == null) {
            this.internalConflictExperiences = new HashSet();
        }
        return this.internalConflictExperiences;
    }

    public Set getConflictExperiences() {
        return UnmodifiableSet.decorate((Set)this.getInternalConflictExperiences());
    }

    public void addConflictExperience(ConflictExperience conflictExperience) {
        this.getInternalConflictExperiences().add(conflictExperience);
        conflictExperience.setMilitaryServiceSiteRecord(this);
    }

    public void addAllConflictExperiences(Set conflictExperiences) {
        Validate.notEmpty((Collection)conflictExperiences, (String)"ConflictExperiences cannot be null or empty");
        for (Object conflictExperience : conflictExperiences) {
            if (!(conflictExperience instanceof ConflictExperience)) continue;
            this.addConflictExperience((ConflictExperience)((Object)conflictExperience));
        }
    }

    public void removeConflictExperience(ConflictExperience conflictExperience) {
        Validate.notNull((Object)((Object)conflictExperience), (String)"Null Combat Experience Record specified.");
        this.getInternalConflictExperiences().remove((Object)conflictExperience);
        conflictExperience.setMilitaryServiceSiteRecord(null);
    }

    public ConflictExperience getConflictExperienceByEntityKey(EntityKey identifier) {
        return (ConflictExperience)MilitaryServiceSiteRecord.getEntityByEntityKey((Collection)this.getConflictExperiences(), (EntityKey)identifier);
    }

    public ConflictExperience removeConflictExperienceByEntityKey(EntityKey identifier) {
        return (ConflictExperience)MilitaryServiceSiteRecord.removeEntityByEntityKey((Collection)this.getInternalConflictExperiences(), (EntityKey)identifier);
    }

    public void removeAllConflictExperiences() {
        this.getInternalConflictExperiences().clear();
    }

    public boolean isEmpty() {
        return !(this.servicePeriod != null || this.filipinoVeteranProof != null || this.internalMilitaryServiceEpisodes != null && !this.internalMilitaryServiceEpisodes.isEmpty() || this.internalConflictExperiences != null && !this.internalConflictExperiences.isEmpty());
    }

    protected void buildToString(ToStringBuilder builder) {
        builder.append("site", (Object)this.site).append("servicePeriod", (Object)this.servicePeriod).append("filipinoVeteranProof", (Object)this.filipinoVeteranProof).append("internalMilitaryServiceEpisodes", (Object)this.internalMilitaryServiceEpisodes).append("internalConflictExperiences", (Object)this.internalConflictExperiences);
    }

    public MilitaryService getMilitaryService() {
        return this.militaryService;
    }

    public void setMilitaryService(MilitaryService militaryService) {
        this.validateOwner(this.militaryService, militaryService);
        this.militaryService = militaryService;
    }

    public Person getPerson() {
        return this.militaryService == null ? null : this.militaryService.getPerson();
    }

    private void setPerson(Person person) {
        this.militaryService = person == null ? null : person.getMilitaryService();
    }
}

