/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.ee;

import gov.va.med.esr.common.model.ee.HealthBenefitPlan;
import gov.va.med.esr.common.model.lookup.HealthBenefitPlanType;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.util.StringUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class HealthBenefitProfile
extends AbstractKeyedEntity {
    private static final long serialVersionUID = -7960496306058390416L;
    private Person person;
    private Set internalHealthBenefitPlans = null;

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.validateOwner(this.person, person);
        this.person = person;
    }

    public Set getHealthBenefitPlans() {
        return Collections.unmodifiableSet(this.getInternalHealthBenefitPlans());
    }

    public boolean containsHealthBenefitPlans() {
        Set plans = this.getInternalHealthBenefitPlans();
        return plans != null && plans.size() > 0;
    }

    private Set getInternalHealthBenefitPlans() {
        if (this.internalHealthBenefitPlans == null) {
            this.internalHealthBenefitPlans = new HashSet();
        }
        return this.internalHealthBenefitPlans;
    }

    private void setInternalHealthBenefitPlans(Set internalHealthBenefitPlans) {
        this.internalHealthBenefitPlans = internalHealthBenefitPlans;
    }

    public void addHealthBenefitPlan(HealthBenefitPlan plan) {
        Validate.notNull((Object)plan, (String)"HealthBenefitPlan cannot be null");
        if (this.getHealthBenefitPlanByType(plan.getPlanType()) == null) {
            plan.setHealthBenefitProfile(this);
            this.getInternalHealthBenefitPlans().add(plan);
        }
    }

    public void removeAllHealthBenefitPlans() {
        this.getInternalHealthBenefitPlans().clear();
    }

    public void removeHealthBenefitPlan(HealthBenefitPlan healthBenefitPlan) {
        Validate.notNull((Object)healthBenefitPlan, (String)"Health Benefit Plan cannot be null");
        this.removeHealthBenefitPlanByType(healthBenefitPlan.getPlanType());
    }

    public void removeHealthBenefitPlans(Collection removePlans) {
        if (removePlans != null && removePlans.size() <= 0) {
            return;
        }
        for (HealthBenefitPlan plan : removePlans) {
            this.removeHealthBenefitPlan(plan);
        }
    }

    public HealthBenefitPlan getHealthBenefitPlanByType(HealthBenefitPlanType planType) {
        Validate.notNull((Object)((Object)planType), (String)"HealthBenefitPlanType connot be null");
        return this.getHealthBenefitPlanByType(planType.getCode());
    }

    private HealthBenefitPlan getHealthBenefitPlanByType(HealthBenefitPlanType.Code planType) {
        Validate.notNull((Object)((Object)planType), (String)"HealthBenefitPlanType connot be null");
        return this.getHealthBenefitPlanByType(planType.getCode());
    }

    private HealthBenefitPlan getHealthBenefitPlanByType(String typeCode) {
        if (StringUtils.isNotEmpty((String)typeCode)) {
            for (HealthBenefitPlan plan : this.getInternalHealthBenefitPlans()) {
                String planType = plan != null && plan.getPlanType() != null ? plan.getPlanType().getCode() : null;
                if (!StringUtils.equals(planType, (String)typeCode)) continue;
                return plan;
            }
        }
        return null;
    }

    public void removeHealthBenefitPlanByType(HealthBenefitPlanType planType) {
        Validate.notNull((Object)((Object)planType), (String)"HealthBenefitPlanType connot be null");
        HealthBenefitPlan plan = this.getHealthBenefitPlanByType(planType);
        if (plan != null) {
            this.internalHealthBenefitPlans.remove(plan);
        }
    }

    private void removeHealthBenefitPlanByType(HealthBenefitPlanType.Code planType) {
        Validate.notNull((Object)((Object)planType), (String)"HealthBenefitPlanType connot be null");
        HealthBenefitPlan plan = this.getHealthBenefitPlanByType(planType.getCode());
        if (plan != null) {
            this.internalHealthBenefitPlans.remove(plan);
        }
    }
}

