/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.ee;

import gov.va.med.esr.common.model.ee.AbstractEnrollment;
import gov.va.med.esr.common.model.ee.EGTSetting;
import gov.va.med.esr.common.model.ee.Eligibility;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class EnrollmentDetermination
extends AbstractEnrollment {
    private static final long serialVersionUID = -7955554419785801336L;
    private Set internalPrimaryEligibilities = null;
    private Set internalSecondaryEligibilities = null;
    private Set internalOtherEligibilities = null;
    private EGTSetting egtSetting = null;

    public void setIdentifier(Serializable identifier) {
        super.setIdentifier(identifier);
    }

    public Eligibility getPrimaryEligibility() {
        Set eligibilities = this.getInternalPrimaryEligibilities();
        if (eligibilities.size() > 0) {
            return (Eligibility)this.internalPrimaryEligibilities.iterator().next();
        }
        return null;
    }

    public void setPrimaryEligiblity(Eligibility primaryEligibility) {
        Set eligibilities = this.getInternalPrimaryEligibilities();
        eligibilities.clear();
        if (primaryEligibility != null) {
            this.addPrimaryEligibility(primaryEligibility);
        }
    }

    private Set getInternalPrimaryEligibilities() {
        if (this.internalPrimaryEligibilities == null) {
            this.internalPrimaryEligibilities = new HashSet();
        }
        return this.internalPrimaryEligibilities;
    }

    private void setInternalPrimaryEligibilities(Set internalPrimaryEligibilities) {
        this.internalPrimaryEligibilities = internalPrimaryEligibilities;
    }

    private void addPrimaryEligibility(Eligibility primaryEligibility) {
        Validate.notNull((Object)primaryEligibility, (String)"Primary eligibility cannot be null");
        this.getInternalPrimaryEligibilities().add(primaryEligibility);
        primaryEligibility.setPrimary();
        primaryEligibility.setEnrollmentDetermination(this);
    }

    public Set getOtherEligibilities() {
        return Collections.unmodifiableSet(this.getInternalOtherEligibilities());
    }

    private Set getInternalOtherEligibilities() {
        if (this.internalOtherEligibilities == null) {
            this.internalOtherEligibilities = new HashSet();
        }
        return this.internalOtherEligibilities;
    }

    private void setInternalOtherEligibilities(Set internalOtherEligibilities) {
        this.internalOtherEligibilities = internalOtherEligibilities;
    }

    public void addOtherEligibility(Eligibility otherEligibility) {
        Validate.notNull((Object)otherEligibility, (String)"Other eligibility cannot be null");
        this.getInternalOtherEligibilities().add(otherEligibility);
        otherEligibility.setOther();
        otherEligibility.setEnrollmentDetermination(this);
    }

    public void removeCLFromOtherEligibilities() {
        ArrayList<Eligibility> eList = new ArrayList<Eligibility>();
        for (Eligibility e : this.getInternalOtherEligibilities()) {
            if (!"CL".equals(e.getFactor().getCode())) {
                eList.add(e);
                continue;
            }
            e.setEnrollmentDetermination(null);
        }
        this.getInternalOtherEligibilities().clear();
        this.getInternalOtherEligibilities().addAll(eList);
    }

    public void removeOtherEligibility(Eligibility otherEligibility) {
        Validate.notNull((Object)otherEligibility, (String)"Other eligibility cannot be null");
        ArrayList<Eligibility> eList = new ArrayList<Eligibility>();
        for (Eligibility e : this.getInternalOtherEligibilities()) {
            if ((otherEligibility.getEntityKey() == null || e.getEntityKey() == null || otherEligibility.getEntityKey().equals(e.getEntityKey())) && otherEligibility == e && otherEligibility.equals(e)) continue;
            eList.add(e);
        }
        this.getInternalOtherEligibilities().clear();
        this.getInternalOtherEligibilities().addAll(eList);
        otherEligibility.setEnrollmentDetermination(null);
    }

    public Set getSecondaryEligibilities() {
        return Collections.unmodifiableSet(this.getInternalSecondaryEligibilities());
    }

    private Set getInternalSecondaryEligibilities() {
        if (this.internalSecondaryEligibilities == null) {
            this.internalSecondaryEligibilities = new HashSet();
        }
        return this.internalSecondaryEligibilities;
    }

    private void setInternalSecondaryEligibilities(Set internalSecondaryEligibilities) {
        this.internalSecondaryEligibilities = internalSecondaryEligibilities;
    }

    public void addSecondaryEligibility(Eligibility secondaryEligibility) {
        Validate.notNull((Object)secondaryEligibility, (String)"Secondary eligibility cannot be null");
        this.getInternalSecondaryEligibilities().add(secondaryEligibility);
        secondaryEligibility.setSecondary();
        secondaryEligibility.setEnrollmentDetermination(this);
    }

    public void removeSecondaryEligibility(Eligibility secondaryEligibility) {
        Validate.notNull((Object)secondaryEligibility, (String)"Secondary eligibility cannot be null");
        ArrayList<Eligibility> eList = new ArrayList<Eligibility>();
        for (Eligibility e : this.getInternalSecondaryEligibilities()) {
            if ((secondaryEligibility.getEntityKey() == null || e.getEntityKey() == null || secondaryEligibility.getEntityKey().equals(e.getEntityKey())) && secondaryEligibility == e && secondaryEligibility.equals(e)) continue;
            eList.add(e);
        }
        this.getInternalSecondaryEligibilities().clear();
        this.getInternalSecondaryEligibilities().addAll(eList);
        secondaryEligibility.setEnrollmentDetermination(null);
    }

    public EGTSetting getEgtSetting() {
        return this.egtSetting;
    }

    public void setEgtSetting(EGTSetting egtSetting) {
        this.egtSetting = egtSetting;
    }

    @Override
    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("egtSetting", (Object)this.egtSetting);
    }
}

