/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.ee;

import gov.va.med.esr.common.model.ee.EGTSetting;
import gov.va.med.esr.common.model.ee.EGTSiteStatistic;
import gov.va.med.esr.common.model.lookup.EGTStatus;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.fw.model.AbstractKeyedEntity;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class EGTProcessStatistic
extends AbstractKeyedEntity {
    private static final long serialVersionUID = 268030912845891022L;
    private EGTStatus egtProcessStatus = null;
    private Date processStartDate = null;
    private Date processEndDate = null;
    private Integer beneficiaryProcessedCount = null;
    private Integer beneficiaryNotEnrolledCount = null;
    private String processId = null;
    private String processMessage = null;
    private Integer enrolledCategoryCount = null;
    private Integer inProcessCategoryCount = null;
    private EGTSetting egtSetting = null;
    private Map internalSiteStatistics = null;

    public Integer getBeneficiaryNotEnrolledCount() {
        return this.beneficiaryNotEnrolledCount;
    }

    public void setBeneficiaryNotEnrolledCount(Integer beneficiaryNotEnrolledCount) {
        this.beneficiaryNotEnrolledCount = beneficiaryNotEnrolledCount;
    }

    public Integer getBeneficiaryProcessedCount() {
        return this.beneficiaryProcessedCount;
    }

    public void setBeneficiaryProcessedCount(Integer beneficiaryProcessedCount) {
        this.beneficiaryProcessedCount = beneficiaryProcessedCount;
    }

    public Date getProcessEndDate() {
        return this.processEndDate;
    }

    public void setProcessEndDate(Date processEndDate) {
        this.processEndDate = processEndDate;
    }

    public Date getProcessStartDate() {
        return this.processStartDate;
    }

    public void setProcessStartDate(Date processStartDate) {
        this.processStartDate = processStartDate;
    }

    public EGTStatus getEgtProcessStatus() {
        return this.egtProcessStatus;
    }

    public void setEgtProcessStatus(EGTStatus egtProcessStatus) {
        this.egtProcessStatus = egtProcessStatus;
    }

    private Integer getEnrolledCategoryCount() {
        return this.enrolledCategoryCount;
    }

    private void setEnrolledCategoryCount(Integer enrolledCategoryCount) {
        this.enrolledCategoryCount = enrolledCategoryCount;
    }

    private Integer getInProcessCategoryCount() {
        return this.inProcessCategoryCount;
    }

    private void setInProcessCategoryCount(Integer inProcessCategoryCount) {
        this.inProcessCategoryCount = inProcessCategoryCount;
    }

    private String getProcessId() {
        return this.processId;
    }

    private void setProcessId(String processId) {
        this.processId = processId;
    }

    private String getProcessMessage() {
        return this.processMessage;
    }

    private void setProcessMessage(String processMessage) {
        this.processMessage = processMessage;
    }

    public EGTSetting getEgtSetting() {
        return this.egtSetting;
    }

    public void setEgtSetting(EGTSetting egtSetting) {
        this.egtSetting = egtSetting;
    }

    private Map getInternalSiteStatistics() {
        if (this.internalSiteStatistics == null) {
            this.internalSiteStatistics = new HashMap();
        }
        return this.internalSiteStatistics;
    }

    private void setInternalSiteStatistics(Map internalSiteStatistics) {
        this.internalSiteStatistics = internalSiteStatistics;
    }

    public Map getSiteStatistics() {
        return Collections.unmodifiableMap(this.getInternalSiteStatistics());
    }

    public EGTSiteStatistic getSiteStatistics(VAFacility site) {
        return (EGTSiteStatistic)((Object)this.getInternalSiteStatistics().get((Object)site));
    }

    public void setEGTSiteStatistic(VAFacility facility, EGTSiteStatistic siteStats) {
        Validate.notNull((Object)((Object)facility), (String)"Reported Site cannot be null");
        EGTSiteStatistic currentSiteStats = this.getSiteStatistics(facility);
        if (currentSiteStats != siteStats) {
            if (currentSiteStats != null) {
                this.getInternalSiteStatistics().remove((Object)facility);
                currentSiteStats.setEgtProcessStatistic(null);
            }
            if (siteStats != null) {
                if (siteStats.getFacility() != null) {
                    Validate.isTrue((boolean)facility.equals((Object)siteStats.getFacility()), (String)"Parameter Facility must match with the facility in the EGTSiteStatistic Object.");
                } else {
                    siteStats.setFacility(facility);
                }
                siteStats.setEgtProcessStatistic(this);
                this.getInternalSiteStatistics().put(facility, siteStats);
            }
        }
    }

    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("processStartDate", (Object)this.processStartDate);
        builder.append("processEndDate", (Object)this.processEndDate);
        builder.append("egtProcessStatus", (Object)this.egtProcessStatus);
        builder.append("beneficiaryProcessedCount", (Object)this.beneficiaryProcessedCount);
        builder.append("beneficiaryNotEnrolledCount", (Object)this.beneficiaryNotEnrolledCount);
        builder.append("processId", (Object)this.processId);
        builder.append("processMessage", (Object)this.processMessage);
        builder.append("enrolledCategoryCount", (Object)this.enrolledCategoryCount);
        builder.append("inProcessCategoryCount", (Object)this.inProcessCategoryCount);
    }
}

