/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.comms;

import gov.va.med.esr.common.model.comms.CommsTemplate;
import gov.va.med.esr.common.model.comms.HandBookBatchRequest;
import gov.va.med.esr.common.model.comms.HandBookMailStatus;
import gov.va.med.esr.common.model.lookup.ComLetterTemplateType;
import gov.va.med.esr.common.model.lookup.HandBookMailStatusType;
import gov.va.med.esr.common.model.lookup.HandBookReleaseControl;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.fw.model.AbstractKeyedEntity;
import java.math.BigDecimal;
import org.apache.commons.lang.StringUtils;

public class HandBookMailQueue
extends AbstractKeyedEntity {
    private static final long serialVersionUID = 3370639545976314371L;
    private BigDecimal templateId;
    private CommsTemplate template = null;
    private BigDecimal batchRequestId;
    private HandBookBatchRequest batchRequest;
    private BigDecimal personId;
    private BigDecimal hbmqId;
    private HandBookMailStatus handBookMailStatus;
    private BigDecimal mailStatusId;
    private String actionComment = null;
    private BigDecimal releaseControlId;
    private HandBookReleaseControl handBookReleaseControl = null;
    private BigDecimal mailQueueId;
    private BigDecimal addressId;
    private Address address;
    private static final String ACTION_COMMENT_SEPARATOR = System.getProperty("line.separator") + System.getProperty("line.separator");

    public BigDecimal getAddressId() {
        return this.addressId;
    }

    public void setAddressId(BigDecimal addressId) {
        this.addressId = addressId;
    }

    public BigDecimal getMailQueueId() {
        return this.mailQueueId;
    }

    public void setMailQueueId(BigDecimal mailQueueId) {
        this.mailQueueId = mailQueueId;
    }

    public BigDecimal getBatchRequestId() {
        return this.batchRequestId;
    }

    public void setBatchRequestId(BigDecimal batchRequestId) {
        this.batchRequestId = batchRequestId;
    }

    public BigDecimal getMailStatusId() {
        return this.mailStatusId;
    }

    public void setMailStatusId(BigDecimal mailStatusId) {
        this.mailStatusId = mailStatusId;
    }

    public HandBookMailStatus getHandBookMailStatus() {
        return this.handBookMailStatus;
    }

    public void setHandBookMailStatus(HandBookMailStatus handBookMailStatus) {
        this.handBookMailStatus = handBookMailStatus;
    }

    public void setReleaseControlId(BigDecimal releaseControlId) {
        this.releaseControlId = releaseControlId;
    }

    public BigDecimal getReleaseControlId() {
        return this.releaseControlId;
    }

    public void setHandBookReleaseControl(HandBookReleaseControl handBookReleaseControl) {
        this.handBookReleaseControl = handBookReleaseControl;
    }

    public HandBookReleaseControl getHandBookReleaseControl() {
        return this.handBookReleaseControl;
    }

    public BigDecimal getPersonId() {
        return this.personId;
    }

    public void setPersonId(BigDecimal personId) {
        this.personId = personId;
    }

    public BigDecimal getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(BigDecimal templateId) {
        this.templateId = templateId;
    }

    public CommsTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(CommsTemplate template) {
        this.template = template;
    }

    public HandBookBatchRequest getBatchRequest() {
        return this.batchRequest;
    }

    public void setBatchRequest(HandBookBatchRequest batchRequest) {
        this.batchRequest = batchRequest;
    }

    public String getTemplateName() {
        return this.template == null ? null : this.template.getCommsTemplateName();
    }

    public String getHandbookVersion() {
        return this.handBookReleaseControl == null ? null : this.handBookReleaseControl.getCode();
    }

    public String getId() {
        return this.getIdentifier().toString();
    }

    public boolean isSentToCMS() {
        return this.isTargetStatus(HandBookMailStatusType.SENT_TO_CMS);
    }

    public boolean isSendToCMS() {
        return this.isTargetStatus(HandBookMailStatusType.SEND_TO_CMS);
    }

    private boolean isTargetStatus(HandBookMailStatusType.Code targetStatus) {
        if (this.handBookMailStatus.getStatusType() == null) {
            return false;
        }
        return this.handBookMailStatus.getStatusType().getCode().equals(targetStatus.getCode());
    }

    public boolean isHandbook() {
        return this.isTargetDocument(ComLetterTemplateType.FORM_NUMBER_400H);
    }

    public boolean isHandbookAny() {
        return this.isTargetDocument(ComLetterTemplateType.FORM_NUMBER_400H) || this.isTargetDocument(ComLetterTemplateType.FORM_NUMBER_400B) || this.isTargetDocument(ComLetterTemplateType.FORM_NUMBER_400F);
    }

    private boolean isTargetDocument(ComLetterTemplateType.Code targetDocument) {
        String formNumber = this.getFormNumber() == null ? null : this.getFormNumber();
        return targetDocument.getCode().equals(formNumber);
    }

    public String getFormNumber() {
        return this.template == null ? null : this.template.getCommsTemplateFormNumber();
    }

    public boolean isEligibleForView() {
        boolean isEligibleForView = false;
        if (this.isTargetStatus(HandBookMailStatusType.MAILED_BY_CMS) || this.isTargetStatus(HandBookMailStatusType.RETURN_BY_POST_OFFICE) || this.isTargetStatus(HandBookMailStatusType.REJECTED_ADDRESS_BY_CMS) || this.isTargetStatus(HandBookMailStatusType.ONLINE)) {
            isEligibleForView = this.isHandbookAny();
        }
        return isEligibleForView;
    }

    public String getActionComment() {
        return this.actionComment;
    }

    public void setActionComment(String actionComment) {
        this.actionComment = actionComment;
    }

    public BigDecimal getHbmqId() {
        return this.hbmqId;
    }

    public void setHbmqId(BigDecimal hbmqId) {
        this.hbmqId = hbmqId;
    }

    public void addActionComment(String actionComment) {
        if (StringUtils.isNotBlank((String)actionComment)) {
            if (StringUtils.isNotBlank((String)this.getActionComment())) {
                StringBuffer buf = new StringBuffer();
                buf.append(actionComment);
                buf.append(ACTION_COMMENT_SEPARATOR);
                buf.append(this.getActionComment());
                this.setActionComment(buf.toString());
            } else {
                this.setActionComment(actionComment);
            }
        }
    }

    public String getLatestActionComment() {
        String latestActionComment = this.getActionComment();
        if (StringUtils.isNotBlank((String)latestActionComment) && latestActionComment.indexOf(ACTION_COMMENT_SEPARATOR) != -1) {
            latestActionComment = latestActionComment.split(ACTION_COMMENT_SEPARATOR)[0];
        }
        return latestActionComment;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }
}

