/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.comms;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.comms.AacErrorReasonLink;
import gov.va.med.esr.common.model.comms.CommsTemplate;
import gov.va.med.esr.common.model.comms.HecRejectReason;
import gov.va.med.esr.common.model.comms.MailingStatusLink;
import gov.va.med.esr.common.model.lookup.ComAACErrorType;
import gov.va.med.esr.common.model.lookup.ComAACRejectReasonType;
import gov.va.med.esr.common.model.lookup.ComLetterTemplateType;
import gov.va.med.esr.common.model.lookup.ComLetterType;
import gov.va.med.esr.common.model.lookup.ComMailingStatusType;
import gov.va.med.esr.common.model.lookup.ComMailingTriggerType;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.model.EntityKey;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

public class CommsLogEntry
extends AbstractKeyedEntity {
    private static final long serialVersionUID = -4487158720694022048L;
    private static final String ACTION_COMMENT_SEPARATOR = System.getProperty("line.separator") + System.getProperty("line.separator");
    public static final String RECIPIENT_VETERAN = "Veteran";
    public static final String RECIPIENT_SPOUSE = "Spouse";
    public static final String RECIPIENT_DEPENDENT = "Dependent";
    public static final String RECIPIENT_POA = "Power of Attorney";
    public static final String REMAIL_INDICATOR_RESEND = "RESEND";
    public static final String REMAIL_INDICATOR_REMAILED = "REMAILED";
    public static final String MAMUAL_TRIGGER_CODE = "1";
    public static final String REMAIL_TRIGGER_CODE = "2";
    public static final String HISTORICAL_TRIGGER_CODE = "3";
    public static final String AUTOMATIC_TRIGGER_CODE = "4";
    private static final String CANCEL_BY_HEC = "10";
    private String barcode = null;
    private String logXML = null;
    private String responseXML = null;
    private Date mailingDate = null;
    private BigDecimal workflowCaseId = null;
    private CommsTemplate template;
    private String actionComment = null;
    private ComAACRejectReasonType code1RejectReason = null;
    private List aacErrorReasonLinks = new ArrayList();
    private String remailIndicator = null;
    private List hecRejectionReasons = new ArrayList();
    private List mailingStatusLinks = new ArrayList();
    private ComLetterType letterType = null;
    private String recipient = null;
    private BigDecimal personId;
    private String aacExtractNumber;
    private Boolean overrideIndicator = null;
    private Address address = null;
    private SSN ssn = null;
    private Name name = null;
    private ComMailingTriggerType comMailingTriggerType = null;
    private Date ivmCaseClosureDate = null;
    private String ivmCaseNumber = null;
    private Boolean sentToIVM = null;

    public BigDecimal getPersonId() {
        return this.personId;
    }

    public void setPersonId(BigDecimal personId) {
        this.personId = personId;
    }

    public boolean isCancelledByHec() {
        return this.isTargetStatus(ComMailingStatusType.CANCEL_BY_HEC);
    }

    public boolean isMailedByAAC() {
        return this.isTargetStatus(ComMailingStatusType.MAILED_BY_AAC);
    }

    public boolean isSendToAAC() {
        return this.isTargetStatus(ComMailingStatusType.SEND_TO_AAC);
    }

    public boolean isSendToCMS() {
        return this.isTargetStatus(ComMailingStatusType.SEND_TO_CMS);
    }

    private boolean isTargetStatus(ComMailingStatusType.Code targetStatus) {
        ComMailingStatusType status;
        MailingStatusLink statusLink = this.getLatestMailingStatus();
        ComMailingStatusType comMailingStatusType = status = statusLink != null ? statusLink.getMailingStatus() : null;
        return status != null && targetStatus.getCode().equals(status.getCode());
    }

    public boolean isEligibleForRemail() {
        ComMailingStatusType status;
        boolean isEligibleForRemail = true;
        MailingStatusLink statusLink = this.getLatestMailingStatus();
        ComMailingStatusType comMailingStatusType = status = statusLink != null ? statusLink.getMailingStatus() : null;
        if (status != null && (ComMailingStatusType.SEND_TO_AAC.getCode().equals(status.getCode()) || ComMailingStatusType.SENT_TO_AAC.getCode().equals(status.getCode()) || ComMailingStatusType.SEND_TO_CMS.getCode().equals(status.getCode()) || ComMailingStatusType.SENT_TO_CMS.getCode().equals(status.getCode()))) {
            isEligibleForRemail = false;
        }
        return isEligibleForRemail;
    }

    public MailingStatusLink getLatestMailingStatus() {
        if (this.getMailingStatusLinks() == null || this.getMailingStatusLinks().size() == 0) {
            return null;
        }
        return (MailingStatusLink)((Object)this.getMailingStatusLinks().get(0));
    }

    public CommsTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(CommsTemplate template) {
        this.template = template;
    }

    public void applyTemplate(CommsTemplate template) {
        this.template = template;
        if (template != null) {
            this.letterType = template.getLetterType();
            this.recipient = RECIPIENT_VETERAN;
            String formNumber = template.getCommsTemplateFormNumber();
            if (formNumber.equals(ComLetterTemplateType.FORM_NUMBER_298.getCode()) || formNumber.equals(ComLetterTemplateType.FORM_NUMBER_299.getCode())) {
                this.recipient = RECIPIENT_SPOUSE;
            }
        }
    }

    public List getAacErrorReasonLinks() {
        return this.aacErrorReasonLinks;
    }

    public void setAacErrorReasonLinks(List aacErrorReasonLinks) {
        this.aacErrorReasonLinks = aacErrorReasonLinks;
    }

    public String getActionComment() {
        return this.actionComment;
    }

    public void setActionComment(String actionComment) {
        this.actionComment = actionComment;
    }

    public void addActionComment(String actionComment) {
        if (StringUtils.isNotBlank((String)actionComment)) {
            if (StringUtils.isNotBlank((String)this.getActionComment())) {
                StringBuffer buf = new StringBuffer();
                buf.append(actionComment);
                buf.append(ACTION_COMMENT_SEPARATOR);
                buf.append(this.getActionComment());
                this.setActionComment(buf.toString());
            } else {
                this.setActionComment(actionComment);
            }
        }
    }

    public String getLatestActionComment() {
        String latestActionComment = this.getActionComment();
        if (StringUtils.isNotBlank((String)latestActionComment) && latestActionComment.indexOf(ACTION_COMMENT_SEPARATOR) != -1) {
            latestActionComment = latestActionComment.split(ACTION_COMMENT_SEPARATOR)[0];
        }
        return latestActionComment;
    }

    public ComAACRejectReasonType getCode1RejectReason() {
        return this.code1RejectReason;
    }

    public String getCommsLogIdString() {
        EntityKey key = this.getEntityKey();
        String keyVal = null;
        if (key != null) {
            keyVal = key.getKeyValueAsString();
        }
        return keyVal;
    }

    public PersonIdEntityKey getPersonIdEntityKey() {
        return this.personId != null ? CommonEntityKeyFactory.createPersonIdEntityKey(this.personId.toString()) : null;
    }

    public void setCode1RejectReason(ComAACRejectReasonType code1RejectReason) {
        this.code1RejectReason = code1RejectReason;
    }

    public String getFormNumber() {
        return this.template == null ? null : this.template.getCommsTemplateFormNumber();
    }

    public List getHecRejectionReasons() {
        return this.hecRejectionReasons;
    }

    public void setHecRejectionReasons(List hecRejectionReasons) {
        this.hecRejectionReasons = hecRejectionReasons;
    }

    public ComLetterType getLetterType() {
        return this.letterType;
    }

    public void setLetterType(ComLetterType letterType) {
        this.letterType = letterType;
    }

    public ComMailingTriggerType getComMailingTriggerType() {
        return this.comMailingTriggerType;
    }

    public void setComMailingTriggerType(ComMailingTriggerType comMailingTriggerType) {
        this.comMailingTriggerType = comMailingTriggerType;
    }

    public String getLogXML() {
        return this.logXML;
    }

    public void setLogXML(String logXML) {
        this.logXML = logXML;
    }

    public Date getMailingDate() {
        return this.mailingDate;
    }

    public void setMailingDate(Date mailingDate) {
        this.mailingDate = mailingDate;
    }

    public List getMailingStatusLinks() {
        return this.mailingStatusLinks;
    }

    public void setMailingStatusLinks(List mailingStatusLinks) {
        this.mailingStatusLinks = mailingStatusLinks;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public String getRemailIndicator() {
        return this.remailIndicator;
    }

    public void setRemailIndicator(String remailIndicator) {
        this.remailIndicator = remailIndicator;
    }

    public String getResponseXML() {
        return this.responseXML;
    }

    public void setResponseXML(String responseXML) {
        this.responseXML = responseXML;
    }

    public String getTemplateName() {
        return this.template == null ? null : this.template.getCommsTemplateName();
    }

    public BigDecimal getWorkflowCaseId() {
        return this.workflowCaseId;
    }

    public void setWorkflowCaseId(BigDecimal workflowCaseId) {
        this.workflowCaseId = workflowCaseId;
    }

    public String getAacExtractNumber() {
        return this.aacExtractNumber;
    }

    public void setAacExtractNumber(String aacExtractNumber) {
        this.aacExtractNumber = aacExtractNumber;
    }

    public Boolean getOverrideIndicator() {
        return this.overrideIndicator;
    }

    public void setOverrideIndicator(Boolean overrideIndicator) {
        this.overrideIndicator = overrideIndicator;
    }

    public SSN getSsn() {
        return this.ssn;
    }

    public void setSsn(SSN ssn) {
        this.ssn = ssn;
    }

    public Name getName() {
        return this.name;
    }

    public void setName(Name name) {
        this.name = name;
    }

    public void addMailingStatus(ComMailingStatusType mailingStatusType) {
        MailingStatusLink link = new MailingStatusLink();
        link.setCommsLog(this);
        link.setMailingStatus(mailingStatusType);
        this.mailingStatusLinks.add(0, link);
    }

    public void addHecRejectReason(String hecRejReasonDesc) {
        HecRejectReason rejReason = new HecRejectReason(hecRejReasonDesc);
        rejReason.setCommsLog(this);
        this.hecRejectionReasons.add(rejReason);
    }

    public void addAacErrorReason(ComAACErrorType aacErrorReason) {
        AacErrorReasonLink link = new AacErrorReasonLink();
        link.setCommsLog(this);
        link.setAacErrorType(aacErrorReason);
        this.aacErrorReasonLinks.add(link);
    }

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public String getBarcode() {
        return this.barcode;
    }

    public void setBarcode(String barcode) {
        this.barcode = barcode;
    }

    public Date getIvmCaseClosureDate() {
        return this.ivmCaseClosureDate;
    }

    public void setIvmCaseClosureDate(Date ivmCaseClosureDate) {
        this.ivmCaseClosureDate = ivmCaseClosureDate;
    }

    public String getIvmCaseNumber() {
        return this.ivmCaseNumber;
    }

    public void setIvmCaseNumber(String ivmCaseNumber) {
        this.ivmCaseNumber = ivmCaseNumber;
    }

    public Boolean getSentToIVM() {
        return this.sentToIVM;
    }

    public void setSentToIVM(Boolean sentToIVM) {
        this.sentToIVM = sentToIVM;
    }

    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("barcode", (Object)this.barcode);
        builder.append("logXML", (Object)this.logXML);
        builder.append("mailingDate", (Object)this.mailingDate);
        builder.append("workflowCaseId", (Object)this.workflowCaseId);
        builder.append("actionComment", (Object)this.actionComment);
        builder.append("code1RejectReason", (Object)this.code1RejectReason);
        builder.append("aacErrorReasonLinks", (Object)this.aacErrorReasonLinks);
        builder.append("remailIndicator", (Object)this.remailIndicator);
        builder.append("hecRejectionReasons", (Object)this.hecRejectionReasons);
        builder.append("mailingStatusLinks", (Object)this.mailingStatusLinks);
        builder.append("letterType", (Object)this.letterType);
        builder.append("recipient", (Object)this.recipient);
        builder.append("personId", (Object)this.personId);
        builder.append("aacExtractNumber", (Object)this.aacExtractNumber);
        builder.append("overrideIndicator", (Object)this.overrideIndicator);
        builder.append("comMailingTriggerType", (Object)this.comMailingTriggerType);
        builder.append("ivmCaseClosureDate", (Object)this.ivmCaseClosureDate);
        builder.append("sentToIVM", (Object)this.sentToIVM);
    }
}

