/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.infra;

import java.io.Serializable;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;

public class PredicatedTransformer
implements Transformer,
Serializable {
    private static final long serialVersionUID = 6370542198351268517L;
    private Predicate predicate;
    private Transformer transformer;

    public static Transformer getInstance(Transformer transformer, Predicate predicate) {
        return new PredicatedTransformer(transformer, predicate);
    }

    private PredicatedTransformer(Transformer transformer, Predicate predicate) {
        this.transformer = transformer;
        this.predicate = predicate;
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public Transformer getTransformer() {
        return this.transformer;
    }

    protected void validate(Object object) {
        if (!this.predicate.evaluate(object)) {
            throw new IllegalArgumentException("Cannot transform Object '" + object + "' - Predicate rejected it");
        }
    }

    public Object transform(Object input) {
        this.validate(input);
        return this.transformer.transform(input);
    }
}

