/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.clock;

import gov.va.med.esr.common.clock.AbstractClockProcess;
import gov.va.med.esr.common.clock.Clock;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.CommsLogService;
import gov.va.med.esr.service.PersonService;

public class SSNClockProcess
extends AbstractClockProcess {
    private CommsLogService commsLogService = null;
    private PersonService personService = null;

    @Override
    protected void processClock(String personId, String clockType, String subject) throws Exception {
        Person person = this.getPersonService().getPerson(CommonEntityKeyFactory.createPersonIdEntityKey(personId));
        Clock.Type firedClockType = this.convertStrToClockType(clockType);
        this.getCommsLogService().processAutomaticLetterRequests(person, firedClockType, subject);
    }

    @Override
    protected Clock.Type convertStrToClockType(String type) {
        if (Clock.Type.SSN_30_DAY_VALIDATION_CLOCK.getName().equals(type)) {
            return Clock.Type.SSN_30_DAY_VALIDATION_CLOCK;
        }
        if (Clock.Type.SSN_45_DAY_CLOCK.getName().equals(type)) {
            return Clock.Type.SSN_45_DAY_CLOCK;
        }
        if (Clock.Type.SSN_30_DAY_PSEUDO_SSN_REASON_CLOCK.getName().equals(type)) {
            return Clock.Type.SSN_30_DAY_PSEUDO_SSN_REASON_CLOCK;
        }
        if (Clock.Type.SSN_30_DAY_PSEUDO_SSN_VERIFICATION_CLOCK.getName().equals(type)) {
            return Clock.Type.SSN_30_DAY_PSEUDO_SSN_VERIFICATION_CLOCK;
        }
        return null;
    }

    public CommsLogService getCommsLogService() {
        return this.commsLogService;
    }

    public void setCommsLogService(CommsLogService commsLogService) {
        this.commsLogService = commsLogService;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }
}

