/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.clock;

import gov.va.med.esr.common.clock.AbstractClockProcess;
import gov.va.med.esr.common.clock.Clock;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.PersonService;
import gov.va.med.esr.service.PurpleHeartService;

public class PHClockProcess
extends AbstractClockProcess {
    private PurpleHeartService purpleHeartService = null;
    private PersonService personService = null;

    @Override
    protected void processClock(String personId, String clockType, String subject) throws Exception {
        Person person = this.getPersonService().getPerson(CommonEntityKeyFactory.createPersonIdEntityKey(personId));
        Clock.Type firedClockType = this.convertStrToClockType(clockType);
        this.getPurpleHeartService().updatePurpleHeart(person, firedClockType);
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public PurpleHeartService getPurpleHeartService() {
        return this.purpleHeartService;
    }

    public void setPurpleHeartService(PurpleHeartService purpleHeartService) {
        this.purpleHeartService = purpleHeartService;
    }

    @Override
    protected Clock.Type convertStrToClockType(String type) {
        if (Clock.Type.PH_14_DAY_CLOCK.getName().equals(type)) {
            return Clock.Type.PH_14_DAY_CLOCK;
        }
        if (Clock.Type.PH_37_DAY_CLOCK.getName().equals(type)) {
            return Clock.Type.PH_37_DAY_CLOCK;
        }
        return null;
    }
}

