/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.clock;

import gov.va.med.esr.common.clock.Clock;
import gov.va.med.fw.scheduling.AbstractScheduledProcess;
import gov.va.med.fw.scheduling.ScheduledProcessInvocationContext;
import org.apache.commons.lang.Validate;

public abstract class AbstractClockProcess
extends AbstractScheduledProcess {
    private static final int VALID_MIN_SIZE = 2;

    protected void executeProcess(ScheduledProcessInvocationContext context) throws Exception {
        Object args = context.getInvocationArguments();
        if (args instanceof Object[]) {
            Object[] list = (Object[])args;
            boolean validSize = list.length >= 2;
            Validate.isTrue((boolean)validSize, (String)"Parameters passed to clock process are invalid");
            String personId = (String)list[0];
            String clockType = (String)list[1];
            String subject = list.length > 2 ? (String)list[2] : null;
            Validate.notNull((Object)personId, (String)"The person id must not be null ");
            Validate.notNull((Object)clockType, (String)"The clock type must not be null ");
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Executing clock process for: " + clockType));
            }
            this.processClock(personId, clockType, subject);
        }
    }

    protected abstract void processClock(String var1, String var2, String var3) throws Exception;

    protected abstract Clock.Type convertStrToClockType(String var1);
}

