/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.msds;

import gov.va.med.esr.common.builder.msds.CombatServiceBuilderStrategy;
import gov.va.med.esr.common.model.lookup.CombatPayType;
import gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.MilitaryPay;
import gov.va.med.fw.rule.SimpleRuleMethod;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class VadirCombatServiceBuilderStrategy
implements CombatServiceBuilderStrategy {
    @Override
    public List determineMilitaryPayToKeep(List militaryPays) {
        ArrayList<MilitaryPay> processingList = new ArrayList<MilitaryPay>();
        if (militaryPays == null) {
            return processingList;
        }
        for (MilitaryPay pay : militaryPays) {
            Date start = pay.getStartDate();
            Date end = pay.getEndDate();
            String payType = pay.getPayType();
            if (start == null || end == null || payType == null) continue;
            try {
                SimpleRuleMethod util = new SimpleRuleMethod();
                if (!util.isAfter(start, util.toDate("11/11/1998")) || !CombatPayType.CODE_COMBAT_ZONE_TAX_EXCLUSION.getCode().equals(payType) && !CombatPayType.CODE_HOSTILE_FIRE_IMMINENT_DANGER.getCode().equals(payType)) continue;
                processingList.add(pay);
            }
            catch (ParseException e) {}
        }
        if (processingList.isEmpty()) {
            return processingList;
        }
        ArrayList<MilitaryPay> processingList2 = new ArrayList<MilitaryPay>();
        ArrayList toRemove = new ArrayList();
        for (MilitaryPay pay : processingList) {
            List overLapped = this.getOverlappingMiltaryPaySameType(pay, processingList);
            if (overLapped.size() > 0) {
                this.combineMilitaryPays(pay, overLapped, toRemove);
            }
            if (toRemove.contains(pay)) continue;
            processingList2.add(pay);
        }
        ArrayList<MilitaryPay> processingListFinal = new ArrayList<MilitaryPay>();
        toRemove.clear();
        for (MilitaryPay pay : processingList2) {
            List overLapped = this.getOverlappingMiltaryPay(true, pay, processingList);
            if (overLapped.size() > 0) {
                this.resolveMilitaryPayOverlaps(pay, overLapped, toRemove);
            }
            if (toRemove.contains(pay)) continue;
            processingListFinal.add(pay);
        }
        return processingListFinal;
    }

    private void combineMilitaryPays(MilitaryPay pay, List overLapped, List toRemove) {
        Date minStart = pay.getStartDate();
        Date maxEnd = pay.getEndDate();
        SimpleRuleMethod util = new SimpleRuleMethod();
        for (MilitaryPay overLap : overLapped) {
            boolean remove = false;
            if (overLap.getStartDate() == null || overLap.getEndDate() == null) continue;
            if (util.isBefore(overLap.getStartDate(), minStart)) {
                minStart = overLap.getStartDate();
                remove = true;
            }
            if (util.isAfter(overLap.getEndDate(), maxEnd)) {
                maxEnd = overLap.getEndDate();
                remove = true;
            }
            if (!remove) continue;
            toRemove.add(overLap);
        }
        pay.setStartDate(minStart);
        pay.setEndDate(maxEnd);
    }

    private void resolveMilitaryPayOverlaps(MilitaryPay pay, List overLapped, List toRemove) {
        for (MilitaryPay overLap : overLapped) {
            if (CombatPayType.CODE_COMBAT_ZONE_TAX_EXCLUSION.getCode().equals(overLap.getPayType()) || !CombatPayType.CODE_COMBAT_ZONE_TAX_EXCLUSION.getCode().equals(pay.getPayType())) continue;
            toRemove.add(overLap);
        }
    }

    private boolean isOverlapped(Date startDate, Date endDate, Date lower_range, Date upper_range) {
        boolean overlapped = false;
        if (startDate != null && endDate != null && lower_range != null && upper_range != null) {
            if (startDate.equals(lower_range) || startDate.equals(upper_range) || endDate.equals(lower_range) || endDate.equals(upper_range)) {
                overlapped = true;
            } else if (startDate.before(lower_range) && lower_range.before(upper_range) && upper_range.before(endDate)) {
                overlapped = true;
            } else if (startDate.before(lower_range) && lower_range.before(endDate) && endDate.before(upper_range)) {
                overlapped = true;
            } else if (lower_range.before(startDate) && startDate.before(upper_range) && upper_range.before(endDate)) {
                overlapped = true;
            } else if (lower_range.before(startDate) && startDate.before(endDate) && endDate.before(upper_range)) {
                overlapped = true;
            }
        }
        return overlapped;
    }

    private List getOverlappingMiltaryPaySameType(MilitaryPay militaryPay, List pays) {
        return this.getOverlappingMiltaryPay(false, militaryPay, pays);
    }

    private List getOverlappingMiltaryPay(boolean ignoreType, MilitaryPay militaryPay, List pays) {
        ArrayList<MilitaryPay> overLapList = new ArrayList<MilitaryPay>();
        if (militaryPay == null || !ignoreType && militaryPay.getPayType() == null) {
            return overLapList;
        }
        for (MilitaryPay pay : pays) {
            if (militaryPay == pay || !ignoreType && pay.getPayType() == null) continue;
            Date lower_range = pay.getStartDate();
            Date upper_range = pay.getEndDate();
            Date startDate = militaryPay.getStartDate();
            Date endDate = militaryPay.getEndDate();
            if (!ignoreType) {
                if (!militaryPay.getPayType().equals(pay.getPayType()) || !this.isOverlapped(startDate, endDate, lower_range, upper_range)) continue;
                overLapList.add(pay);
                continue;
            }
            if (!this.isOverlapped(startDate, endDate, lower_range, upper_range)) continue;
            overLapList.add(pay);
        }
        return overLapList;
    }
}

