/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.msds;

import gov.va.med.esr.common.builder.entity.ActivationMetaData;
import gov.va.med.esr.common.builder.entity.CombatEpisodeMetaData;
import gov.va.med.esr.common.builder.entity.CombatServiceMetaData;
import gov.va.med.esr.common.builder.entity.EntityBuilder;
import gov.va.med.esr.common.builder.entity.metaData.AbstractMetaData;
import gov.va.med.esr.common.builder.msds.MilitaryServiceMetaDataFromBIRLS;
import gov.va.med.esr.common.builder.msds.MilitaryServiceMetaDataFromVADIR;
import gov.va.med.esr.common.builder.msds.MilitaryServiceMetaDataMSDS;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.ee.Activation;
import gov.va.med.esr.common.model.ee.CombatEpisode;
import gov.va.med.esr.common.model.ee.CombatService;
import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.jms.vadir.outboundResponse.VadirServiceResponseWrapper;
import gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.BIRLS;
import gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.MilitaryHistory;
import gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.VADIR;
import gov.va.med.esr.service.MsdsResponseInfo;
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MilitaryServiceBuilderForMSDS
extends EntityBuilder {
    private static final long serialVersionUID = -5564709731817935860L;
    public static final String YES_INDICATOR = "Y";
    public static final String NO_INDICATOR = "N";
    private Map responseStatusMap;
    private Builder combatEpisodeBuilder;
    private Builder combatServiceBuilder;
    private Builder activationBuilder;
    private Builder militaryServiceBuilder;

    public MsdsResponseInfo build(VadirServiceResponseWrapper wrapper) throws BuilderException {
        MilitaryHistory history;
        if (wrapper == null) {
            return null;
        }
        MsdsResponseInfo info = new MsdsResponseInfo();
        MilitaryHistory militaryHistory = history = wrapper != null && wrapper.getResult() instanceof MilitaryHistory ? (MilitaryHistory)wrapper.getResult() : null;
        if (history != null) {
            MilitaryService output;
            AbstractMetaData metaData;
            VADIR vadir = history.getVadir();
            BIRLS birls = history.getBirls();
            if (vadir != null) {
                metaData = new MilitaryServiceMetaDataFromVADIR(wrapper);
                if ("05".equals(metaData.getMetaDataError())) {
                    info.setMsdsReceivedStatus("05");
                    info.setVadirError("05");
                }
                output = (MilitaryService)((Object)this.getMilitaryServiceBuilder().build((Object)metaData));
                this.transfer(output, (MilitaryServiceMetaDataMSDS)((Object)metaData));
                info.setVadirMilitaryService(this.shouldKeep((Object)output) ? output : null);
                info.setOefoifInd(vadir.getOefOifIndicator());
            }
            if (birls != null) {
                metaData = new MilitaryServiceMetaDataFromBIRLS(wrapper);
                if ("06".equals(metaData.getMetaDataError())) {
                    info.setMsdsReceivedStatus("06");
                    info.setBirlsError("06");
                }
                output = (MilitaryService)((Object)this.getMilitaryServiceBuilder().build((Object)metaData));
                this.transfer(output, (MilitaryServiceMetaDataMSDS)((Object)metaData));
                info.setBirlsMilitaryService(this.shouldKeep((Object)output) ? output : null);
                info.setHasPurpleHeart(this.buildIndicator(birls.getPurpleHeartInd()));
                info.setHasMedalOfHonor(this.buildIndicator(birls.getMedalOfHonorInd()));
            }
        }
        if (info.getMsdsReceivedStatus() == null) {
            String status;
            String string = status = history != null ? (String)this.getResponseStatusMap().get(history.getReturnStatus()) : null;
            if (status == null && wrapper.getErrorMessage() != null) {
                status = (String)this.getResponseStatusMap().get(wrapper.getErrorMessage());
            }
            info.setMsdsReceivedStatus(status);
        }
        info.setPersonEntityKey(CommonEntityKeyFactory.createPersonIdEntityKey(String.valueOf(wrapper.getPersonId())));
        return info;
    }

    private void transfer(MilitaryService input, MilitaryServiceMetaDataMSDS metaData) throws BuilderException {
        this.buildActivations(input, metaData.getActivations());
        this.buildCombatServices(input, metaData.getCombatServices());
        this.buildCombatEpisodes(input, metaData.getCombatEpisodes());
    }

    private void buildActivations(MilitaryService input, ActivationMetaData[] metaData) throws BuilderException {
        HashSet toAdd = new HashSet();
        for (int index = 0; index < (metaData == null ? 0 : metaData.length); ++index) {
            this.processActivation(toAdd, metaData[index]);
        }
        input.removeAllActivations();
        Iterator i = toAdd.iterator();
        while (i.hasNext()) {
            input.addActivation((Activation)((Object)i.next()));
        }
    }

    private void processActivation(Set toAdd, ActivationMetaData metaData) throws BuilderException {
        Activation value = this.buildActivation(null, metaData);
        if (value != null) {
            toAdd.add(value);
        }
    }

    private Activation buildActivation(Activation input, ActivationMetaData metaData) throws BuilderException {
        if (metaData == null) {
            return null;
        }
        metaData.setEntity(input);
        return (Activation)((Object)this.getActivationBuilder().build((Object)metaData));
    }

    private void buildCombatServices(MilitaryService input, CombatServiceMetaData[] metaData) throws BuilderException {
        HashSet toAdd = new HashSet();
        for (int index = 0; index < (metaData == null ? 0 : metaData.length); ++index) {
            this.processCombatService(toAdd, metaData[index]);
        }
        input.removeAllCombatServices();
        Iterator i = toAdd.iterator();
        while (i.hasNext()) {
            input.addCombatService((CombatService)((Object)i.next()));
        }
    }

    private void buildCombatEpisodes(MilitaryService input, CombatEpisodeMetaData[] metaData) throws BuilderException {
        HashSet toAdd = new HashSet();
        for (int index = 0; index < (metaData == null ? 0 : metaData.length); ++index) {
            this.processCombatEpisode(toAdd, metaData[index]);
        }
        input.removeAllCombatEpisodes();
        Iterator i = toAdd.iterator();
        while (i.hasNext()) {
            input.addCombatEpisode((CombatEpisode)((Object)i.next()));
        }
    }

    private void processCombatService(Set toAdd, CombatServiceMetaData metaData) throws BuilderException {
        CombatService value = this.buildCombatService(null, metaData);
        if (value != null) {
            toAdd.add(value);
        }
    }

    private void processCombatEpisode(Set toAdd, CombatEpisodeMetaData metaData) throws BuilderException {
        CombatEpisode value = this.buildCombatEpisode(null, metaData);
        if (value != null) {
            toAdd.add(value);
        }
    }

    private CombatService buildCombatService(CombatService input, CombatServiceMetaData metaData) throws BuilderException {
        if (metaData == null) {
            return null;
        }
        metaData.setEntity(input);
        return (CombatService)((Object)this.getCombatServiceBuilder().build((Object)metaData));
    }

    private CombatEpisode buildCombatEpisode(CombatEpisode input, CombatEpisodeMetaData metaData) throws BuilderException {
        if (metaData == null) {
            return null;
        }
        metaData.setEntity(input);
        return (CombatEpisode)((Object)this.getCombatEpisodeBuilder().build((Object)metaData));
    }

    public Builder getActivationBuilder() {
        return this.activationBuilder;
    }

    public void setActivationBuilder(Builder activationBuilder) {
        this.activationBuilder = activationBuilder;
    }

    public Builder getCombatServiceBuilder() {
        return this.combatServiceBuilder;
    }

    public void setCombatServiceBuilder(Builder combatServiceBuilder) {
        this.combatServiceBuilder = combatServiceBuilder;
    }

    public Builder getMilitaryServiceBuilder() {
        return this.militaryServiceBuilder;
    }

    public void setMilitaryServiceBuilder(Builder militaryServiceBuilder) {
        this.militaryServiceBuilder = militaryServiceBuilder;
    }

    public Builder getCombatEpisodeBuilder() {
        return this.combatEpisodeBuilder;
    }

    public void setCombatEpisodeBuilder(Builder combatEpisodeBuilder) {
        this.combatEpisodeBuilder = combatEpisodeBuilder;
    }

    public Map getResponseStatusMap() {
        return this.responseStatusMap;
    }

    public void setResponseStatusMap(Map responseStatusMap) {
        this.responseStatusMap = responseStatusMap;
    }

    private Boolean buildIndicator(String ind) {
        if (ind != null && !" ".equals(ind)) {
            if (YES_INDICATOR.equalsIgnoreCase(ind)) {
                return Boolean.TRUE;
            }
            if (NO_INDICATOR.equalsIgnoreCase(ind)) {
                return Boolean.FALSE;
            }
        }
        return null;
    }
}

