/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity.metaData;

import gov.va.med.esr.common.builder.entity.VAPensionMetaData;
import gov.va.med.esr.common.builder.entity.metaData.AbstractMetaData;
import gov.va.med.esr.common.model.ee.MonetaryBenefitAward;
import gov.va.med.fw.hl7.segment.ZE2;

public class VAPensionMetaDataFromZE2
extends AbstractMetaData
implements VAPensionMetaData {
    private MonetaryBenefitAward entity;
    private ZE2 ze2;
    private String effectiveDate = null;
    private String terminationDate = null;
    private String awardReasonCode = null;
    private String[] terminationReasonCodes = new String[4];

    public VAPensionMetaDataFromZE2(ZE2 ze2) {
        this.ze2 = ze2;
        if (ze2 != null) {
            this.parseZe2();
        }
    }

    private void parseZe2() {
        if (this.ze2.getPensionAwardReasonCode() != null) {
            this.awardReasonCode = this.ze2.getPensionAwardReasonCode().split("\\~")[0];
            this.effectiveDate = this.ze2.getPensionDate().split("\\~")[0];
        }
    }

    @Override
    public MonetaryBenefitAward getEntity() {
        return this.entity;
    }

    @Override
    public void setEntity(MonetaryBenefitAward entity) {
        this.entity = entity;
    }

    @Override
    public String getAwardReasonCode() {
        return this.awardReasonCode;
    }

    @Override
    public String getEffectiveDate() {
        return this.effectiveDate;
    }

    @Override
    public String getTerminationDate() {
        return this.terminationDate;
    }

    @Override
    public String[] getTerminationReasonCodes() {
        return this.terminationReasonCodes;
    }
}

