/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity.metaData;

import gov.va.med.esr.common.builder.datatype.metadata.CE;
import gov.va.med.esr.common.builder.entity.RatedDisabilityMetaData;
import gov.va.med.esr.common.builder.entity.metaData.AbstractMetaData;
import gov.va.med.esr.common.model.ee.RatedDisability;
import gov.va.med.fw.hl7.segment.ZRD;

public class RatedDisabilityMetaDataFromZRD
extends AbstractMetaData
implements RatedDisabilityMetaData {
    private RatedDisability entity;
    private ZRD zrd;
    private CE disability;

    public RatedDisabilityMetaDataFromZRD(ZRD zrd) {
        this.zrd = zrd;
        this.disability = zrd == null ? null : CE.create(zrd.getDisabilityCondition(), zrd.getComponentDelimiter());
    }

    @Override
    public RatedDisability getEntity() {
        return this.entity;
    }

    @Override
    public void setEntity(RatedDisability entity) {
        this.entity = entity;
    }

    @Override
    public String getDisability() {
        return this.disability == null ? null : super.getValue(this.disability.getID());
    }

    @Override
    public String getPercentage() {
        return this.zrd == null ? null : this.zrd.getDisabilityPercentage();
    }

    @Override
    public String getServiceConnected() {
        return this.zrd == null ? null : this.zrd.getServiceConnected();
    }

    @Override
    public String getDiagnosticExtremity() {
        return this.zrd == null ? null : this.zrd.getDiagnosticExtremity();
    }

    @Override
    public String getRatedDisabilityOrigEffectiveDate() {
        return this.zrd == null ? null : this.zrd.getRatedDisabilityOrigEffectiveDate();
    }

    @Override
    public String getRatedDisabilityCurrentEffectiveDate() {
        return this.zrd == null ? null : this.zrd.getRatedDisabilityCurrentEffectiveDate();
    }
}

