/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity.metaData;

import gov.va.med.esr.common.builder.datatype.metadata.CE;
import gov.va.med.esr.common.builder.datatype.metadata.HD;
import gov.va.med.esr.common.builder.datatype.metadata.XCN;
import gov.va.med.esr.common.builder.entity.NoseThroatRadiumMetaData;
import gov.va.med.esr.common.builder.entity.metaData.AbstractMetaData;
import gov.va.med.esr.common.model.ee.NoseThroatRadium;
import gov.va.med.fw.hl7.segment.OBX;

public class NoseThroatRadiumMetaDataFromOBX
extends AbstractMetaData
implements NoseThroatRadiumMetaData {
    private NoseThroatRadium entity;
    private OBX obx;
    private CE ce;
    private HD hd;
    private String diagnosedWithCancer;
    private String fromAviatorServiceBefore1955;
    private String fromSubmarinerServiceBefore1965;
    private String receivingTreatment;

    public NoseThroatRadiumMetaDataFromOBX(OBX obx) {
        this.obx = obx;
        this.ce = obx == null ? null : CE.create(obx.getObservationMethod(), obx.getComponentDelimiter());
        XCN xcn = obx == null ? null : XCN.create(obx.getResponsibleObserver(), obx.getComponentDelimiter(), obx.getSubComponentDelimiter());
        HD hD = this.hd = xcn == null ? null : xcn.getAssigningFacility();
        if (obx != null) {
            this.processObservations(CE.create(obx.getObservationValue(), obx.getRepeatDelimiter(), obx.getComponentDelimiter()));
        }
    }

    private void processObservations(CE[] observations) {
        if (observations != null) {
            for (int index = 0; index < observations.length; ++index) {
                CE value = observations[index];
                String id = super.getValue(value.getID());
                if ("1".equals(id)) {
                    this.receivingTreatment = "T";
                    continue;
                }
                if ("2".equals(id)) {
                    this.fromAviatorServiceBefore1955 = "1";
                    continue;
                }
                if ("3".equals(id)) {
                    this.fromSubmarinerServiceBefore1965 = "1";
                    continue;
                }
                if ("4".equals(id)) {
                    this.diagnosedWithCancer = "1";
                    continue;
                }
                if ("5".equals(id)) {
                    this.receivingTreatment = "F";
                    continue;
                }
                if ("6".equals(id)) {
                    this.fromAviatorServiceBefore1955 = "0";
                    continue;
                }
                if ("7".equals(id)) {
                    this.fromSubmarinerServiceBefore1965 = "0";
                    continue;
                }
                if ("8".equals(id)) {
                    this.diagnosedWithCancer = "0";
                    continue;
                }
                if (!"9".equals(id)) continue;
                this.receivingTreatment = "U";
            }
        }
    }

    @Override
    public NoseThroatRadium getEntity() {
        return this.entity;
    }

    @Override
    public void setEntity(NoseThroatRadium entity) {
        this.entity = entity;
    }

    @Override
    public String getDiagnosedWithCancer() {
        return this.diagnosedWithCancer;
    }

    @Override
    public String getFromAviatorServiceBefore1955() {
        return this.fromAviatorServiceBefore1955;
    }

    @Override
    public String getFromSubmarinerServiceBefore1965() {
        return this.fromSubmarinerServiceBefore1965;
    }

    @Override
    public String getReceivingTreatment() {
        return this.receivingTreatment;
    }

    @Override
    public String getVerificationDate() {
        return this.obx == null ? null : this.obx.getObservationDate();
    }

    @Override
    public String getVerificationFacility() {
        return this.obx == null ? null : this.obx.getProducerID();
    }

    @Override
    public String getVerificationMethod() {
        return this.ce == null ? null : super.getValue(this.ce.getID());
    }

    public String getDeterminationDate() {
        return this.obx == null ? null : this.obx.getLastObservationNormalValueDate();
    }

    @Override
    public String getDeterminationFacility() {
        return this.hd == null ? null : super.getValue(this.hd.getUniversalID());
    }
}

