/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity.metaData;

import gov.va.med.esr.common.builder.entity.FinancialInformationMetaData;
import gov.va.med.esr.common.builder.entity.FinancialStatementMetaData;
import gov.va.med.esr.common.builder.entity.metaData.DependentFinancialsMetaDataFromZDP;
import gov.va.med.esr.common.builder.entity.metaData.FinancialInformationMetaDataFromZIC;
import gov.va.med.esr.common.builder.entity.metaData.SpouseFinancialsMetaDataFromZDP;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.lookup.Relationship;
import gov.va.med.fw.hl7.Segment;
import gov.va.med.fw.hl7.segment.ZDP;
import gov.va.med.fw.hl7.segment.ZEM;
import gov.va.med.fw.hl7.segment.ZIC;
import gov.va.med.fw.hl7.segment.ZIR;
import gov.va.med.fw.hl7.segment.ZMT;
import java.util.HashSet;
import java.util.List;

public class FinancialStatementMetaDataFromZIC
extends FinancialInformationMetaDataFromZIC
implements FinancialStatementMetaData {
    private FinancialStatement entity;
    private ZIR zir = null;
    private ZMT zmt = null;
    private FinancialInformationMetaData[] supportingInformation;

    public FinancialStatementMetaDataFromZIC(ZIC zic, ZMT zmt, List segments) {
        super(zic, zmt);
        this.zmt = zmt;
        this.processSegments(segments);
    }

    private void processSegments(List segments) {
        ZEM zem = null;
        boolean onDependents = false;
        HashSet<Segment[]> dependents = new HashSet<Segment[]>();
        Segment[] dependentSegments = null;
        for (Segment current : segments) {
            if (current instanceof ZEM) {
                ZEM temp = (ZEM)current;
                if (!"2".equals(temp.getSetID())) continue;
                zem = temp;
                continue;
            }
            if (current instanceof ZIC) {
                if (!onDependents) continue;
                dependentSegments[1] = current;
                continue;
            }
            if (current instanceof ZIR) {
                if (onDependents) {
                    dependentSegments[2] = current;
                    continue;
                }
                this.zir = (ZIR)current;
                continue;
            }
            if (!(current instanceof ZDP)) continue;
            onDependents = true;
            dependentSegments = new Segment[3];
            dependentSegments[0] = current;
            dependents.add(dependentSegments);
        }
        this.supportingInformation = new FinancialInformationMetaData[dependents.size()];
        int index = 0;
        for (Segment[] current : dependents) {
            ZDP zdp = (ZDP)current[0];
            ZIC zic = (ZIC)current[1];
            ZIR zir = (ZIR)current[2];
            this.supportingInformation[index] = Relationship.CODE_SPOUSE.getName().equals(zdp.getRelationship()) ? new SpouseFinancialsMetaDataFromZDP(zdp, zic, zir, zem, this.zir, this.zmt) : new DependentFinancialsMetaDataFromZDP(zdp, zic, zir, this.zmt);
            ++index;
        }
    }

    @Override
    public FinancialStatement getEntity() {
        return this.entity;
    }

    @Override
    public void setEntity(FinancialStatement entity) {
        this.entity = entity;
    }

    @Override
    public String getContributionToSpouse() {
        return this.zir == null ? null : this.zir.getAmountContributedToSpouseDep();
    }

    @Override
    public String getContributedToSpouseInd() {
        return this.zir == null ? null : this.zir.getSpousalSupportIndicator();
    }

    @Override
    public String getMarriedLastCalendarYear() {
        return this.zir == null ? null : this.zir.getMarriedLastCalendarYear();
    }

    @Override
    public String getNumberOfDependentChildren() {
        return this.zir == null ? null : this.zir.getNumberOfDependentChildren();
    }

    @Override
    public String getMeansTestVersion() {
        return this.zmt == null ? null : this.zmt.getMeansTestVersion();
    }

    @Override
    public FinancialInformationMetaData[] getSupportingInformation() {
        return this.supportingInformation;
    }
}

