/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity.metaData;

import gov.va.med.esr.common.builder.datatype.metadata.CE;
import gov.va.med.esr.common.builder.entity.FeeBasisMetaData;
import gov.va.med.esr.common.builder.entity.metaData.AbstractMetaData;
import gov.va.med.esr.common.model.ee.FeeBasis;
import gov.va.med.fw.hl7.segment.MSH;
import gov.va.med.fw.hl7.segment.ZFE;

public class FeeBasisMetaDataFromZFE
extends AbstractMetaData
implements FeeBasisMetaData {
    private FeeBasis entity;
    private CE treatmentCode;
    private CE feeBasisProgram;
    private MSH msh;
    private ZFE zfe;

    public FeeBasisMetaDataFromZFE(ZFE zfe, MSH msh) {
        this.msh = msh;
        this.zfe = zfe;
        this.feeBasisProgram = zfe == null ? null : CE.create(zfe.getFeeBasisProgram(), zfe.getComponentDelimiter());
        this.treatmentCode = zfe == null ? null : CE.create(zfe.getTreatmentCode(), zfe.getComponentDelimiter());
    }

    @Override
    public FeeBasis getEntity() {
        return this.entity;
    }

    @Override
    public void setEntity(FeeBasis entity) {
        this.entity = entity;
    }

    @Override
    public String getAuthorizationFromDate() {
        return this.zfe == null ? null : this.zfe.getAuthorizationFromDate();
    }

    @Override
    public String getAuthorizationToDate() {
        return this.zfe == null ? null : this.zfe.getAuthorizationToDate();
    }

    @Override
    public String getFeeBasisProgram() {
        return this.feeBasisProgram == null ? null : super.getValue(this.feeBasisProgram.getID());
    }

    @Override
    public String getReportSite() {
        return this.msh == null ? null : this.msh.getSendingFacility();
    }

    @Override
    public String getTreatmentTypeCode() {
        return this.treatmentCode == null ? null : super.getValue(this.treatmentCode.getID());
    }
}

