/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity.metaData;

import gov.va.med.esr.common.builder.datatype.metadata.CE;
import gov.va.med.esr.common.builder.datatype.metadata.DR;
import gov.va.med.esr.common.builder.datatype.metadata.TS;
import gov.va.med.esr.common.builder.entity.ConflictExperienceMetaData;
import gov.va.med.esr.common.builder.entity.metaData.AbstractMetaData;
import gov.va.med.esr.common.model.ee.ConflictExperience;
import gov.va.med.fw.hl7.segment.ZMH;

public class ConflictExperienceMetaDataFromZMH
extends AbstractMetaData
implements ConflictExperienceMetaData {
    private ConflictExperience entity;
    private ZMH zmh;
    private CE indicator;
    private DR dateRange;

    public ConflictExperienceMetaDataFromZMH(ZMH zmh) {
        this.zmh = zmh;
        this.indicator = zmh == null ? null : CE.create(zmh.getServiceIndicator(), zmh.getComponentDelimiter());
        this.dateRange = zmh == null ? null : DR.create(zmh.getServiceEntryDateAndServiceSeparationDate(), zmh.getComponentDelimiter(), zmh.getSubComponentDelimiter());
    }

    private String getValueFromTS(TS value) {
        return value == null ? null : super.getValue(value.getDateTime());
    }

    @Override
    public ConflictExperience getEntity() {
        return this.entity;
    }

    @Override
    public void setEntity(ConflictExperience entity) {
        this.entity = entity;
    }

    @Override
    public String getConflict() {
        String militaryHistoryType = this.zmh == null ? null : this.zmh.getMilitaryHistoryType();
        boolean isCombatExperience = "COMB".equals(militaryHistoryType);
        String conflictLocation = null;
        conflictLocation = isCombatExperience ? (this.indicator == null ? null : super.getValue(this.indicator.getText())) : militaryHistoryType;
        return conflictLocation;
    }

    @Override
    public String getEndDate() {
        return this.dateRange == null ? null : this.getValueFromTS(this.dateRange.getEndDateTime());
    }

    @Override
    public String getIndicator() {
        return this.indicator == null ? null : super.getValue(this.indicator.getID());
    }

    @Override
    public String getStartDate() {
        return this.dateRange == null ? null : this.getValueFromTS(this.dateRange.getStartDateTime());
    }
}

