/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity;

import gov.va.med.esr.common.builder.entity.EntityBuilder;
import gov.va.med.esr.common.builder.entity.VAPensionMetaData;
import gov.va.med.esr.common.model.ee.MonetaryBenefit;
import gov.va.med.esr.common.model.ee.MonetaryBenefitAward;
import gov.va.med.esr.common.model.ee.Pension;
import gov.va.med.esr.common.model.lookup.MonetaryBenefitType;
import gov.va.med.esr.common.model.lookup.PensionReasonCode;
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;

public class VAPensionBuilder
extends EntityBuilder {
    private static final long serialVersionUID = -7222898023852297548L;
    private Builder typeBuilder;
    private Builder pensionReasonCodeBuilder;

    public Builder getPensionReasonCodeBuilder() {
        return this.pensionReasonCodeBuilder;
    }

    public void setPensionReasonCodeBuilder(Builder pensionReasonCodeBuilder) {
        this.pensionReasonCodeBuilder = pensionReasonCodeBuilder;
    }

    public Builder getTypeBuilder() {
        return this.typeBuilder;
    }

    public void setTypeBuilder(Builder typeBuilder) {
        this.typeBuilder = typeBuilder;
    }

    public MonetaryBenefitAward build(VAPensionMetaData metaData) throws BuilderException {
        MonetaryBenefitAward input = metaData.getEntity();
        MonetaryBenefitAward output = input == null ? new MonetaryBenefitAward() : input;
        this.transfer(output, metaData);
        return output;
    }

    private void transfer(MonetaryBenefitAward input, VAPensionMetaData metaData) throws BuilderException {
        Pension pension;
        MonetaryBenefit ben = input.getVAPension();
        if (ben == null) {
            ben = new MonetaryBenefit();
            ben.setType((MonetaryBenefitType)((Object)this.typeBuilder.build((Object)MonetaryBenefitType.CODE_VA_PENSION.getCode())));
            input.addMonetaryBenefit(ben);
        }
        if ((pension = ben.getPension()) == null) {
            pension = new Pension();
            pension.setMonetaryBenefit(ben);
            ben.setPension(pension);
        }
        pension.setEffectiveDate(this.build(pension.getEffectiveDate(), metaData.getEffectiveDate()));
        pension.setTerminationDate(this.build(pension.getTerminationDate(), metaData.getTerminationDate()));
        if (metaData.getAwardReasonCode() != null) {
            pension.setAwardReasonCode((PensionReasonCode)((Object)this.pensionReasonCodeBuilder.build((Object)metaData.getAwardReasonCode())));
        }
        if (metaData.getTerminationReasonCodes()[0] != null) {
            pension.setTerminationReasonCode1((PensionReasonCode)((Object)this.pensionReasonCodeBuilder.build((Object)metaData.getTerminationReasonCodes()[0])));
        }
        if (metaData.getTerminationReasonCodes()[1] != null) {
            pension.setTerminationReasonCode2((PensionReasonCode)((Object)this.pensionReasonCodeBuilder.build((Object)metaData.getTerminationReasonCodes()[1])));
        }
        if (metaData.getTerminationReasonCodes()[2] != null) {
            pension.setTerminationReasonCode3((PensionReasonCode)((Object)this.pensionReasonCodeBuilder.build((Object)metaData.getTerminationReasonCodes()[2])));
        }
        if (metaData.getTerminationReasonCodes()[3] != null) {
            pension.setTerminationReasonCode4((PensionReasonCode)((Object)this.pensionReasonCodeBuilder.build((Object)metaData.getTerminationReasonCodes()[3])));
        }
    }
}

