/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity;

import gov.va.med.esr.common.builder.entity.AddressMetaData;
import gov.va.med.esr.common.builder.entity.EmploymentMetaData;
import gov.va.med.esr.common.builder.entity.PhoneMetaData;
import gov.va.med.esr.common.builder.entity.RelationBuilder;
import gov.va.med.esr.common.builder.entity.SpouseMetaData;
import gov.va.med.esr.common.model.lookup.AddressType;
import gov.va.med.esr.common.model.lookup.PhoneType;
import gov.va.med.esr.common.model.lookup.Relationship;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.party.Phone;
import gov.va.med.esr.common.model.person.Employment;
import gov.va.med.esr.common.model.person.Spouse;
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;

public class SpouseBuilder
extends RelationBuilder {
    private static final long serialVersionUID = 7763815323833215233L;
    private Builder employmentBuilder;
    private Builder addressBuilder;
    private Builder addressTypeBuilder;
    private Builder phoneBuilder;
    private Builder phoneTypeBuilder;

    public Builder getAddressBuilder() {
        return this.addressBuilder;
    }

    public void setAddressBuilder(Builder addressBuilder) {
        this.addressBuilder = addressBuilder;
    }

    public Builder getAddressTypeBuilder() {
        return this.addressTypeBuilder;
    }

    public void setAddressTypeBuilder(Builder addressTypeBuilder) {
        this.addressTypeBuilder = addressTypeBuilder;
    }

    public Builder getPhoneBuilder() {
        return this.phoneBuilder;
    }

    public void setPhoneBuilder(Builder phoneBuilder) {
        this.phoneBuilder = phoneBuilder;
    }

    public Builder getPhoneTypeBuilder() {
        return this.phoneTypeBuilder;
    }

    public void setPhoneTypeBuilder(Builder phoneTypeBuilder) {
        this.phoneTypeBuilder = phoneTypeBuilder;
    }

    public Builder getEmploymentBuilder() {
        return this.employmentBuilder;
    }

    public void setEmploymentBuilder(Builder employmentBuilder) {
        this.employmentBuilder = employmentBuilder;
    }

    public Spouse build(SpouseMetaData metaData) throws BuilderException {
        Spouse input = metaData.getEntity();
        Spouse output = input == null ? new Spouse() : input;
        this.transfer(output, metaData);
        return this.shouldKeep(output) ? output : null;
    }

    protected boolean shouldKeep(Spouse spouse) {
        return super.shouldKeep(spouse);
    }

    protected void transfer(Spouse spouse, SpouseMetaData metaData) throws BuilderException {
        super.transfer(spouse, metaData);
        spouse.setMaidenName(super.build(spouse.getMaidenName(), metaData.getMaidenName()));
        spouse.setRelationship(super.buildRelationship(spouse.getRelationship(), Relationship.CODE_SPOUSE.getName()));
        spouse.setEmployment(this.buildEmployment(spouse.getEmployment(), metaData.getEmployment()));
        spouse.setAddress(this.buildAddress(spouse.getAddress(), metaData.getAddress()));
        spouse.setHomePhone(this.buildHomePhone(spouse.getHomePhone(), metaData.getPhone()));
    }

    private Employment buildEmployment(Employment input, EmploymentMetaData metaData) throws BuilderException {
        if (metaData == null) {
            return null;
        }
        metaData.setEntity(input);
        return (Employment)((Object)this.employmentBuilder.build((Object)metaData));
    }

    private Address buildAddress(Address input, AddressMetaData metaData) throws BuilderException {
        if (metaData == null) {
            return null;
        }
        metaData.setEntity(input);
        Address address = (Address)this.addressBuilder.build((Object)metaData);
        AddressType addressType = (AddressType)((Object)this.addressTypeBuilder.build((Object)AddressType.CODE_PERMANENT_ADDRESS.getCode()));
        address.setType(addressType);
        return address;
    }

    private Phone buildHomePhone(Phone input, PhoneMetaData metaData) throws BuilderException {
        if (metaData == null) {
            return null;
        }
        metaData.setEntity(input);
        Phone phone = (Phone)((Object)this.phoneBuilder.build((Object)metaData));
        PhoneType phoneType = (PhoneType)((Object)this.phoneTypeBuilder.build((Object)PhoneType.CODE_HOME.getCode()));
        phone.setType(phoneType);
        return phone;
    }
}

