/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity;

import gov.va.med.esr.common.builder.entity.EntityBuilder;
import gov.va.med.esr.common.builder.entity.ReceivedEnrollmentMetaData;
import gov.va.med.esr.common.builder.entity.metaData.ReceivedEnrollmentMetaDataFromZEN;
import gov.va.med.esr.common.model.ee.ReceivedEnrollment;
import gov.va.med.esr.common.model.lookup.EnrollmentPriorityGroup;
import gov.va.med.esr.common.model.lookup.EnrollmentPrioritySubGroup;
import gov.va.med.esr.common.model.lookup.EnrollmentSource;
import gov.va.med.esr.common.model.lookup.EnrollmentStatus;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.fw.hl7.HL7Message;
import gov.va.med.fw.hl7.InvalidMessageException;
import gov.va.med.fw.model.lookup.AbstractLookup;
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;

public class ReceivedEnrollmentBuilder
extends EntityBuilder {
    private static final long serialVersionUID = 7764079829094080860L;
    private Builder calculationSourceBuilder;
    private Builder dataSourceBuilder;
    private Builder priorityGroupBuilder;
    private Builder prioritySubGroupBuilder;
    private Builder statusBuilder;

    public Builder getCalculationSourceBuilder() {
        return this.calculationSourceBuilder;
    }

    public void setCalculationSourceBuilder(Builder calculationSourceBuilder) {
        this.calculationSourceBuilder = calculationSourceBuilder;
    }

    public Builder getDataSourceBuilder() {
        return this.dataSourceBuilder;
    }

    public void setDataSourceBuilder(Builder dataSourceBuilder) {
        this.dataSourceBuilder = dataSourceBuilder;
    }

    public Builder getPriorityGroupBuilder() {
        return this.priorityGroupBuilder;
    }

    public void setPriorityGroupBuilder(Builder priorityGroupBuilder) {
        this.priorityGroupBuilder = priorityGroupBuilder;
    }

    public Builder getPrioritySubGroupBuilder() {
        return this.prioritySubGroupBuilder;
    }

    public void setPrioritySubGroupBuilder(Builder prioritySubGroupBuilder) {
        this.prioritySubGroupBuilder = prioritySubGroupBuilder;
    }

    public Builder getStatusBuilder() {
        return this.statusBuilder;
    }

    public void setStatusBuilder(Builder statusBuilder) {
        this.statusBuilder = statusBuilder;
    }

    public ReceivedEnrollment build(Person person, HL7Message message) throws BuilderException, InvalidMessageException {
        ReceivedEnrollment enrollment = person.getReceivedEnrollment();
        ReceivedEnrollmentMetaDataFromZEN metaData = new ReceivedEnrollmentMetaDataFromZEN(message.getZENSegment());
        metaData.setEntity(enrollment);
        return this.build(metaData);
    }

    public ReceivedEnrollment build(ReceivedEnrollmentMetaData metaData) throws BuilderException {
        ReceivedEnrollment input = metaData.getEntity();
        ReceivedEnrollment output = input == null ? new ReceivedEnrollment() : input;
        this.transfer(output, metaData);
        return this.shouldKeep(output) ? output : null;
    }

    private EnrollmentSource buildCalculationSource(EnrollmentSource input, String code) throws BuilderException {
        return (EnrollmentSource)super.build(this.calculationSourceBuilder, (AbstractLookup)input, code);
    }

    private EnrollmentPriorityGroup buildPriorityGroup(EnrollmentPriorityGroup input, String code) throws BuilderException {
        return (EnrollmentPriorityGroup)super.build(this.priorityGroupBuilder, (AbstractLookup)input, code);
    }

    private EnrollmentPrioritySubGroup buildPrioritySubGroup(EnrollmentPrioritySubGroup input, String code) throws BuilderException {
        return (EnrollmentPrioritySubGroup)super.build(this.prioritySubGroupBuilder, (AbstractLookup)input, code);
    }

    private EnrollmentStatus buildStatus(EnrollmentStatus input, String code) throws BuilderException {
        return (EnrollmentStatus)super.build(this.statusBuilder, (AbstractLookup)input, code);
    }

    private boolean shouldKeep(ReceivedEnrollment obj) {
        return true;
    }

    private void transfer(ReceivedEnrollment input, ReceivedEnrollmentMetaData metaData) throws BuilderException {
        input.setCalculationSource(this.buildCalculationSource(input.getCalculationSource(), metaData.getCalculationSource()));
        input.setEffectiveDate(super.build(input.getEffectiveDate(), metaData.getEffectiveDate()));
        input.setEndDate(super.build(input.getEndDate(), metaData.getEndDate()));
        input.setEnrollmentDate(super.build(input.getEnrollmentDate(), metaData.getEnrollmentDate()));
        input.setFacilityReceived(super.build(input.getFacilityReceived(), metaData.getFacilityReceived()));
        input.setOverridden(super.build(input.getOverridden(), metaData.getOverrideFlag()));
        input.setPriorityGroup(this.buildPriorityGroup(input.getPriorityGroup(), metaData.getPriorityGroup()));
        input.setPrioritySubGroup(this.buildPrioritySubGroup(input.getPrioritySubGroup(), metaData.getPrioritySubGroup()));
        input.setEnrollmentStatus(this.buildStatus(input.getEnrollmentStatus(), metaData.getStatus()));
    }
}

