/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity;

import gov.va.med.esr.common.builder.entity.BirthRecordMetaData;
import gov.va.med.esr.common.builder.entity.DeathRecordMetaData;
import gov.va.med.esr.common.builder.entity.EntityBuilder;
import gov.va.med.esr.common.builder.entity.EthnicityMetaData;
import gov.va.med.esr.common.builder.entity.NameMetaData;
import gov.va.med.esr.common.builder.entity.PersonMetaData;
import gov.va.med.esr.common.builder.entity.RaceMetaData;
import gov.va.med.esr.common.builder.entity.SSNMetaData;
import gov.va.med.esr.common.builder.entity.metaData.PersonMetaDataFromPID;
import gov.va.med.esr.common.model.ee.PrisonerOfWar;
import gov.va.med.esr.common.model.lookup.EmergencyResponse;
import gov.va.med.esr.common.model.lookup.Gender;
import gov.va.med.esr.common.model.lookup.Indicator;
import gov.va.med.esr.common.model.lookup.MaritalStatus;
import gov.va.med.esr.common.model.lookup.NameType;
import gov.va.med.esr.common.model.lookup.Relationship;
import gov.va.med.esr.common.model.lookup.Religion;
import gov.va.med.esr.common.model.person.BirthRecord;
import gov.va.med.esr.common.model.person.DeathRecord;
import gov.va.med.esr.common.model.person.EmergencyResponseIndicator;
import gov.va.med.esr.common.model.person.Ethnicity;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.PreferredFacility;
import gov.va.med.esr.common.model.person.Race;
import gov.va.med.esr.common.model.person.Relation;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.fw.hl7.HL7Message;
import gov.va.med.fw.hl7.InvalidMessageException;
import gov.va.med.fw.hl7.segment.ZEM;
import gov.va.med.fw.model.lookup.AbstractLookup;
import gov.va.med.fw.util.StringUtils;
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class PersonBuilder
extends EntityBuilder {
    private static final long serialVersionUID = -8951207515778923723L;
    private Builder birthRecordBuilder;
    private Builder deathRecordBuilder;
    private Builder emergencyResponseBuilder;
    private Builder genderBuilder;
    private Builder maritalStatusBuilder;
    private Builder nameBuilder;
    private Builder nameTypeBuilder;
    private Builder ssnBuilder;
    private Builder relationshipBuilder;
    private Builder raceBuilder;
    private Builder ethnicityBuilder;
    private Builder religionBuilder;

    public Builder getBirthRecordBuilder() {
        return this.birthRecordBuilder;
    }

    public void setBirthRecordBuilder(Builder birthRecordBuilder) {
        this.birthRecordBuilder = birthRecordBuilder;
    }

    public Builder getDeathRecordBuilder() {
        return this.deathRecordBuilder;
    }

    public void setDeathRecordBuilder(Builder deathRecordBuilder) {
        this.deathRecordBuilder = deathRecordBuilder;
    }

    public Builder getEmergencyResponseBuilder() {
        return this.emergencyResponseBuilder;
    }

    public void setEmergencyResponseBuilder(Builder emergencyResponseBuilder) {
        this.emergencyResponseBuilder = emergencyResponseBuilder;
    }

    public Builder getGenderBuilder() {
        return this.genderBuilder;
    }

    public void setGenderBuilder(Builder genderBuilder) {
        this.genderBuilder = genderBuilder;
    }

    public Builder getMaritalStatusBuilder() {
        return this.maritalStatusBuilder;
    }

    public void setMaritalStatusBuilder(Builder maritalStatusBuilder) {
        this.maritalStatusBuilder = maritalStatusBuilder;
    }

    public Builder getNameBuilder() {
        return this.nameBuilder;
    }

    public void setNameBuilder(Builder nameBuilder) {
        this.nameBuilder = nameBuilder;
    }

    public Builder getNameTypeBuilder() {
        return this.nameTypeBuilder;
    }

    public void setNameTypeBuilder(Builder nameTypeBuilder) {
        this.nameTypeBuilder = nameTypeBuilder;
    }

    public Builder getSsnBuilder() {
        return this.ssnBuilder;
    }

    public void setSsnBuilder(Builder ssnBuilder) {
        this.ssnBuilder = ssnBuilder;
    }

    public Builder getRelationshipBuilder() {
        return this.relationshipBuilder;
    }

    public void setRelationshipBuilder(Builder relationshipBuilder) {
        this.relationshipBuilder = relationshipBuilder;
    }

    public Builder getEthnicityBuilder() {
        return this.ethnicityBuilder;
    }

    public void setEthnicityBuilder(Builder ethnicityBuilder) {
        this.ethnicityBuilder = ethnicityBuilder;
    }

    public Builder getRaceBuilder() {
        return this.raceBuilder;
    }

    public void setRaceBuilder(Builder raceBuilder) {
        this.raceBuilder = raceBuilder;
    }

    public Builder getReligionBuilder() {
        return this.religionBuilder;
    }

    public void setReligionBuilder(Builder religionBuilder) {
        this.religionBuilder = religionBuilder;
    }

    public Person build(Person input, HL7Message message) throws BuilderException, InvalidMessageException {
        ZEM zem = null;
        List zems = message.getZEMSegments();
        Iterator i = zems.iterator();
        while (zem == null && i.hasNext()) {
            ZEM temp = (ZEM)i.next();
            if (!"1".equals(temp.getSetID())) continue;
            zem = temp;
        }
        PersonMetaDataFromPID metaData = new PersonMetaDataFromPID(message.getPIDSegment(), message.getZPDSegment(), zem, message.getZENSegment(), message.getZELSegment(), message.getMSHSegment(), message.getZMHSegments(), message.getZIOSegment());
        metaData.setEntity(input);
        return this.build(metaData);
    }

    public Person build(PersonMetaData metaData) throws BuilderException {
        Person input = metaData.getEntity();
        Person output = input == null ? new Person() : input;
        this.transfer(output, metaData);
        return this.shouldKeep(output) ? output : null;
    }

    private BirthRecord buildBirthRecord(BirthRecord input, BirthRecordMetaData metaData) throws BuilderException {
        if (metaData == null) {
            return null;
        }
        metaData.setEntity(input);
        return (BirthRecord)((Object)this.birthRecordBuilder.build((Object)metaData));
    }

    private DeathRecord buildDeathRecord(DeathRecord input, DeathRecordMetaData metaData) throws BuilderException {
        if (metaData == null) {
            return null;
        }
        metaData.setEntity(input);
        return (DeathRecord)((Object)this.deathRecordBuilder.build((Object)metaData));
    }

    private Gender buildGender(Gender input, String code) throws BuilderException {
        return (Gender)super.build(this.genderBuilder, (AbstractLookup)input, code);
    }

    private MaritalStatus buildMaritalStatus(MaritalStatus input, String code) throws BuilderException {
        return (MaritalStatus)super.build(this.maritalStatusBuilder, (AbstractLookup)input, code);
    }

    private Name buildName(Name input, NameMetaData metaData) throws BuilderException {
        if (metaData == null) {
            return null;
        }
        metaData.setEntity(input);
        return (Name)this.nameBuilder.build((Object)metaData);
    }

    private void buildNames(Person input, NameMetaData[] metaData) throws BuilderException {
        HashSet toAdd = new HashSet();
        HashSet toRemove = new HashSet(input.getNames());
        for (int index = 0; index < (metaData == null ? 0 : metaData.length); ++index) {
            this.processName(toAdd, metaData[index]);
        }
        Iterator i = toRemove.iterator();
        while (i.hasNext()) {
            input.removeName((Name)i.next());
        }
        i = toAdd.iterator();
        while (i.hasNext()) {
            input.addName((Name)i.next());
        }
    }

    private NameMetaData getLegalNameMetaData(NameMetaData[] namesMetaData) {
        for (int index = 0; index < (namesMetaData == null ? 0 : namesMetaData.length); ++index) {
            if (!NameType.LEGAL_NAME.getCode().equals(namesMetaData[index].getType())) continue;
            return namesMetaData[index];
        }
        return null;
    }

    private boolean shouldKeep(Person obj) {
        return obj.getEntityKey() != null;
    }

    private void processName(Set toAdd, NameMetaData metaData) throws BuilderException {
        Name value = this.buildName(null, metaData);
        if (value != null) {
            toAdd.add(value);
        }
    }

    private void buildRelationWNameOnly(Person input, NameMetaData metaData, String relationshipCode) throws BuilderException {
        Name value;
        Name nameInput = null;
        Relation relation = input.getRelation(relationshipCode);
        if (relation != null) {
            nameInput = relation.getName();
        }
        if (relation != null && metaData != null && "".equals(metaData.getFamilyName())) {
            input.removeRelation(relation);
            return;
        }
        if (relation != null && metaData != null && relation.getName() != null && relation.getName().getGivenName() != null && metaData.getGivenName() == null) {
            relation.getName().setGivenName(null);
        }
        if (relation != null && metaData != null && relation.getName() != null && relation.getName().getMiddleName() != null && metaData.getMiddleName() == null) {
            relation.getName().setMiddleName(null);
        }
        if ((value = this.buildName(nameInput, metaData)) != null) {
            if (relation == null) {
                relation = new Relation();
                Relationship relationship = (Relationship)super.build(this.relationshipBuilder, null, relationshipCode);
                relation.setRelationship(relationship);
                relation.setName(value);
            }
            input.setRelation(relationshipCode, relation);
        }
    }

    private void buildSsns(Person input, SSNMetaData[] metaData) throws BuilderException {
        HashSet toAdd = new HashSet();
        HashSet toRemove = new HashSet(input.getSsns());
        for (int index = 0; index < (metaData == null ? 0 : metaData.length); ++index) {
            this.processSsn(toAdd, metaData[index]);
        }
        Iterator i = toRemove.iterator();
        while (i.hasNext()) {
            input.removeSsn((SSN)((Object)i.next()));
        }
        i = toAdd.iterator();
        while (i.hasNext()) {
            input.addSsn((SSN)((Object)i.next()));
        }
    }

    private void processSsn(Set toAdd, SSNMetaData metaData) throws BuilderException {
        SSN value = this.buildSsn(null, metaData);
        if (value != null) {
            toAdd.add(value);
        }
    }

    private SSN buildSsn(SSN input, SSNMetaData metaData) throws BuilderException {
        if (metaData == null) {
            return null;
        }
        metaData.setEntity(input);
        return (SSN)((Object)this.ssnBuilder.build((Object)metaData));
    }

    private void transfer(Person input, PersonMetaData metaData) throws BuilderException {
        input.setBirthRecord(this.buildBirthRecord(input.getBirthRecord(), metaData.getBirthRecord()));
        input.setDeathRecord(this.buildDeathRecord(input.getDeathRecord(), metaData.getDeathRecord()));
        input.setGender(this.buildGender(input.getGender(), metaData.getGender()));
        input.setMaritalStatus(this.buildMaritalStatus(input.getMaritalStatus(), metaData.getMaritalStatus()));
        this.buildPreferredFacility(input, metaData);
        PrisonerOfWar pow = new PrisonerOfWar();
        Indicator powIndicator = (Indicator)super.build(this.getIndicatorBuilder(), (AbstractLookup)pow.getPowIndicator(), metaData.getWasPrisonerOfWar());
        if (powIndicator != null) {
            pow.setPowIndicator(powIndicator);
            input.setPrisonerOfWar(pow);
        }
        input.setVeteran(super.build(input.isVeteran(), metaData.getVeteran()));
        this.buildNames(input, metaData.getNames());
        this.buildRelationWNameOnly(input, metaData.getMotherName(), Relationship.CODE_MOTHER.getCode());
        this.buildRelationWNameOnly(input, metaData.getFatherName(), Relationship.CODE_FATHER.getCode());
        NameMetaData legalName = this.getLegalNameMetaData(metaData.getNames());
        if (legalName != null) {
            input.setDegree(legalName.getDegree());
        }
        this.buildSsns(input, metaData.getSsns());
        input.setAppointmentRequestDate(super.build(input.getAppointmentRequestDate(), metaData.getAppointmentRequestDate()));
        input.setAppointmentRequestResponse(super.build(input.getAppointmentRequestResponse(), metaData.getAppointmentRequestOn1010EZ()));
        this.buildEmergencyIndicator(input, metaData);
        this.buildRaces(input, metaData.getRaces());
        input.setEthnicity(this.buildEthnicity(input.getEthnicity(), metaData.getEthnicity()));
        input.setReligion(this.buildReligion(input.getReligion(), metaData.getReligion()));
        input.setMothersMaidenName(super.build(input.getMothersMaidenName(), metaData.getMothersMaidenName()));
    }

    private void buildEmergencyIndicator(Person input, PersonMetaData metaData) throws BuilderException {
        EmergencyResponseIndicator emergencyResponseIndicator = new EmergencyResponseIndicator();
        EmergencyResponse emergencyResponse = (EmergencyResponse)super.build(this.emergencyResponseBuilder, (AbstractLookup)emergencyResponseIndicator.getEmergencyResponse(), metaData.getEmergencyResponseType());
        if (emergencyResponse != null) {
            emergencyResponseIndicator.setEmergencyResponse(emergencyResponse);
            input.addEmergencyResponseIndicator(emergencyResponseIndicator);
        }
    }

    private void buildRaces(Person input, RaceMetaData[] metaData) throws BuilderException {
        HashSet toAdd = new HashSet();
        HashSet toRemove = new HashSet(input.getRaces());
        for (int index = 0; index < (metaData == null ? 0 : metaData.length); ++index) {
            this.processRace(toAdd, metaData[index]);
        }
        Iterator i = toRemove.iterator();
        while (i.hasNext()) {
            input.removeRace((Race)((Object)i.next()));
        }
        i = toAdd.iterator();
        while (i.hasNext()) {
            input.addRace((Race)((Object)i.next()));
        }
    }

    private void processRace(Set toAdd, RaceMetaData metaData) throws BuilderException {
        Race value = this.buildRace(null, metaData);
        if (value != null) {
            toAdd.add(value);
        }
    }

    private Race buildRace(Race input, RaceMetaData metaData) throws BuilderException {
        if (metaData == null) {
            return null;
        }
        metaData.setEntity(input);
        return (Race)((Object)this.raceBuilder.build((Object)metaData));
    }

    private Ethnicity buildEthnicity(Ethnicity input, EthnicityMetaData metaData) throws BuilderException {
        if (metaData == null) {
            return null;
        }
        metaData.setEntity(input);
        return (Ethnicity)((Object)this.ethnicityBuilder.build((Object)metaData));
    }

    private Religion buildReligion(Religion input, String code) throws BuilderException {
        return (Religion)super.build(this.religionBuilder, (AbstractLookup)input, code);
    }

    private void buildPreferredFacility(Person input, PersonMetaData metaData) throws BuilderException {
        input.removeAllPreferredFacilities();
        if (!StringUtils.isEmpty((String)metaData.getPreferredFacility())) {
            PreferredFacility pf = new PreferredFacility();
            pf.setFacility(super.build(pf.getFacility(), metaData.getPreferredFacility()));
            input.addPreferredFacility(pf);
        }
    }
}

