/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity;

import gov.va.med.esr.common.builder.entity.EntityBuilder;
import gov.va.med.esr.common.builder.entity.InsuranceSubscriberMetaData;
import gov.va.med.esr.common.builder.entity.NameMetaData;
import gov.va.med.esr.common.model.insurance.InsuranceSubscriber;
import gov.va.med.esr.common.model.lookup.InsuredRelationship;
import gov.va.med.fw.model.lookup.AbstractLookup;
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;

public class InsuranceSubscriberBuilder
extends EntityBuilder {
    private static final long serialVersionUID = 2010629225153484054L;
    private Builder relationshipBuilder;

    public Builder getRelationshipBuilder() {
        return this.relationshipBuilder;
    }

    public void setRelationshipBuilder(Builder relationshipBuilder) {
        this.relationshipBuilder = relationshipBuilder;
    }

    public InsuranceSubscriber build(InsuranceSubscriberMetaData metaData) throws BuilderException {
        InsuranceSubscriber input = metaData.getEntity();
        InsuranceSubscriber output = input == null ? new InsuranceSubscriber() : input;
        this.transfer(output, metaData);
        return this.shouldKeep(output) ? output : null;
    }

    private String buildName(String input, NameMetaData metaData) throws BuilderException {
        if (metaData == null) {
            return input;
        }
        return super.build(input, metaData.getFamilyName());
    }

    private InsuredRelationship buildRelationship(InsuredRelationship input, String code) throws BuilderException {
        return super.shouldDelete(code) ? null : (InsuredRelationship)super.build(this.relationshipBuilder, (AbstractLookup)input, code);
    }

    private boolean shouldKeep(InsuranceSubscriber obj) {
        return obj.getName() != null || obj.getRelationship() != null;
    }

    private void transfer(InsuranceSubscriber input, InsuranceSubscriberMetaData metaData) throws BuilderException {
        input.setName(this.buildName(input.getName(), metaData.getName()));
        input.setRelationship(this.buildRelationship(input.getRelationship(), metaData.getRelationship()));
    }
}

