/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity;

import gov.va.med.esr.common.builder.entity.EligibilityVerificationMetaData;
import gov.va.med.esr.common.builder.entity.EntityBuilder;
import gov.va.med.esr.common.builder.entity.metaData.EligibilityVerificationMetaDataFromZEL;
import gov.va.med.esr.common.model.ee.EligibilityVerification;
import gov.va.med.esr.common.model.lookup.EligibilityStatus;
import gov.va.med.esr.common.model.lookup.EligibilityVerificationSource;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.fw.hl7.HL7Message;
import gov.va.med.fw.hl7.InvalidMessageException;
import gov.va.med.fw.model.lookup.AbstractLookup;
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;

public class EligibilityVerificationBuilder
extends EntityBuilder {
    private static final long serialVersionUID = -5273926109892693698L;
    private Builder sourceBuilder;
    private Builder eligibilityStatusBuilder;

    public Builder getSourceBuilder() {
        return this.sourceBuilder;
    }

    public void setSourceBuilder(Builder sourceBuilder) {
        this.sourceBuilder = sourceBuilder;
    }

    public EligibilityVerification build(Person person, HL7Message message) throws BuilderException, InvalidMessageException {
        EligibilityVerification updated = person.getEligibilityVerification();
        EligibilityVerificationMetaDataFromZEL metaData = new EligibilityVerificationMetaDataFromZEL(message.getZELSegment(), message.getMSHSegment());
        metaData.setEntity(updated);
        return this.build(metaData);
    }

    public EligibilityVerification build(EligibilityVerificationMetaData metaData) throws BuilderException {
        EligibilityVerification input = metaData.getEntity();
        EligibilityVerification output = input == null ? new EligibilityVerification() : input;
        this.transfer(output, metaData);
        return this.shouldKeep(output) ? output : null;
    }

    private EligibilityVerificationSource buildSource(EligibilityVerificationSource input, String code) throws BuilderException {
        return (EligibilityVerificationSource)super.build(this.sourceBuilder, (AbstractLookup)input, code);
    }

    private boolean shouldKeep(EligibilityVerification obj) {
        return obj.getEligibilityStatusDate() != null;
    }

    private void transfer(EligibilityVerification input, EligibilityVerificationMetaData metaData) throws BuilderException {
        input.setEligibilityStatus((EligibilityStatus)super.build(this.eligibilityStatusBuilder, (AbstractLookup)input.getEligibilityStatus(), metaData.getEligibilityStatus()));
        input.setEligibilityStatusDate(super.build(input.getEligibilityStatusDate(), metaData.getEligibilityStatusDate()));
        input.setVerificationFacility(super.build(input.getVerificationFacility(), metaData.getVerificationFacility()));
        input.setVerificationMethod(super.build(input.getVerificationMethod(), metaData.getVerificationMethod()));
        input.setVerificationSource(this.buildSource(input.getVerificationSource(), metaData.getVerificationSource()));
    }

    public Builder getEligibilityStatusBuilder() {
        return this.eligibilityStatusBuilder;
    }

    public void setEligibilityStatusBuilder(Builder eligibilityStatusBuilder) {
        this.eligibilityStatusBuilder = eligibilityStatusBuilder;
    }
}

