/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity;

import gov.va.med.esr.common.builder.entity.EntityBuilder;
import gov.va.med.esr.common.model.ee.Eligibility;
import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.common.model.ee.MilitaryServiceEpisode;
import gov.va.med.esr.common.model.ee.MilitaryServiceSiteRecord;
import gov.va.med.esr.common.model.ee.ServiceConnectionAward;
import gov.va.med.esr.common.model.financials.DependentFinancials;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.lookup.Indicator;
import gov.va.med.esr.common.model.lookup.Relationship;
import gov.va.med.esr.common.model.person.DeathRecord;
import gov.va.med.esr.common.model.person.Dependent;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.external.person.EligibilitySummary;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class EligibilitySummaryBuilder
extends EntityBuilder {
    private static final long serialVersionUID = 4424086576836580427L;

    public EligibilitySummary build(Person person) {
        Map stmts;
        MilitaryService ms;
        ServiceConnectionAward sca;
        DeathRecord dod;
        EligibilitySummary eeSummary = new EligibilitySummary();
        Iterator itr = null;
        eeSummary.setClaimFolderNumber(person.getClaimFolderNumber());
        EnrollmentDetermination ed = person.getEnrollmentDetermination();
        if (ed != null) {
            eeSummary.setEligibilityLastModifiedBy(ed.getModifiedBy().getName());
            Eligibility primaryElig = ed.getPrimaryEligibility();
            if (primaryElig != null && primaryElig.getType() != null) {
                eeSummary.setPrimaryEligibilityCode(primaryElig.getType().getCode());
            }
        }
        if ((dod = person.getDeathRecord()) != null) {
            eeSummary.setDateOfDeathReportingStationNumber(dod.getFacilityReceived() != null ? dod.getFacilityReceived().getStationNumber() : null);
            eeSummary.setDateOfDeathSourceOfNotificationCode(dod.getDataSource() != null ? dod.getDataSource().getCode() : null);
            eeSummary.setDateOfDeathLastModifiedDate(dod.getDeathLastModified() != null ? dod.getDeathLastModified().toString() : null);
        }
        if ((sca = person.getServiceConnectionAward()) != null) {
            eeSummary.setServiceConnected(sca.getServiceConnectedIndicator());
            eeSummary.setServiceConnectedPercentage(sca.getServiceConnectedPercentage());
        }
        if (person.getPrisonerOfWar() != null) {
            Indicator powIndicator = person.getPrisonerOfWar().getPowIndicator();
            eeSummary.setPOWStatusIndicated(powIndicator != null ? powIndicator.toBoolean() : null);
        }
        if ((ms = person.getMilitaryService()) != null) {
            Set siteRecords = ms.getMilitaryServiceSiteRecords();
            itr = siteRecords != null ? siteRecords.iterator() : null;
            MilitaryServiceSiteRecord latestSiteRec = null;
            MilitaryServiceSiteRecord siteRec = null;
            while (itr != null && itr.hasNext()) {
                siteRec = (MilitaryServiceSiteRecord)((Object)itr.next());
                if (latestSiteRec == null) {
                    latestSiteRec = siteRec;
                    continue;
                }
                if (!latestSiteRec.getCreatedOn().before(siteRec.getCreatedOn())) continue;
                latestSiteRec = siteRec;
            }
            if (latestSiteRec != null) {
                eeSummary.setPeriodOfServiceCode(latestSiteRec.getServicePeriod() != null ? latestSiteRec.getServicePeriod().getCode() : null);
                Set episodes = latestSiteRec.getMilitaryServiceEpisodes();
                itr = episodes != null ? episodes.iterator() : null;
                MilitaryServiceEpisode latestEpisode = null;
                MilitaryServiceEpisode episode = null;
                while (itr != null && itr.hasNext()) {
                    episode = (MilitaryServiceEpisode)((Object)itr.next());
                    if (latestEpisode == null) {
                        latestEpisode = episode;
                        continue;
                    }
                    if (latestEpisode.getEndDate() == null || latestEpisode.getEndDate().compareTo(episode.getEndDate()) >= 0) continue;
                    latestEpisode = episode;
                }
                if (latestEpisode != null) {
                    eeSummary.setLastServiceBranchCode(latestEpisode.getServiceBranch() != null ? latestEpisode.getServiceBranch().getCode() : null);
                    eeSummary.setLastServiceNumber(latestEpisode.getServiceNumber());
                    eeSummary.setLastServiceEntryDate(latestEpisode.getStartDate() != null ? latestEpisode.getStartDate().toStandardFormat() : null);
                    eeSummary.setLastServiceSeparationDate(latestEpisode.getEndDate() != null ? latestEpisode.getEndDate().toStandardFormat() : null);
                }
            }
        }
        if ((stmts = person.getFinancialStatements()) != null && !stmts.isEmpty()) {
            itr = stmts != null ? stmts.keySet().iterator() : null;
            Integer incomeYear = null;
            FinancialStatement fs = null;
            Integer latestIncomeYear = null;
            while (itr != null && itr.hasNext()) {
                incomeYear = (Integer)itr.next();
                if (latestIncomeYear == null) {
                    latestIncomeYear = incomeYear;
                    continue;
                }
                if (incomeYear <= latestIncomeYear) continue;
                latestIncomeYear = incomeYear;
            }
            fs = person.getFinancialStatement(latestIncomeYear);
            Set set = fs.getDependentFinancials();
            itr = set != null ? set.iterator() : null;
            DependentFinancials df = null;
            Dependent dep = null;
            if (itr != null && itr.hasNext() && (dep = (df = (DependentFinancials)((Object)itr.next())).getReportedOn()) != null && dep.getRelationship() != null) {
                if (Relationship.CODE_FATHER.getCode().equals(dep.getRelationship().getCode())) {
                    eeSummary.setFathersName(dep.getName().getFormattedName());
                } else if (Relationship.CODE_MOTHER.getCode().equals(dep.getRelationship().getCode())) {
                    eeSummary.setMothersName(dep.getName().getFormattedName());
                }
            }
        }
        return eeSummary;
    }
}

