/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.datatype.metadata;

import gov.va.med.esr.common.builder.datatype.metadata.AbstractDataTypeMetaData;
import gov.va.med.esr.common.builder.datatype.metadata.ComplexTypeMetaData;
import gov.va.med.esr.common.builder.datatype.metadata.HD;
import gov.va.med.esr.common.builder.datatype.metadata.ID;
import gov.va.med.esr.common.builder.datatype.metadata.IS;
import gov.va.med.esr.common.builder.datatype.metadata.NM;
import gov.va.med.esr.common.builder.datatype.metadata.ST;

public class XON
extends ComplexTypeMetaData {
    private static final int POSITION_ORGANIZATION_NAME = 0;
    private static final int POSITION_ORGANIZATION_NAME_TYPE_CODE = 1;
    private static final int POSITION_ID = 2;
    private static final int POSITION_ID_CHECK_DIGIT = 3;
    private static final int POSITION_ID_CHECK_DIGIT_SCHEME_CODE = 4;
    private static final int POSITION_ASSIGNING_AUTHORITY = 5;
    private static final int POSITION_ID_TYPE_CODE = 6;
    private static final int POSITION_ASSIGNING_FACILITY = 7;
    private static final int POSITION_REPRESENTATION_CODE = 8;
    private static final int DATA_SIZE = 9;

    public static XON[] create(String value, String repeatDelimiter, String delimiter, String subDelimiter) {
        if (value == null) {
            return null;
        }
        String[] components = AbstractDataTypeMetaData.splitData(value, repeatDelimiter);
        int size = components == null ? 0 : components.length;
        XON[] elements = new XON[size];
        for (int index = 0; index < size; ++index) {
            elements[index] = XON.create(components[index], delimiter, subDelimiter);
        }
        return elements;
    }

    public static XON create() {
        return new XON(new AbstractDataTypeMetaData[9]);
    }

    public static XON create(String value, String delimiter, String subDelimiter) {
        if (AbstractDataTypeMetaData.shouldDelete(value)) {
            return null;
        }
        AbstractDataTypeMetaData[] data = new AbstractDataTypeMetaData[9];
        String[] components = AbstractDataTypeMetaData.splitData(value, delimiter);
        int size = components == null ? 0 : components.length;
        data[0] = size > 0 ? ST.create(components[0]) : null;
        data[1] = size > 1 ? IS.create(components[1]) : null;
        data[2] = size > 2 ? NM.create(components[2]) : null;
        data[3] = size > 3 ? NM.create(components[3]) : null;
        data[4] = size > 4 ? ID.create(components[4]) : null;
        data[5] = size > 5 ? HD.create(components[5], subDelimiter) : null;
        data[6] = size > 6 ? IS.create(components[6]) : null;
        data[7] = size > 7 ? HD.create(components[7], subDelimiter) : null;
        data[8] = size > 8 ? ID.create(components[8]) : null;
        return new XON(data);
    }

    public static String getDataString(XON[] data, String repeatDelimiter, String delimiter) {
        return AbstractDataTypeMetaData.formatDataString(data, repeatDelimiter, delimiter, null);
    }

    XON(AbstractDataTypeMetaData[] data) {
        super(data);
    }

    public ST getOrganizationName() {
        return (ST)super.getData(0);
    }

    public void setOrganizationName(ST organizationName) {
        super.setData(0, organizationName);
    }

    public IS getGivenName() {
        return (IS)super.getData(1);
    }

    public void setGivenName(IS organizationNameTypeCode) {
        super.setData(1, organizationNameTypeCode);
    }

    public NM getID() {
        return (NM)super.getData(2);
    }

    public void setID(NM id) {
        super.setData(2, id);
    }

    public NM getIDCheckDigit() {
        return (NM)super.getData(3);
    }

    public void setIDCheckDigit(NM idCheckDigit) {
        super.setData(3, idCheckDigit);
    }

    public ID getIDCheckDigitSchemeCode() {
        return (ID)super.getData(4);
    }

    public void setIDCheckDigitSchemeCode(ID idCheckDigitSchemeCode) {
        super.setData(4, idCheckDigitSchemeCode);
    }

    public HD getAssigningAuthority() {
        return (HD)super.getData(5);
    }

    public void setAssigningAuthority(HD assigningAuthority) {
        super.setData(5, assigningAuthority);
    }

    public IS getIDTypeCode() {
        return (IS)super.getData(6);
    }

    public void setIDTypeCode(IS idTypeCode) {
        super.setData(6, idTypeCode);
    }

    public HD getAssigningFacility() {
        return (HD)super.getData(7);
    }

    public void setAssigningFacility(HD assigningFacility) {
        super.setData(7, assigningFacility);
    }

    public ID getRepresentationCode() {
        return (ID)super.getData(8);
    }

    public void setRepresentationCode(ID representationCode) {
        super.setData(8, representationCode);
    }
}

