/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.datatype.metadata;

import gov.va.med.esr.common.builder.datatype.metadata.AbstractDataTypeMetaData;
import gov.va.med.esr.common.builder.datatype.metadata.ComplexTypeMetaData;
import gov.va.med.esr.common.builder.datatype.metadata.HD;
import gov.va.med.esr.common.builder.datatype.metadata.ID;
import gov.va.med.esr.common.builder.datatype.metadata.ST;

public class CX
extends ComplexTypeMetaData {
    private static final int POSITION_IDENTIFIER = 0;
    private static final int POSITION_ID_CHECK_DIGIT = 1;
    private static final int POSITION_ID_CHECK_DIGIT_SCHEME_CODE = 2;
    private static final int POSITION_ASSIGNING_AUTHORITY = 3;
    private static final int POSITION_IDENTFIER_TYPE_CODE = 4;
    private static final int POSITION_ASSIGNING_FACILITY = 5;
    private static final int POSITION_EFFECTIVE_DATE = 6;
    private static final int POSITION_EXPIRATION_DATE = 7;
    private static final int DATA_SIZE = 8;

    protected CX(AbstractDataTypeMetaData[] data) {
        super(data);
    }

    public static CX[] create(String value, String repeatDelimiter, String delimiter, String subDelimiter) {
        if (value == null) {
            return null;
        }
        String[] components = AbstractDataTypeMetaData.splitData(value, repeatDelimiter);
        int size = components == null ? 0 : components.length;
        CX[] elements = new CX[size];
        for (int index = 0; index < size; ++index) {
            elements[index] = CX.create(components[index], delimiter, subDelimiter);
        }
        return elements;
    }

    public static CX create() {
        return new CX(new AbstractDataTypeMetaData[8]);
    }

    public static CX create(String value, String delimiter, String subDelimiter) {
        if (AbstractDataTypeMetaData.shouldDelete(value)) {
            return null;
        }
        AbstractDataTypeMetaData[] data = new AbstractDataTypeMetaData[8];
        String[] components = AbstractDataTypeMetaData.splitData(value, delimiter);
        int size = components == null ? 0 : components.length;
        data[0] = size > 0 ? ST.create(components[0]) : null;
        data[1] = size > 1 ? ST.create(components[1]) : null;
        data[2] = size > 2 ? ID.create(components[2]) : null;
        data[3] = size > 3 ? HD.create(components[3], subDelimiter) : null;
        data[4] = size > 4 ? ID.create(components[4]) : null;
        data[5] = size > 5 ? HD.create(components[5], subDelimiter) : null;
        data[6] = size > 6 ? ST.create(components[6]) : null;
        data[7] = size > 7 ? ST.create(components[7]) : null;
        return new CX(data);
    }

    public static String getDataString(CX[] data, String repeatDelimiter, String delimiter) {
        return AbstractDataTypeMetaData.formatDataString(data, repeatDelimiter, delimiter, null);
    }

    public ST getIdentifier() {
        return (ST)super.getData(0);
    }

    public void setIdentifier(ST identifier) {
        super.setData(0, identifier);
    }

    public ST getIDCheckDigit() {
        return (ST)super.getData(1);
    }

    public void setIDCheckDigit(ST idCheckDigit) {
        super.setData(1, idCheckDigit);
    }

    public ID getIDCheckDigitSchemeCode() {
        return (ID)super.getData(2);
    }

    public void setIDCheckDigitSchemeCode(ID idCheckDigitSchemeCode) {
        super.setData(2, idCheckDigitSchemeCode);
    }

    public HD getAssigningAuthority() {
        return (HD)super.getData(3);
    }

    public void setAssigningAuthority(HD assigningAuthority) {
        super.setData(3, assigningAuthority);
    }

    public ID getIdentifierTypeCode() {
        return (ID)super.getData(4);
    }

    public void setIDTypeCode(ID identifierTypeCode) {
        super.setData(4, identifierTypeCode);
    }

    public HD getAssigningFacility() {
        return (HD)super.getData(5);
    }

    public void setAssigningFacility(HD assigningFacility) {
        super.setData(5, assigningFacility);
    }

    public ST getEffectiveDate() {
        return (ST)super.getData(6);
    }

    public void setEffectiveDate(ST effectiveDate) {
        super.setData(6, effectiveDate);
    }

    public ST getExpirationDate() {
        return (ST)super.getData(7);
    }

    public void setExpirationDate(ST expirationDate) {
        super.setData(7, expirationDate);
    }

    public static String getIdentifierByIdentifierType(CX[] cxs, String identifierType) {
        String identifier = null;
        if (cxs != null) {
            for (int i = 0; i < cxs.length; ++i) {
                String currentIdentifierType;
                CX cx = cxs[i];
                String string = currentIdentifierType = cx.getIdentifierTypeCode() == null ? null : cx.getIdentifierTypeCode().getValue();
                if (!identifierType.equals(currentIdentifierType)) continue;
                identifier = cx.getIdentifier().getValue();
            }
        }
        return identifier;
    }
}

