/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.comms;

import gov.va.med.esr.common.builder.comms.AbstractLetterFormatter;
import gov.va.med.esr.common.builder.comms.EnrollTransmission;
import gov.va.med.esr.common.builder.comms.GeneralTransmission;
import gov.va.med.esr.common.builder.comms.GenerateValues;
import gov.va.med.esr.common.builder.comms.IFormatter;
import gov.va.med.esr.common.model.ee.CDDiagnosis;
import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.common.model.ee.MilitaryServiceSiteRecord;
import gov.va.med.esr.common.model.ee.ServiceConnectionAward;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.lookup.AddressType;
import gov.va.med.esr.common.model.lookup.AgentOrangeExposureLocation;
import gov.va.med.esr.common.model.lookup.ComLetterTemplateType;
import gov.va.med.esr.common.model.lookup.Diagnosis;
import gov.va.med.esr.common.model.lookup.Gender;
import gov.va.med.esr.common.model.lookup.Indicator;
import gov.va.med.esr.common.model.lookup.MeansTestStatus;
import gov.va.med.esr.common.model.lookup.RadiationExposureMethod;
import gov.va.med.esr.common.model.lookup.ServicePeriod;
import gov.va.med.esr.common.model.person.Association;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.util.LetterFormatHelper;
import gov.va.med.fw.util.DateUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;

public class EnrollRemoteFormatter
extends AbstractLetterFormatter {
    private static final String RX_COPAY_TEXT = "RX COPAY = NOT EXEMPT";
    private static final String MT_COPAY_TEXT = "MT COPAY = NOT EXEMPT";
    private static final String GMT_COPAY_TEXT = "GMT COPAY = NOT EXEMPT";
    private static final String EXTENDED_CARE_TEXT = "EXT";
    private static final String AGENT_ORANGE_TEXT = "AO";
    private static final String WOMEN_VETERANS_SERVICES_TEXT = "WVW";
    private static final String POW_REGISTRY_TEXT = "POW";
    private static final String PROJECT_112_SHAD_PARTICIPANTS_TEXT = "SHAD";
    private static final String COMBAT_VETERAN_ELIGIBILITY_TEXT = "COMB";
    private static final String FOREIGN_MEDICAL_PROGRAM_TEXT = "FMP";
    private static final String EMERGENCY_CARE_IN_NON_VA_FAC_TEXT = "EMER";
    private static final String MILL_BILL_EMERGENCY_CARE_IN_NON_VA_FAC_TEXT = "MILL";
    private static final String BENEFICIARY_TRAVEL_TEXT = "TRVL";
    private static final String DOMICILLARY_CARE_TEXT = "DOM";
    private static final String NURSING_HOME_CARE_TEXT = "NUR";
    private static final String COPAY_EXEMPT_INCOME_TEXT = "CPYI";
    private static final String COPAY_EXEMPT_ELIGIBILITY_TEXT = "CPYE";
    private static final String GMT_COPAY_TEXT_H = "GMT";
    private static final String MT_COPAY_TEXT_H = "MT";
    private static final String RX_COPAY_EXEMPT_TEXT = "RX";
    private static final String RX_COPAY_EXEMPT_SC_TEXT = "RXSC";
    private static final String IR_EXPOSURE_REGISTRY_TEXT = "IR";
    private static final String NOSE_OR_THROAT_RADIUM_TREATMENT_TEXT = "NTR";
    private static final String BLIND_VETERANS_SERVICES = "BLND";
    private static final String PERSIAN_GULF_REGISTRY_TEXT = "PGR";
    private static final String READJUSTMENT_COUNDELING_TEXT = "RADJ";
    private static IFormatter instance = new EnrollRemoteFormatter();

    public static IFormatter getInstance() {
        return instance;
    }

    private EnrollRemoteFormatter() {
    }

    private String getRxCopayText(EnrollTransmission trans) {
        if (trans != null && trans.getFormNumber() != null) {
            String formNum = trans.getFormNumber();
            if (trans.isRxCopayNonExempt() && (formNum.equals(ComLetterTemplateType.FORM_NUMBER_600C.getCode()) || formNum.equals(ComLetterTemplateType.FORM_NUMBER_630D.getCode()) || formNum.equals(ComLetterTemplateType.FORM_NUMBER_640A.getCode()) || formNum.equals(ComLetterTemplateType.FORM_NUMBER_600D.getCode()) || formNum.equals(ComLetterTemplateType.FORM_NUMBER_640B.getCode()) || formNum.equals(ComLetterTemplateType.FORM_NUMBER_640C.getCode()) || formNum.equals(ComLetterTemplateType.FORM_NUMBER_640D.getCode()) || formNum.equals(ComLetterTemplateType.FORM_NUMBER_604A.getCode()) || formNum.equals(ComLetterTemplateType.FORM_NUMBER_604B.getCode()))) {
                return RX_COPAY_TEXT;
            }
        }
        return "";
    }

    private String getMtCopayText(EnrollTransmission trans) {
        if (trans != null && trans.getFormNumber() != null) {
            String formNum = trans.getFormNumber();
            if (trans.isMTCopayRequired() && (formNum.equals(ComLetterTemplateType.FORM_NUMBER_600B.getCode()) || formNum.equals(ComLetterTemplateType.FORM_NUMBER_600C.getCode()) || formNum.equals(ComLetterTemplateType.FORM_NUMBER_600D.getCode()) || formNum.equals(ComLetterTemplateType.FORM_NUMBER_640A.getCode()) || formNum.equals(ComLetterTemplateType.FORM_NUMBER_640B.getCode()) || formNum.equals(ComLetterTemplateType.FORM_NUMBER_640D.getCode()) || formNum.equals(ComLetterTemplateType.FORM_NUMBER_604A.getCode()))) {
                return MT_COPAY_TEXT;
            }
        }
        return "";
    }

    private String getGmtCopayText(EnrollTransmission trans) {
        if (trans != null && trans.getFormNumber() != null) {
            String formNum = trans.getFormNumber();
            if (trans.isGMTCopayRequired() && (formNum.equals(ComLetterTemplateType.FORM_NUMBER_600B.getCode()) || formNum.equals(ComLetterTemplateType.FORM_NUMBER_600C.getCode()) || formNum.equals(ComLetterTemplateType.FORM_NUMBER_600D.getCode()) || formNum.equals(ComLetterTemplateType.FORM_NUMBER_640A.getCode()) || formNum.equals(ComLetterTemplateType.FORM_NUMBER_640B.getCode()) || formNum.equals(ComLetterTemplateType.FORM_NUMBER_640D.getCode()) || formNum.equals(ComLetterTemplateType.FORM_NUMBER_604A.getCode()) || formNum.equals(ComLetterTemplateType.FORM_NUMBER_604B.getCode()))) {
                return GMT_COPAY_TEXT;
            }
        }
        return "";
    }

    @Override
    protected void buildDataElementsC(StringBuffer dataElements, GeneralTransmission transmission, GenerateValues inputValues) {
        EnrollTransmission enrollTransmission = (EnrollTransmission)transmission;
        dataElements.append("* C01=").append(transmission.getIncomeYear()).append("^\n").append("* C02=").append(transmission.getCurrentRepresentative()).append("^\n").append("* C03=").append(transmission.getCurrentRepresentativeTelephone()).append("^\n").append("* C04=").append("").append("^\n").append("* C05=").append("").append("^\n").append("* C06=").append(LetterFormatHelper.toAACDate(enrollTransmission.getMTDateTimeCompleted())).append("^\n");
    }

    @Override
    protected void buildDataElementsD(StringBuffer dataElements, GeneralTransmission transmission, GenerateValues inputValues) {
        EnrollTransmission enrollTransmission = (EnrollTransmission)transmission;
        dataElements.append("* D01=").append(enrollTransmission.getPrimaryVACareFacilityNumber()).append("^\n").append("* D02=").append(transmission.getUserNumber()).append("^\n").append("* D03=").append(enrollTransmission.getEligibilityCode()).append("^\n");
    }

    @Override
    protected void buildDataElementsH(StringBuffer dataElements, GeneralTransmission transmission, GenerateValues inputValues) {
        EnrollTransmission enrollTransmission = (EnrollTransmission)transmission;
        AddressType addressType = transmission.getVeteranAddressType();
        dataElements.append("* H01=").append("").append("^\n").append("* H02=").append(this.getRxCopayText(enrollTransmission)).append("^\n").append("* H03=").append(this.getMtCopayText(enrollTransmission)).append("^\n").append("* H04=").append(this.getGmtCopayText(enrollTransmission)).append("^\n").append("* H05=").append(enrollTransmission.getMedicationCopay()).append("^\n").append("* H06=").append(transmission.getIncomeYear()).append("^\n").append("* H07=").append(enrollTransmission.getFirst90daysHospitalCopay()).append("^\n").append("* H08=").append(enrollTransmission.getAdditional90DaysHospitalCopay()).append("^\n").append("* H09=").append(enrollTransmission.getInpatientPerDiem()).append("^\n").append("* H10=").append(enrollTransmission.getSpecialCopay()).append("^\n").append("* H11=").append(enrollTransmission.getOutpatientPreventiveCopay()).append("^\n").append("* H12=").append(enrollTransmission.getGmtInpatientFirst90DayCopay()).append("^\n").append("* H13=").append(enrollTransmission.getGmtInpatientAdd90DayCopay()).append("^\n").append("* H14=").append(enrollTransmission.getGmtPerDiem()).append("^\n").append("* H15=").append(enrollTransmission.getOutpatientCopay()).append("^\n").append("* H16=").append("").append("^\n").append("* H17=").append("").append("^\n").append("* H18=").append("").append("^\n").append("* H19=").append(addressType != null ? addressType.getCode() : "").append("^\n");
    }

    @Override
    protected void buildDataElementsE(StringBuffer dataElements, GeneralTransmission transmission, GenerateValues inputValues, Association poa) {
        EnrollTransmission enrollTransmission = (EnrollTransmission)transmission;
        String barCode = poa != null ? "-@barCode@-" : this.getBarcode(inputValues);
        dataElements.append("* E01=").append(enrollTransmission.getPreferredFacilityNumber()).append("^\n").append("* E02=").append(transmission.getVisn()).append("^\n").append("* E03=").append(enrollTransmission.getCurrentEnrollmentPriorityLevel()).append("^\n").append("* E04=").append(new SimpleDateFormat("MMddyyyy").format(new Date())).append("^\n").append("* E05=").append(LetterFormatHelper.toAACDate(enrollTransmission.getEnrollmentEndDate())).append("^\n").append("* E06=").append(LetterFormatHelper.toAACDate(enrollTransmission.getEffectiveChangeDate())).append("^\n").append("* E07=").append(enrollTransmission.getEnrollmentCategoryCode()).append("^\n").append("* E08=").append(LetterFormatHelper.toAACDate(enrollTransmission.getEgtEffectiveDate())).append("^\n").append("* E09=").append(enrollTransmission.getEgtSetting()).append("^\n").append("* E10=").append(inputValues.getAacExtractId()).append("^\n").append("* E11=").append(barCode).append("^\n").append("* E19=").append(enrollTransmission.getMostRecentNonNullPriorityLevel()).append("^\n");
    }

    private boolean isVeteran(Person person) {
        if (person == null || person.isVeteran() == null) {
            return false;
        }
        return person.isVeteran();
    }

    @Override
    protected void buildDataElementsH20(StringBuffer dataElements, GeneralTransmission transmission, GenerateValues inputValues, Person person) {
        Date currentDate = DateUtils.getCurrentDate();
        Integer incomeYear = person.getLatestIncomeYear();
        IncomeTest incomeTest = person.getIncomeTest(incomeYear);
        ServiceConnectionAward serviceConnectionAward = person.getServiceConnectionAward();
        MilitaryService militaryService = person != null ? person.getMilitaryService() : null;
        dataElements.append("* H20=");
        boolean isVeteran = this.isVeteran(person);
        if (isVeteran && person.getAgentOrangeExposure() != null && person.getAgentOrangeExposure().getAgentOrangeExposureIndicator() != null && Indicator.YES.getCode().equalsIgnoreCase(person.getAgentOrangeExposure().getAgentOrangeExposureIndicator().getCode()) && person.getAgentOrangeExposure().getLocation() != null && (AgentOrangeExposureLocation.CODE_VIETNAM.getCode().equals(person.getAgentOrangeExposure().getLocation().getCode()) || AgentOrangeExposureLocation.CODE_KOREAN_DMZ.getCode().equals(person.getAgentOrangeExposure().getLocation().getCode()) || AgentOrangeExposureLocation.CODE_OTHER.getCode().equals(person.getAgentOrangeExposure().getLocation().getCode()))) {
            dataElements.append(AGENT_ORANGE_TEXT);
        }
        if (isVeteran) {
            this.checkForFieldSeparator(dataElements);
            dataElements.append(EXTENDED_CARE_TEXT);
        }
        if (isVeteran && person.getGender() != null && Gender.FEMALE.getCode().equals(person.getGender().getCode())) {
            this.checkForFieldSeparator(dataElements);
            dataElements.append(WOMEN_VETERANS_SERVICES_TEXT);
        }
        if (isVeteran && person.getPrisonerOfWar() != null && person.getPrisonerOfWar().getPowIndicator() != null && Indicator.YES.getCode().equals(person.getPrisonerOfWar().getPowIndicator().getCode())) {
            this.checkForFieldSeparator(dataElements);
            dataElements.append(POW_REGISTRY_TEXT);
        }
        if (isVeteran && person.getShad() != null && person.getShad().getShadIndicator() != null && Indicator.YES.getCode().equals(person.getShad().getShadIndicator().getCode())) {
            this.checkForFieldSeparator(dataElements);
            dataElements.append(PROJECT_112_SHAD_PARTICIPANTS_TEXT);
        }
        if (isVeteran && militaryService != null && militaryService.getCombatServices() != null && militaryService.getCombatVeteranEligibilityEndDate() != null && militaryService.getCombatVeteranEligibilityEndDate().after(currentDate)) {
            this.checkForFieldSeparator(dataElements);
            dataElements.append(COMBAT_VETERAN_ELIGIBILITY_TEXT);
        }
        if (isVeteran && serviceConnectionAward != null && serviceConnectionAward.getServiceConnectedIndicator() != null && serviceConnectionAward.getServiceConnectedIndicator().booleanValue() && person.getMonetaryBenefitAward() != null && person.getMonetaryBenefitAward().getDisabilityCompensation() != null && person.getMonetaryBenefitAward().getDisabilityCompensation().getMonetaryBenefitIndicator() != null && Indicator.YES.getCode().equals(person.getMonetaryBenefitAward().getDisabilityCompensation().getMonetaryBenefitIndicator().getCode())) {
            this.checkForFieldSeparator(dataElements);
            dataElements.append(FOREIGN_MEDICAL_PROGRAM_TEXT);
        }
        if (isVeteran && serviceConnectionAward != null && serviceConnectionAward.getServiceConnectedIndicator() != null && serviceConnectionAward.getServiceConnectedIndicator().booleanValue()) {
            this.checkForFieldSeparator(dataElements);
            dataElements.append(EMERGENCY_CARE_IN_NON_VA_FAC_TEXT);
        }
        if (isVeteran && person.isEnrolled() && serviceConnectionAward != null && serviceConnectionAward.getServiceConnectedIndicator() != null && !serviceConnectionAward.getServiceConnectedIndicator().booleanValue()) {
            this.checkForFieldSeparator(dataElements);
            dataElements.append(MILL_BILL_EMERGENCY_CARE_IN_NON_VA_FAC_TEXT);
        }
        if (serviceConnectionAward != null && serviceConnectionAward.getServiceConnectedPercentage() != null && serviceConnectionAward.getServiceConnectedPercentage() > 30 || person.getMonetaryBenefitAward() != null && person.getMonetaryBenefitAward().getVAPension() != null || incomeTest != null && incomeTest.getPensionThreshold() != null && incomeTest.getTotalIncome() != null && incomeTest.getTotalIncome().intValue() < incomeTest.getPensionThreshold().intValue()) {
            this.checkForFieldSeparator(dataElements);
            dataElements.append(BENEFICIARY_TRAVEL_TEXT);
        } else if (serviceConnectionAward != null && serviceConnectionAward.getServiceConnectedPercentage() != null && serviceConnectionAward.getServiceConnectedPercentage() < 30 && person.getMonetaryBenefitAward() != null && person.getMonetaryBenefitAward().getVAPension() != null && incomeTest != null && incomeTest.getTotalIncome() != null && incomeTest.getPensionThreshold() != null && incomeTest.getTotalIncome().intValue() > incomeTest.getPensionThreshold().intValue()) {
            this.checkForFieldSeparator(dataElements);
            dataElements.append(BENEFICIARY_TRAVEL_TEXT);
        }
        if (isVeteran && incomeTest != null && incomeTest.getTotalIncome() != null && (incomeTest.getPensionThreshold() != null && incomeTest.getTotalIncome().intValue() < incomeTest.getPensionThreshold().intValue() || incomeTest.getHardship() != null && incomeTest.getHardship().getHardshipGranted().booleanValue())) {
            this.checkForFieldSeparator(dataElements);
            dataElements.append(DOMICILLARY_CARE_TEXT);
        }
        if (isVeteran && serviceConnectionAward != null && serviceConnectionAward.getServiceConnectedPercentage() != null && (serviceConnectionAward.getServiceConnectedPercentage() > 70 || serviceConnectionAward.getServiceConnectedPercentage() > 60 && serviceConnectionAward.getUnemployable() != null && serviceConnectionAward.getUnemployable().booleanValue() || serviceConnectionAward.isPermanentAndTotal() != null && serviceConnectionAward.isPermanentAndTotal().booleanValue())) {
            this.checkForFieldSeparator(dataElements);
            dataElements.append(NURSING_HOME_CARE_TEXT);
        } else if (isVeteran && serviceConnectionAward != null && serviceConnectionAward.getServiceConnectedIndicator().booleanValue() && serviceConnectionAward.getServiceConnectedPercentage() != null && serviceConnectionAward.getServiceConnectedPercentage() < 60 && (serviceConnectionAward.getUnemployable() != null && serviceConnectionAward.getUnemployable() != false || serviceConnectionAward.isPermanentAndTotal() != null && serviceConnectionAward.isPermanentAndTotal() != false || serviceConnectionAward.getServiceConnectedPercentage() != null && serviceConnectionAward.getServiceConnectedPercentage() > 70)) {
            this.checkForFieldSeparator(dataElements);
            dataElements.append(NURSING_HOME_CARE_TEXT);
        }
        if (isVeteran && incomeTest != null && incomeTest.getStatus() != null && MeansTestStatus.MT_STATUS_MT_COPAY_EXEMPT.getCode().equals(incomeTest.getStatus().getCode())) {
            this.checkForFieldSeparator(dataElements);
            dataElements.append(COPAY_EXEMPT_INCOME_TEXT);
        }
        if (isVeteran && incomeTest != null && (incomeTest.getStatus() == null || MeansTestStatus.MT_STATUS_NO_LONGER_REQUIRED.getCode().equals(incomeTest.getStatus().getCode()))) {
            this.checkForFieldSeparator(dataElements);
            dataElements.append(COPAY_EXEMPT_ELIGIBILITY_TEXT);
        }
        if (isVeteran && incomeTest != null && incomeTest.getStatus() != null && MeansTestStatus.MT_STATUS_GMT_COPAY_REQUIRED.getCode().equals(incomeTest.getStatus().getCode())) {
            this.checkForFieldSeparator(dataElements);
            dataElements.append(GMT_COPAY_TEXT_H);
        }
        if (isVeteran && incomeTest != null && incomeTest.getStatus() != null && (MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getCode().equals(incomeTest.getStatus().getCode()) || MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION.getCode().equals(incomeTest.getStatus().getCode()))) {
            this.checkForFieldSeparator(dataElements);
            dataElements.append(MT_COPAY_TEXT_H);
        }
        if (isVeteran && incomeTest != null && incomeTest.getDeterminedStatus() != null && MeansTestStatus.MT_STATUS_EXEMPT.getCode().equals(incomeTest.getDeterminedStatus().getCode())) {
            this.checkForFieldSeparator(dataElements);
            dataElements.append(RX_COPAY_EXEMPT_TEXT);
        }
        if (isVeteran && incomeTest != null && incomeTest.getDeterminedStatus() != null && incomeTest.getDeterminedStatus().getCode().equals(MeansTestStatus.MT_STATUS_NON_EXEMPT.getCode())) {
            this.checkForFieldSeparator(dataElements);
            dataElements.append(RX_COPAY_EXEMPT_SC_TEXT);
        }
        if (isVeteran && person.getRadiationExposure() != null && person.getRadiationExposure().getRadiationExposureIndicator() != null && person.getRadiationExposure().getRadiationExposureIndicator().getCode().equals(Indicator.YES.getCode()) && person.getRadiationExposure().getExposureMethod() != null && (person.getRadiationExposure().getExposureMethod().getCode().equals(RadiationExposureMethod.CODE_NAGASAKI_HIROSHIMA.getCode()) || person.getRadiationExposure().getExposureMethod().getCode().equals(RadiationExposureMethod.CODE_ATMOSPHERIC_NUCLEAR_TESTING.getCode()) || person.getRadiationExposure().getExposureMethod().getCode().equals(RadiationExposureMethod.CODE_HN_ATMOSPHERIC_TESTING.getCode()))) {
            this.checkForFieldSeparator(dataElements);
            dataElements.append(IR_EXPOSURE_REGISTRY_TEXT);
        } else if (isVeteran && person.getRadiationExposure() != null && person.getRadiationExposure().getRadiationExposureIndicator() != null && person.getRadiationExposure().getRadiationExposureIndicator().getCode().equals(Indicator.YES.getCode()) && person.getRadiationExposure().getExposureMethod() != null && (person.getRadiationExposure().getExposureMethod().getCode().equals(RadiationExposureMethod.CODE_UNDERGROUND_NUCLEAR_TESTING.getCode()) || person.getRadiationExposure().getExposureMethod().getCode().equals(RadiationExposureMethod.CODE_EXPOSURE_AT_NUCLEAR_FACILITY.getCode()) || person.getRadiationExposure().getExposureMethod().getCode().equals(RadiationExposureMethod.CODE_OTHER.getCode()))) {
            this.checkForFieldSeparator(dataElements);
            dataElements.append(IR_EXPOSURE_REGISTRY_TEXT);
        }
        if (isVeteran && person.getNoseThroatRadium() != null) {
            this.checkForFieldSeparator(dataElements);
            dataElements.append(NOSE_OR_THROAT_RADIUM_TREATMENT_TEXT);
        }
        if (isVeteran && person.getCatastrophicDisability() != null && person.getCatastrophicDisability().isCatastrophicallyDisabled() != null && person.getCatastrophicDisability().isCatastrophicallyDisabled().booleanValue() && person.getCatastrophicDisability().getDiagnoses() != null) {
            Set diagnoses = person.getCatastrophicDisability().getDiagnoses();
            for (CDDiagnosis cdDiagnoses : diagnoses) {
                if (!cdDiagnoses.getDiagnosis().getCode().equals(Diagnosis.CODE_LEGAL_BLINDNESS.getCode())) continue;
                this.checkForFieldSeparator(dataElements);
                dataElements.append(BLIND_VETERANS_SERVICES);
                break;
            }
        }
        if (isVeteran) {
            Set militaryServiceSiteRecords;
            Set set = militaryServiceSiteRecords = militaryService != null ? militaryService.getMilitaryServiceSiteRecords() : null;
            if (militaryServiceSiteRecords != null && militaryServiceSiteRecords.size() > 0) {
                for (MilitaryServiceSiteRecord militaryServiceSiteRecord : militaryServiceSiteRecords) {
                    if (militaryServiceSiteRecord.getServicePeriod() == null || !militaryServiceSiteRecord.getServicePeriod().getCode().equals(ServicePeriod.CODE_PERSIAN_GULF_WAR.getCode())) continue;
                    this.checkForFieldSeparator(dataElements);
                    dataElements.append(PERSIAN_GULF_REGISTRY_TEXT);
                    break;
                }
            }
        }
        if (isVeteran && militaryService.getCombatServices() != null && militaryService.getCombatVeteranEligibilityEndDate() != null && militaryService.getCombatVeteranEligibilityEndDate().after(currentDate)) {
            this.checkForFieldSeparator(dataElements);
            dataElements.append(READJUSTMENT_COUNDELING_TEXT);
        }
        dataElements.append("^\n");
    }

    private void checkForFieldSeparator(StringBuffer dataElements) {
        if (dataElements.lastIndexOf("=") != dataElements.length() - 1) {
            dataElements.append("|");
        }
    }
}

