/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.comms;

import gov.va.med.esr.common.builder.comms.CmsRemoteFormatter;
import gov.va.med.esr.common.builder.comms.EnrollRemoteFormatter;
import gov.va.med.esr.common.builder.comms.GenerateValues;
import gov.va.med.esr.common.builder.comms.IFormatter;
import gov.va.med.esr.common.builder.comms.ITransmission;
import gov.va.med.esr.common.builder.comms.InsufficientDataException;
import gov.va.med.esr.common.builder.comms.SsnRemoteFormatter;
import gov.va.med.esr.common.model.comms.CommsTemplate;
import gov.va.med.esr.common.model.lookup.ComLetterType;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;
import java.util.List;

public class DocumentBuilder
extends AbstractComponent {
    public List build(Person person, GenerateValues inputValues) throws ServiceException, InsufficientDataException {
        ITransmission trans = inputValues.getTransmission();
        if (trans == null) {
            throw new ServiceException("Data Oject (ITransmission) empty in DocumentBuilder.build()!");
        }
        if (inputValues.getOrigTemplate() == null) {
            throw new ServiceException("Form Number: " + trans.getFormNumber() + " can not be found! (in DocumentBuilder.build())");
        }
        IFormatter formatter = null;
        if (inputValues.getPrintLocationCd() != null && inputValues.getPrintLocationCd().equals("01")) {
            formatter = this.getAACLetterFormatter(inputValues.getOrigTemplate());
        } else if (inputValues.getPrintLocationCd() != null && inputValues.getPrintLocationCd().equals("03")) {
            formatter = this.getCMSLetterFormatter(inputValues.getOrigTemplate());
        }
        List results = formatter != null ? formatter.format(person, inputValues) : null;
        return results;
    }

    protected IFormatter getAACLetterFormatter(CommsTemplate template) throws ServiceException {
        IFormatter formatter = null;
        ComLetterType letterType = template.getLetterType();
        if (letterType != null) {
            if (ComLetterType.CODE_ENROLLMENT.getCode().equals(letterType.getCode())) {
                formatter = EnrollRemoteFormatter.getInstance();
            } else if (ComLetterType.CODE_SSN.getCode().equals(letterType.getCode())) {
                formatter = SsnRemoteFormatter.getInstance();
            }
        }
        if (formatter == null) {
            throw new ServiceException("Document Builder encountered an unsupported letter type type: " + (Object)((Object)letterType));
        }
        return formatter;
    }

    protected IFormatter getCMSLetterFormatter(CommsTemplate template) throws ServiceException {
        IFormatter formatter = null;
        ComLetterType letterType = template.getLetterType();
        if (letterType != null && ComLetterType.CODE_IVM.getCode().equals(letterType.getCode())) {
            formatter = CmsRemoteFormatter.getInstance();
        }
        if (formatter == null) {
            throw new ServiceException("Document Builder encountered an unsupported letter type type: " + (Object)((Object)letterType));
        }
        return formatter;
    }
}

