/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess.datasync;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.infra.ImpreciseDateUtils;
import gov.va.med.esr.common.model.ee.Eligibility;
import gov.va.med.esr.common.model.ee.EligibilityVerification;
import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.ee.IncompetenceRuling;
import gov.va.med.esr.common.model.ee.IneligibilityFactor;
import gov.va.med.esr.common.model.ee.MedicaidFactor;
import gov.va.med.esr.common.model.ee.MonetaryBenefitAward;
import gov.va.med.esr.common.model.ee.ServiceConnectionAward;
import gov.va.med.esr.common.model.financials.Asset;
import gov.va.med.esr.common.model.financials.DependentFinancials;
import gov.va.med.esr.common.model.financials.Expense;
import gov.va.med.esr.common.model.financials.Financial;
import gov.va.med.esr.common.model.financials.FinancialInformation;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.financials.Hardship;
import gov.va.med.esr.common.model.financials.Income;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.financials.IncomeTestStatus;
import gov.va.med.esr.common.model.financials.PatientVisitSummary;
import gov.va.med.esr.common.model.financials.RelationFinancials;
import gov.va.med.esr.common.model.financials.SpouseFinancials;
import gov.va.med.esr.common.model.insurance.InsurancePolicy;
import gov.va.med.esr.common.model.insurance.Medicare;
import gov.va.med.esr.common.model.insurance.PrivateInsurance;
import gov.va.med.esr.common.model.lookup.EligibilityType;
import gov.va.med.esr.common.model.lookup.ExpenseType;
import gov.va.med.esr.common.model.lookup.IncomeTestSource;
import gov.va.med.esr.common.model.lookup.IncomeType;
import gov.va.med.esr.common.model.lookup.PhoneType;
import gov.va.med.esr.common.model.lookup.SSAVerificationStatus;
import gov.va.med.esr.common.model.lookup.SignatureIndicator;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.messaging.SiteIdentity;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.party.Phone;
import gov.va.med.esr.common.model.person.BirthRecord;
import gov.va.med.esr.common.model.person.DeathRecord;
import gov.va.med.esr.common.model.person.Dependent;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.model.person.SignatureImage;
import gov.va.med.esr.common.model.person.Spouse;
import gov.va.med.fw.io.RawFileDataList;
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class IVMDataSynchronizationProducer
extends AbstractComponent {
    private static final String MONETARY_BENEFIT_TYPE_TA = "TA";
    private static final String END = "END";
    private static final String EMPTY_STRING = "";
    private static final String[] EXPENSE_TYPES = new String[]{ExpenseType.EXPENSE_TYPE_ADJUSTED_MEDICAL.getCode(), ExpenseType.EXPENSE_TYPE_FUNERAL_AND_BURIAL.getCode(), ExpenseType.EXPENSE_TYPE_COLLEGE_AND_VOCATION.getCode()};
    private static final String FIELD_COUNTY = "county";
    private static final String FIELD_CHILD_RELATIONSHIP = "childRelationship";
    private static final String FIELD_INCOME_TYPE = "incomeType";
    private static final String FIELD_EXPENSE_TYPE = "expenseType";
    private static final String FIELD_ADDRESS_TYPE = "addressType";
    private static final String FIELD_DETERMINED_STATUS = "determinedStatus";
    private static final String FIELD_MEANS_TEST_STATUS = "meansTestStatus";
    private static final String FIELD_SSA_VERIFICATION_STATUS = "ssaVerificationStatus";
    private String preciseDateTimeFormat = "MMM dd, yyyy HH:mm:ss";
    private String preciseDateFormat = "MMM dd, yyyy";
    private String impreciseDateFormat = "yyyyMMdd";

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.preciseDateFormat, (String)"preciseDateFormat is required.");
        Validate.notNull((Object)this.impreciseDateFormat, (String)"impreciseDateFormat is required.");
        Validate.notNull((Object)this.preciseDateTimeFormat, (String)"preciseDateTimeFormat is required.");
    }

    public List getIVMRawData(Person person, Integer incomeYear, Set sites) {
        Validate.notNull((Object)((Object)person), (String)"A person can not be null.");
        Validate.notNull((Object)incomeYear, (String)"Income year can not be null.");
        ArrayList<List> data = new ArrayList<List>();
        data.add(this.getVeteranData(person));
        this.addPersonAddressData(data, person, incomeYear, false);
        data.add(this.getPatientData(person));
        EnrollmentDetermination ed = person.getEnrollmentDetermination();
        Eligibility primaryEligibility = ed == null ? null : ed.getPrimaryEligibility();
        Set secondaryEligibilities = ed == null ? new HashSet() : ed.getSecondaryEligibilities();
        IneligibilityFactor ieFactor = person.getIneligibilityFactor();
        data.add(this.getAwardData(person, primaryEligibility));
        data.add(this.getEligibilityData(primaryEligibility, ieFactor));
        Iterator iter = secondaryEligibilities.iterator();
        while (iter.hasNext()) {
            data.add(this.getEligibilityData((Eligibility)iter.next(), null));
        }
        EligibilityType eligType = this.getEligibilityType(primaryEligibility);
        if (EligibilityType.SERVICE_CONNECTED_50_TO_100_PERCENT.getCode().equals(this.getCode((Lookup)eligType)) || EligibilityType.SC_LESS_THAN_50_PERCENT.getCode().equals(this.getCode((Lookup)eligType))) {
            data.add(this.getServiceConnectionData(person));
            data.add(this.getMonetaryBenefitData(person.getMonetaryBenefitAward()));
        } else if (EligibilityType.AID_AND_ATTENDANCE.getCode().equals(this.getCode((Lookup)eligType)) || EligibilityType.NSC_VA_PENSION.getCode().equals(this.getCode((Lookup)eligType)) || EligibilityType.HOUSEBOUND.getCode().equals(this.getCode((Lookup)eligType))) {
            data.add(this.getMonetaryBenefitData(person.getMonetaryBenefitAward()));
        }
        data.addAll(this.getAllVAMCIdsData(person, sites));
        data.add(this.getInsuranceData(person));
        Set insurances = person.getInsurances();
        for (InsurancePolicy insurance : insurances) {
            data.add(this.getPolicyData(insurance));
            data.add(this.getInsurancePlanData(insurance));
            Address address = insurance.getAddress();
            Phone phone = insurance.getBusinessPhone();
            if (address != null) {
                address.setStartDate(new ImpreciseDate(new Date()));
                data.add(this.getAddressData(address));
                data.add(this.getContactMethodData(address));
            } else if (phone != null) {
                address = new Address();
                data.add(this.getAddressData(address));
                data.add(this.getContactMethodData(address));
            }
            this.addPhone(data, insurance.getBusinessPhone());
        }
        IncomeTest incomeTest = person.getIncomeTest(incomeYear);
        FinancialStatement fStmt = person.getFinancialStatement(incomeYear);
        if (incomeTest != null) {
            if (Boolean.TRUE.equals(incomeTest.isPrimaryIncomeTest())) {
                this.addConsentData(data, person.getSignatureImage(incomeYear));
            }
            data.add(this.getIncomeTestData(incomeTest));
            data.add(this.getIncomeTestStatusData(incomeTest.getIncomeTestStatus()));
            data.add(this.getFinancialDataForVeteran(person, incomeTest, fStmt));
            if (fStmt != null) {
                data.addAll(this.getAllIncomeData(fStmt));
                data.addAll(this.getVeteranExpenseData(fStmt));
                data.addAll(this.getAllAssetData(fStmt));
            }
            this.addFinancialDataForNonPrimary(data, person, incomeTest);
            if (fStmt != null) {
                for (SpouseFinancials spouseFinancials : fStmt.getSpouseFinancials()) {
                    data.add(this.getSpouseData(spouseFinancials));
                    if (Boolean.TRUE.equals(spouseFinancials.getLivedWithPatient())) {
                        this.addPersonAddressData(data, person, incomeYear, true);
                    }
                    data.add(this.getFinancialDataForRelation(incomeTest, spouseFinancials));
                    data.addAll(this.getAllIncomeData(spouseFinancials));
                    data.addAll(this.getAllAssetData(spouseFinancials));
                }
                for (DependentFinancials depFinancials : fStmt.getDependentFinancials()) {
                    data.add(this.getDependentData(depFinancials));
                    if (Boolean.TRUE.equals(depFinancials.getLivedWithPatient())) {
                        this.addPersonAddressData(data, person, incomeYear, true);
                    }
                    data.add(this.getFinancialDataForRelation(incomeTest, depFinancials));
                    data.addAll(this.getAllIncomeData(depFinancials));
                }
            }
        } else {
            RawFileDataList list = new RawFileDataList();
            list.add("FIN");
            list.add(incomeYear);
            list.add(EMPTY_STRING);
            data.add((List)list);
        }
        data.add(this.getEndData());
        return data;
    }

    private List getEndData() {
        RawFileDataList list = new RawFileDataList();
        list.add(END);
        list.add(EMPTY_STRING);
        return list;
    }

    private void addPersonAddressData(List data, Person person, Integer incomeYear, boolean isDependent) {
        Address tempAdd;
        Address permAddress = person.getPermanentAddress();
        if (permAddress == null) {
            permAddress = new Address();
        }
        permAddress.setStartDate(new ImpreciseDate(this.getIncomeYearStartDate(incomeYear)));
        data.add(this.getAddressData(permAddress));
        data.add(this.getContactMethodData(permAddress));
        Phone homePhone = person.getHomePhone();
        Phone bizPhone = person.getBusinessPhone();
        this.addPhone(data, homePhone);
        if (!isDependent) {
            this.addPhone(data, bizPhone);
        }
        if ((tempAdd = person.getTemporaryCorrespondenceAddress()) != null) {
            data.add(this.getAddressData(tempAdd));
            data.add(this.getContactMethodData(tempAdd));
            if (tempAdd.getPhoneNumber() != null) {
                data.add(this.getTemporaryPhoneData(tempAdd));
            }
        }
    }

    private void addPhone(List data, Phone phone) {
        if (phone != null && phone.getPhoneNumber() != null) {
            data.add(this.getPhoneData(phone));
        }
    }

    private List getVeteranExpenseData(FinancialInformation finInfo) {
        RawFileDataList expenses = new RawFileDataList();
        for (Expense exp : finInfo.getExpenses().values()) {
            String expTypeCode;
            String string = expTypeCode = exp == null ? null : this.getCode((Lookup)exp.getType());
            if (exp == null || expTypeCode == null || !StringUtils.contains((String[])EXPENSE_TYPES, (String)expTypeCode)) continue;
            expenses.add(this.getExpenseData(exp));
        }
        return expenses;
    }

    private List getAllAssetData(FinancialInformation finInfo) {
        RawFileDataList assets = new RawFileDataList();
        Iterator iter = finInfo.getAssets().values().iterator();
        while (iter.hasNext()) {
            assets.add(this.getAssetData(finInfo, (Asset)((Object)iter.next())));
        }
        return assets;
    }

    private List getAllIncomeData(FinancialInformation finInfo) {
        RawFileDataList incomes = new RawFileDataList();
        Iterator iter = finInfo.getIncome().values().iterator();
        while (iter.hasNext()) {
            incomes.add(this.getIncomeData((Income)((Object)iter.next())));
        }
        return incomes;
    }

    private List getVeteranData(Person person) {
        RawFileDataList list = new RawFileDataList();
        list.add((Object)"VET");
        list.add((Object)EMPTY_STRING);
        list.add((Object)EMPTY_STRING);
        this.addNameData((List)list, person.getLegalName());
        SSN ssn = person.getOfficialSsn();
        this.addSsnTextData((List)list, ssn);
        BirthRecord dob = person.getBirthRecord();
        DeathRecord dod = person.getDeathRecord();
        list.add((Object)this.getNotNull((Lookup)person.getGender()));
        list.add((Object)this.toPreciseDateFormat(dob == null ? null : dob.getBirthDate()));
        list.add((Object)this.toImpreciseDateFormat(dob == null ? null : dob.getBirthDate()));
        list.add((Object)this.toPreciseDateFormat(dod == null ? null : dod.getDeathDate()));
        list.add((Object)this.toImpreciseDateFormat(dod == null ? null : dod.getDeathDate()));
        this.addSsnStatusData(list, ssn);
        list.add((Object)this.getNotNull((Lookup)person.getClaimFolderLocation()));
        list.add((Object)this.getNotNull(person.getClaimFolderNumber()));
        list.add((Object)this.to2DigitCode((Lookup)(person.getEmployment() == null ? null : person.getEmployment().getEmploymentStatus())));
        return list;
    }

    private List getAddressData(Address address) {
        RawFileDataList list = new RawFileDataList();
        list.add((Object)"ADD");
        list.add((Object)this.getNotNull(address.getLine1()));
        list.add((Object)this.getNotNull(address.getLine2()));
        list.add((Object)this.getNotNull(address.getLine3()));
        list.add((Object)this.getNotNull(address.getCity()));
        list.add((Object)this.getNotNull(address.getState()));
        list.add((Object)this.getNotNull(address.getZipCode()));
        list.addValueToBeTransformed(FIELD_COUNTY, (Object)address);
        if (address.getType() == null || address.getType().getCode() == null) {
            list.add((Object)EMPTY_STRING);
        } else {
            list.addValueToBeTransformed(FIELD_ADDRESS_TYPE, (Object)address.getType().getCode());
        }
        list.add((Object)this.toPreciseDateTimeFormat(address.getModifiedOn()));
        list.add((Object)this.toPreciseDateFormat(address.getStartDate()));
        list.add((Object)this.toImpreciseDateFormat(address.getStartDate()));
        list.add((Object)this.toPreciseDateFormat(address.getEndDate()));
        list.add((Object)this.toImpreciseDateFormat(address.getEndDate()));
        return list;
    }

    private List getContactMethodData(Address address) {
        if (address == null) {
            address = new Address();
        }
        RawFileDataList list = new RawFileDataList();
        list.add("CME");
        list.add("08");
        list.add(this.toPreciseDateTimeFormat(address.getModifiedOn()));
        return list;
    }

    private List getPhoneData(Phone phone) {
        RawFileDataList list = new RawFileDataList();
        list.add("TEL");
        list.add(this.to2DigitCode((Lookup)phone.getType()));
        list.add(this.getNotNull(phone.getPhoneNumber()));
        list.add(this.toPreciseDateTimeFormat(phone.getModifiedOn()));
        return list;
    }

    private List getTemporaryPhoneData(Address address) {
        RawFileDataList list = new RawFileDataList();
        list.add("TEL");
        list.add(this.to2DigitCode(PhoneType.CODE_HOME));
        list.add(this.getNotNull(address.getPhoneNumber()));
        list.add(this.toPreciseDateTimeFormat(address.getModifiedOn()));
        return list;
    }

    private List getPatientData(Person person) {
        RawFileDataList list = new RawFileDataList();
        list.add("PAT");
        String vpid = this.getNotNull(person.getVPIDEntityKey().getShortVPID());
        list.add(vpid.length() >= 10 ? vpid.substring(0, 10) : vpid);
        list.add(this.getIcnCheckSum(vpid));
        return list;
    }

    private String getIcnCheckSum(String vpid) {
        int indexOfV = vpid.indexOf("V");
        String icnCheckSum = EMPTY_STRING;
        if (indexOfV > -1) {
            icnCheckSum = vpid.length() >= indexOfV + 7 ? vpid.substring(indexOfV + 1, indexOfV + 7) : vpid.substring(indexOfV);
        }
        return icnCheckSum;
    }

    private List getAwardData(Person person, Eligibility primaryEligibility) {
        IncompetenceRuling ruling = person.getIncompetenceRuling();
        ServiceConnectionAward scAward = person.getServiceConnectionAward();
        EligibilityVerification ev = person.getEligibilityVerification();
        Date reportDate = primaryEligibility == null ? null : primaryEligibility.getModifiedOn();
        RawFileDataList list = new RawFileDataList();
        list.add("AWD");
        list.add(this.getNotNull((Lookup)(ev == null ? null : ev.getEligibilityStatus())));
        list.add(this.toPreciseDateFormat(reportDate));
        list.add(this.getIndicator(ruling == null ? null : ruling.getIncompetent()));
        list.add(this.getIndicator(scAward == null ? null : scAward.getServiceConnectedIndicator()));
        return list;
    }

    private List getEligibilityData(Eligibility eligibility, IneligibilityFactor ieFactor) {
        RawFileDataList list = new RawFileDataList();
        list.add("ELI");
        list.add(this.to2DigitCode((Lookup)this.getEligibilityType(eligibility)));
        list.add(this.toPreciseDateTimeFormat(eligibility == null ? null : eligibility.getModifiedOn()));
        list.add(this.getNotNull(eligibility == null ? null : eligibility.getIndicator()));
        Date ineligibleDate = ieFactor == null ? null : ieFactor.getIneligibleDate();
        list.add(this.toPreciseDateFormat(ineligibleDate));
        list.add(this.toImpreciseDateFormat(ineligibleDate));
        list.add(this.getNotNull(ieFactor == null ? null : ieFactor.getReason()));
        return list;
    }

    private EligibilityType getEligibilityType(Eligibility eligibility) {
        return eligibility == null ? null : eligibility.getType();
    }

    private List getServiceConnectionData(Person person) {
        ServiceConnectionAward scAward = person.getServiceConnectionAward();
        RawFileDataList list = new RawFileDataList();
        list.add("SCN");
        list.add(this.getNotNull(scAward == null ? null : scAward.getServiceConnectedPercentage()));
        list.add(this.toPreciseDateTimeFormat(scAward == null ? null : scAward.getModifiedOn()));
        return list;
    }

    private List getMonetaryBenefitData(MonetaryBenefitAward award) {
        RawFileDataList list = new RawFileDataList();
        list.add("MON");
        list.add(this.toPreciseDateTimeFormat(award == null ? null : award.getModifiedOn()));
        list.add(MONETARY_BENEFIT_TYPE_TA);
        list.add(this.getNotNull(award == null ? null : award.getCheckAmount()));
        return list;
    }

    private List getAllVAMCIdsData(Person person, Set sites) {
        RawFileDataList vamcList = new RawFileDataList();
        Iterator iter = sites.iterator();
        while (iter.hasNext()) {
            vamcList.add(this.getVAMCIdData(person, (SiteIdentity)((Object)iter.next())));
        }
        return vamcList;
    }

    private List getVAMCIdData(Person person, SiteIdentity siteIdentity) {
        RawFileDataList list = new RawFileDataList();
        list.add("VAM");
        VAFacility facility = siteIdentity.getVaFacility();
        list.add(this.getNotNull(facility.getStationNumber()));
        list.add(this.getNotNull(siteIdentity.getDfn()));
        PatientVisitSummary summary = PatientVisitSummary.getLastestVisitedSummary(person.getPatientVisitSummaries(facility));
        list.add(this.toPreciseDateFormat(summary == null ? null : summary.getLastVisitDate()));
        list.add(this.toPreciseDateTimeFormat(summary == null ? null : summary.getModifiedOn()));
        return list;
    }

    private List getInsuranceData(Person person) {
        RawFileDataList list = new RawFileDataList();
        list.add("INS");
        InsurancePolicy insurance = this.getActiveInsurance(person.getInsurances());
        list.add(this.getIndicator(insurance != null));
        MedicaidFactor medicaidFactor = person.getMedicaidFactor();
        list.add(this.getIndicator(medicaidFactor == null ? null : medicaidFactor.getEligibleForMedicaid()));
        Date reportDate = insurance != null ? insurance.getModifiedOn() : (medicaidFactor != null ? medicaidFactor.getModifiedOn() : new Date());
        list.add(this.toPreciseDateTimeFormat(reportDate));
        return list;
    }

    private InsurancePolicy getActiveInsurance(Set insurances) {
        if (insurances == null || insurances.size() == 0) {
            return null;
        }
        for (InsurancePolicy insurance : insurances) {
            if (insurance instanceof Medicare) {
                return insurance;
            }
            if (!(insurance instanceof PrivateInsurance)) continue;
            PrivateInsurance pi = (PrivateInsurance)insurance;
            Date effectiveDate = ImpreciseDateUtils.getDateWithDefault(pi.getPolicyEffectiveDate());
            Date expiryDate = ImpreciseDateUtils.getDateWithDefault(pi.getPolicyExpirationDate());
            Date now = new Date();
            if (effectiveDate == null || effectiveDate.compareTo(now) > 0 || expiryDate == null || expiryDate.compareTo(now) <= 0) continue;
            return insurance;
        }
        return null;
    }

    private List getPolicyData(InsurancePolicy insurance) {
        RawFileDataList list = new RawFileDataList();
        list.add("POL");
        ImpreciseDate effDate = null;
        ImpreciseDate expDate = null;
        if (insurance instanceof PrivateInsurance) {
            PrivateInsurance pi = (PrivateInsurance)insurance;
            effDate = pi == null ? null : pi.getPolicyEffectiveDate();
            expDate = pi == null ? null : pi.getPolicyExpirationDate();
        } else if (insurance instanceof Medicare) {
            Medicare me = (Medicare)insurance;
            expDate = null;
            effDate = null;
            if (me != null) {
                if (me.getPartAEffectiveDate() != null) {
                    effDate = me.getPartAEffectiveDate();
                } else if (me.getPartBEffectiveDate() != null) {
                    effDate = me.getPartBEffectiveDate();
                }
            }
        }
        list.add(this.getNotNull(insurance.getCompanyName()));
        list.add(this.toPreciseDateTimeFormat(insurance.getModifiedOn()));
        list.add(this.toPreciseDateFormat(effDate));
        list.add(this.toImpreciseDateFormat(effDate));
        list.add(this.toPreciseDateFormat(expDate));
        list.add(this.toImpreciseDateFormat(expDate));
        return list;
    }

    private List getInsurancePlanData(InsurancePolicy insurance) {
        RawFileDataList list = new RawFileDataList();
        list.add("INP");
        list.add(this.getNotNull(insurance.getGroupName()));
        list.add(this.getNotNull(insurance.getGroupNumber()));
        list.add(this.toPreciseDateTimeFormat(insurance.getModifiedOn()));
        return list;
    }

    private void addConsentData(List data, SignatureImage sigImage) {
        if (sigImage == null) {
            return;
        }
        RawFileDataList list = new RawFileDataList();
        list.add("CON");
        list.add(this.getNotNull((Lookup)sigImage.getSiteSubmittingImage()));
        SignatureIndicator indicator = sigImage.getSignatureIndicator();
        String indicatorVal = this.getNotNull((Lookup)indicator);
        String translation = indicatorVal.equals("0") ? indicatorVal : this.to2DigitCode((Lookup)indicator);
        list.add(translation);
        list.add(this.getNotNull(sigImage.getImageIdNumber()));
        list.add(this.toPreciseDateTimeFormat(sigImage.getModifiedOn()));
        list.add(this.toPreciseDateFormat(sigImage.getDateIndex()));
        data.add(list);
    }

    private List getIncomeTestData(IncomeTest incomeTest) {
        RawFileDataList list = new RawFileDataList();
        list.add("INT");
        list.add(this.toPreciseDateFormat(incomeTest.getEffectiveDate()));
        list.add(this.toPreciseDateTimeFormat(incomeTest.getCompletedDate()));
        IncomeTestSource source = incomeTest.getSource();
        list.add(this.to2DigitCode((Lookup)source));
        list.add(this.getNotNull(incomeTest.getTotalNumberOfDependents()));
        list.add(this.to2DigitCode((Lookup)incomeTest.getType()));
        list.add(this.getNotNull(incomeTest.getThresholdA()));
        Hardship hardship = incomeTest.getHardship();
        if (hardship == null) {
            hardship = new Hardship();
        }
        list.add(this.toPreciseDateFormat(hardship.getReviewDate()));
        list.add(this.getNotNull(incomeTest.getNetWorth()));
        list.add(this.toPreciseDateFormat(hardship.getEffectiveDate()));
        list.add(this.getNotNull(this.getSiteConductingTest(incomeTest)));
        list.add(this.getNotNull((Lookup)hardship.getSiteGrantingHardship()));
        list.add(this.toPreciseDateTimeFormat(incomeTest.getLastEditedDate()));
        list.add(this.getNotNull(incomeTest.getDeductibleExpenses()));
        return list;
    }

    private List getIncomeTestStatusData(IncomeTestStatus status) {
        if (status == null) {
            status = new IncomeTestStatus();
        }
        RawFileDataList list = new RawFileDataList();
        list.add((Object)"IST");
        list.addValueToBeTransformed(FIELD_DETERMINED_STATUS, (Object)this.getCode((Lookup)status.getDeterminedStatus()));
        list.add((Object)this.to2DigitCode((Lookup)status.getType()));
        list.addValueToBeTransformed(FIELD_MEANS_TEST_STATUS, (Object)this.getCode((Lookup)status.getStatus()));
        list.add((Object)this.toPreciseDateTimeFormat(status.getModifiedOn()));
        return list;
    }

    private List getFinancialDataForVeteran(Person person, IncomeTest incomeTest, FinancialStatement fStmt) {
        String farmRanchIncomeInd = this.exists(Income.getIncomeOfType(fStmt.getIncome().values(), IncomeType.INCOME_TYPE_FARM_RANCH_PROPERTY_OR_BUSINESS_INCOME));
        String testSiteCode = this.getSiteConductingTest(incomeTest);
        PatientVisitSummary summary = person.getPatientVisitSummary(incomeTest.getIncomeYear(), incomeTest.getSiteConductingTest());
        Boolean marriedLastCalendarYear = fStmt == null ? null : fStmt.getMarriedLastCalendarYear();
        Date modifiedOn = summary == null ? incomeTest.getModifiedOn() : summary.getModifiedOn();
        return this.getFinancialsData(incomeTest.getIncomeYear(), modifiedOn, testSiteCode, null, marriedLastCalendarYear, farmRanchIncomeInd, summary);
    }

    private void addFinancialDataForNonPrimary(List list, Person person, IncomeTest incomeTest) {
        Set summaries = person.getPatientVisitSummaries(incomeTest.getIncomeYear());
        String testSiteCode = this.getSiteConductingTest(incomeTest);
        for (PatientVisitSummary summary : summaries) {
            VAFacility facilityVisited = summary.getFacilityVisited();
            String facilityVisitedCode = facilityVisited == null ? EMPTY_STRING : facilityVisited.getCode();
            if (facilityVisitedCode.equals(testSiteCode)) continue;
            list.add(this.getFinancialsData(incomeTest.getIncomeYear(), summary.getModifiedOn(), facilityVisitedCode, null, null, null, summary));
        }
    }

    private List getFinancialDataForRelation(IncomeTest incomeTest, RelationFinancials relationFin) {
        String site = this.getSiteConductingTest(incomeTest);
        return this.getFinancialsData(incomeTest.getIncomeYear(), relationFin.getModifiedOn(), site, relationFin.getLivedWithPatient(), null, null, null);
    }

    private List getFinancialsData(Integer incomeYear, Date reportDate, String siteCode, Boolean livedWithPatient, Boolean marriedLastYear, String farmRanchIncomeInd, PatientVisitSummary visitSummary) {
        RawFileDataList list = new RawFileDataList();
        list.add("FIN");
        list.add(this.getNotNull(incomeYear));
        list.add(this.toPreciseDateTimeFormat(reportDate));
        list.add(this.getNotNull(siteCode));
        list.add(this.getIndicator(livedWithPatient));
        list.add(this.getIndicator(marriedLastYear));
        list.add(this.getNotNull(farmRanchIncomeInd));
        list.add(this.getNotNull(visitSummary == null ? null : visitSummary.getInpatientDays()));
        list.add(this.getNotNull(visitSummary == null ? null : visitSummary.getOutpatientDays()));
        list.add(this.toPreciseDateFormat(visitSummary == null ? null : visitSummary.getLastVisitDate()));
        return list;
    }

    private List getIncomeData(Income income) {
        RawFileDataList list = new RawFileDataList();
        list.add((Object)"INC");
        this.addFinancialData(list, income, FIELD_INCOME_TYPE, income == null ? null : this.getCode((Lookup)income.getType()));
        return list;
    }

    private List getExpenseData(Expense expense) {
        RawFileDataList list = new RawFileDataList();
        list.add((Object)"EXP");
        this.addFinancialData(list, expense, FIELD_EXPENSE_TYPE, expense == null ? null : this.getCode((Lookup)expense.getType()));
        return list;
    }

    private List getAssetData(FinancialInformation finInfo, Asset asset) {
        RawFileDataList list = new RawFileDataList();
        list.add((Object)"AST");
        this.addFinancialData(list, asset, null, asset == null ? null : this.getCode((Lookup)asset.getType()));
        list.add((Object)this.getNotNull(finInfo.getDebt()));
        return list;
    }

    private void addFinancialData(RawFileDataList list, Financial financial, String typeName, String typeCode) {
        list.add((Object)this.toPreciseDateTimeFormat(financial == null ? null : financial.getModifiedOn()));
        if (typeName == null) {
            list.add((Object)this.getNotNull(typeCode));
        } else {
            list.addValueToBeTransformed(typeName, (Object)typeCode);
        }
        list.add((Object)this.getNotNull(financial == null ? null : financial.getAmount()));
    }

    private List getSpouseData(SpouseFinancials spouseFinancials) {
        RawFileDataList list = new RawFileDataList();
        list.add((Object)"SPO");
        Spouse spouse = spouseFinancials == null ? new Spouse() : spouseFinancials.getReportedOn();
        Name name = spouse.getName();
        this.addNameData((List)list, name);
        SSN officialSsn = spouse.getOfficialSsn();
        this.addSsnTextData((List)list, officialSsn);
        this.addSsnTextData((List)list, spouse.getPseudoSsn());
        list.add((Object)this.getNotNull((Lookup)spouse.getGender()));
        list.add((Object)this.toPreciseDateFormat(spouse.getDob()));
        list.add((Object)this.toImpreciseDateFormat(spouse.getDob()));
        list.add((Object)this.toPreciseDateFormat(spouse.getMarriageDate()));
        list.add((Object)this.toImpreciseDateFormat(spouse.getMarriageDate()));
        this.addSsnStatusData(list, officialSsn);
        list.add((Object)this.to2DigitCode((Lookup)(spouse.getEmployment() == null ? null : spouse.getEmployment().getEmploymentStatus())));
        return list;
    }

    private List getDependentData(DependentFinancials depFinancials) {
        RawFileDataList list = new RawFileDataList();
        list.add((Object)"DEP");
        Dependent dep = depFinancials == null ? new Dependent() : depFinancials.getReportedOn();
        Name name = dep.getName();
        this.addNameData((List)list, name);
        list.addValueToBeTransformed(FIELD_CHILD_RELATIONSHIP, (Object)dep.getRelationship());
        list.add((Object)this.getNotNull((Lookup)dep.getGender()));
        this.addSsnTextData((List)list, dep.getOfficialSsn());
        list.add((Object)this.toPreciseDateFormat(dep.getDob()));
        list.add((Object)this.toImpreciseDateFormat(dep.getDob()));
        list.add((Object)this.toPreciseDateFormat(dep.getStartDate()));
        list.add((Object)this.toImpreciseDateFormat(dep.getStartDate()));
        list.add((Object)this.getIndicator(depFinancials.getIncapableOfSelfSupport()));
        return list;
    }

    private void addNameData(List list, Name name) {
        list.add(this.getNotNull(name == null ? null : name.getFamilyName()));
        list.add(this.getNotNull(name == null ? null : name.getGivenName()));
        list.add(this.getNotNull(name == null ? null : name.getMiddleName()));
        list.add(this.getNotNull(name == null ? null : name.getPrefix()));
        list.add(this.getNotNull(name == null ? null : name.getSuffix()));
    }

    private void addSsnTextData(List list, SSN ssn) {
        String ssnText = ssn == null ? null : ssn.getSsnText();
        ssnText = ssnText == null ? EMPTY_STRING : ssnText.replaceAll("-", EMPTY_STRING);
        list.add(ssnText);
    }

    private void addSsnStatusData(RawFileDataList list, SSN ssn) {
        SSAVerificationStatus ssaVerStatus = ssn == null ? null : ssn.getSsaVerificationStatus();
        list.addValueToBeTransformed(FIELD_SSA_VERIFICATION_STATUS, (Object)(ssaVerStatus == null ? null : ssaVerStatus.getCode()));
        list.add((Object)this.toPreciseDateFormat(ssn == null ? null : ssn.getSsaVerificationDate()));
        list.add((Object)this.toImpreciseDateFormat(ssn == null ? null : ssn.getSsaVerificationDate()));
    }

    private String toPreciseDateTimeFormat(Date date) {
        if (date != null) {
            SimpleDateFormat format = new SimpleDateFormat(this.preciseDateTimeFormat);
            return format.format(date);
        }
        return EMPTY_STRING;
    }

    private String toPreciseDateFormat(Date date) {
        if (date != null) {
            SimpleDateFormat format = new SimpleDateFormat(this.preciseDateFormat);
            return format.format(date);
        }
        return EMPTY_STRING;
    }

    private String toImpreciseDateFormat(Date date) {
        if (date != null) {
            SimpleDateFormat format = new SimpleDateFormat(this.impreciseDateFormat);
            return format.format(date);
        }
        return EMPTY_STRING;
    }

    private String toPreciseDateFormat(ImpreciseDate date) {
        return this.toPreciseDateFormat(ImpreciseDateUtils.getDateWithDefault(date));
    }

    private String toImpreciseDateFormat(ImpreciseDate date) {
        return this.toImpreciseDateFormat(ImpreciseDateUtils.getDateWithDefault(date));
    }

    private String getIndicator(Boolean ind) {
        return ind == null ? EMPTY_STRING : (Boolean.TRUE.equals(ind) ? "Y" : "N");
    }

    private String getIndicator(boolean ind) {
        return ind ? "Y" : "N";
    }

    private String exists(Financial financial) {
        return financial == null || financial.getAmount() == null || financial.getAmount().intValue() == 0 ? "N" : "Y";
    }

    private String getNotNull(String str) {
        return str == null ? EMPTY_STRING : str;
    }

    private String getNotNull(Integer numbr) {
        return numbr == null ? EMPTY_STRING : numbr.toString();
    }

    private String getNotNull(BigDecimal numbr) {
        return numbr == null ? EMPTY_STRING : numbr.toString();
    }

    private String getNotNull(Financial financial) {
        return financial == null ? EMPTY_STRING : this.getNotNull(financial.getAmount());
    }

    private String getNotNull(Lookup lookup) {
        String code = lookup == null ? EMPTY_STRING : lookup.getCode();
        return code == null ? EMPTY_STRING : code;
    }

    private String getNotNull(Date date) {
        return date == null ? EMPTY_STRING : date.toString();
    }

    private String getNotNull(ImpreciseDate date) {
        return date == null ? EMPTY_STRING : date.toStandardFormat();
    }

    private String to2DigitCode(Lookup lookup) {
        return this.leftPad(lookup, 2, '0');
    }

    private String to2DigitCode(AbstractCode lookup) {
        return this.leftPad(lookup, 2, '0');
    }

    private String leftPad(Lookup lookup, int size, char charToPad) {
        String result = StringUtils.leftPad((String)this.getCode(lookup), (int)size, (char)charToPad);
        return result == null ? EMPTY_STRING : result;
    }

    private String leftPad(AbstractCode code, int size, char charToPad) {
        String result = StringUtils.leftPad((String)this.getCode(code), (int)size, (char)charToPad);
        return result == null ? EMPTY_STRING : result;
    }

    private String getCode(Lookup lookup) {
        return lookup == null ? null : lookup.getCode();
    }

    private String getCode(AbstractCode code) {
        return code != null ? code.getCode() : null;
    }

    private String getSiteConductingTest(IncomeTest test) {
        String source = this.getCode((Lookup)test.getSource());
        String siteCondTestCode = this.getCode((Lookup)test.getSiteConductingTest());
        if (siteCondTestCode == null && IncomeTestSource.CODE_HEC.getCode().equals(source)) {
            return VAFacility.CODE_HEC.getCode();
        }
        return siteCondTestCode;
    }

    private Date getIncomeYearStartDate(Integer incomeYear) {
        Calendar cal = Calendar.getInstance();
        cal.set(incomeYear, 0, 1, 0, 0, 0);
        return cal.getTime();
    }

    public String getImpreciseDateFormat() {
        return this.impreciseDateFormat;
    }

    public void setImpreciseDateFormat(String impreciseDateFormat) {
        this.impreciseDateFormat = impreciseDateFormat;
    }

    public String getPreciseDateFormat() {
        return this.preciseDateFormat;
    }

    public void setPreciseDateFormat(String preciseDateFormat) {
        this.preciseDateFormat = preciseDateFormat;
    }

    public String getPreciseDateTimeFormat() {
        return this.preciseDateTimeFormat;
    }

    public void setPreciseDateTimeFormat(String preciseDateTimeFormat) {
        this.preciseDateTimeFormat = preciseDateTimeFormat;
    }
}

