/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess.datasync;

import com.infomata.data.DataRow;
import gov.va.med.esr.common.batchprocess.DateFieldTransformer;
import gov.va.med.esr.common.batchprocess.datasync.HECLegacyDataSynchronizationProducerProcess;
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.ee.RatedDisability;
import gov.va.med.esr.common.model.lookup.AgentOrangeExposureLocation;
import gov.va.med.esr.common.model.lookup.DiagnosticExtremity;
import gov.va.med.esr.common.model.lookup.Disability;
import gov.va.med.esr.common.model.lookup.EligibilityStatus;
import gov.va.med.esr.common.model.lookup.EligibilityType;
import gov.va.med.esr.common.model.lookup.EmergencyResponse;
import gov.va.med.esr.common.model.lookup.RadiationExposureMethod;
import gov.va.med.fw.io.AbstractRawFileDataContainer;
import gov.va.med.fw.io.ClassMapping;
import gov.va.med.fw.io.RawFileDataContainerUtils;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.util.StringUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.lang.builder.ToStringBuilder;

public class HECLegacyEligibilityFileData
extends AbstractRawFileDataContainer {
    private static final long serialVersionUID = 25696906143571028L;
    private EligibilityStatus eligibilityStatus;
    private ImpreciseDate eligibilityStatusDate;
    private String eligibilityVerificationMethod;
    private EligibilityType eligibilityCode;
    private Set otherEligibilityCodes = new HashSet();
    private String serviceConnected;
    private Integer serviceConnectedPercentage;
    private String unemployable;
    private String pAndT;
    private ImpreciseDate pAndTEffectiveDate;
    private Set ratedDisabilities = new HashSet();
    private ImpreciseDate combinedSCPercentEffectiveDate;
    private String receivingVAPension;
    private String receivingAABenefits;
    private String receivingHouseholdBenefits;
    private String eligibleForMedicaid;
    private String dischargeDueToDisability;
    private String militaryDisabilityRetirement;
    private String receivingVADisability;
    private BigDecimal totalAnnualVACheckAmount;
    private String powStatusIndicated;
    private String ratedIncompetent;
    private ImpreciseDate ineligibleDate;
    private String ineligibleReason;
    private String ineligibleVaroDecision;
    private String exposedToAgentOrange;
    private AgentOrangeExposureLocation agentOrangeExposureLocation;
    private String radiationExposureIndicator;
    private RadiationExposureMethod radiationExposureMethod;
    private String environmentalContaminants;
    private String veteranIndicator;
    private EmergencyResponse emergencyResponse;
    private static final int VERIFY_METHOD_MAX_LENGTH = 50;

    protected void buildToString(ToStringBuilder builder) {
    }

    public String getEligibilityVerificationMethod() {
        return this.eligibilityVerificationMethod;
    }

    public void setEligibilityVerificationMethod(String eligibilityVerificationMethod) {
        this.eligibilityVerificationMethod = eligibilityVerificationMethod;
    }

    public String getDischargeDueToDisability() {
        return this.dischargeDueToDisability;
    }

    public void setDischargeDueToDisability(String dischargeDueToDisability) {
        this.dischargeDueToDisability = dischargeDueToDisability;
    }

    public String getEligibleForMedicaid() {
        return this.eligibleForMedicaid;
    }

    public void setEligibleForMedicaid(String eligibleForMedicaid) {
        this.eligibleForMedicaid = eligibleForMedicaid;
    }

    public String getEnvironmentalContaminants() {
        return this.environmentalContaminants;
    }

    public void setEnvironmentalContaminants(String environmentalContaminants) {
        this.environmentalContaminants = environmentalContaminants;
    }

    public String getExposedToAgentOrange() {
        return this.exposedToAgentOrange;
    }

    public void setExposedToAgentOrange(String exposedToAgentOrange) {
        this.exposedToAgentOrange = exposedToAgentOrange;
    }

    public String getIneligibleReason() {
        return this.ineligibleReason;
    }

    public void setIneligibleReason(String ineligibleReason) {
        this.ineligibleReason = ineligibleReason;
    }

    public String getIneligibleVaroDecision() {
        return this.ineligibleVaroDecision;
    }

    public void setIneligibleVaroDecision(String ineligibleVaroDecision) {
        this.ineligibleVaroDecision = ineligibleVaroDecision;
    }

    public String getMilitaryDisabilityRetirement() {
        return this.militaryDisabilityRetirement;
    }

    public void setMilitaryDisabilityRetirement(String militaryDisabilityRetirement) {
        this.militaryDisabilityRetirement = militaryDisabilityRetirement;
    }

    public String getPAndT() {
        return this.pAndT;
    }

    public void setPAndT(String andT) {
        this.pAndT = andT;
    }

    public String getPowStatusIndicated() {
        return this.powStatusIndicated;
    }

    public void setPowStatusIndicated(String powStatusIndicated) {
        this.powStatusIndicated = powStatusIndicated;
    }

    public String getRadiationExposureIndicator() {
        return this.radiationExposureIndicator;
    }

    public void setRadiationExposureIndicator(String radiationExposureIndicator) {
        this.radiationExposureIndicator = radiationExposureIndicator;
    }

    public String getRatedIncompetent() {
        return this.ratedIncompetent;
    }

    public void setRatedIncompetent(String ratedIncompetent) {
        this.ratedIncompetent = ratedIncompetent;
    }

    public String getReceivingAABenefits() {
        return this.receivingAABenefits;
    }

    public void setReceivingAABenefits(String receivingAABenefits) {
        this.receivingAABenefits = receivingAABenefits;
    }

    public String getReceivingHouseholdBenefits() {
        return this.receivingHouseholdBenefits;
    }

    public void setReceivingHouseholdBenefits(String receivingHouseholdBenefits) {
        this.receivingHouseholdBenefits = receivingHouseholdBenefits;
    }

    public String getReceivingVADisability() {
        return this.receivingVADisability;
    }

    public void setReceivingVADisability(String receivingVADisability) {
        this.receivingVADisability = receivingVADisability;
    }

    public String getReceivingVAPension() {
        return this.receivingVAPension;
    }

    public void setReceivingVAPension(String receivingVAPension) {
        this.receivingVAPension = receivingVAPension;
    }

    public String getServiceConnected() {
        return this.serviceConnected;
    }

    public void setServiceConnected(String serviceConnected) {
        this.serviceConnected = serviceConnected;
    }

    public String getUnemployable() {
        return this.unemployable;
    }

    public void setUnemployable(String unemployable) {
        this.unemployable = unemployable;
    }

    public ImpreciseDate getCombinedSCPercentEffectiveDate() {
        return this.combinedSCPercentEffectiveDate;
    }

    public void setCombinedSCPercentEffectiveDate(ImpreciseDate combinedSCPercentEffectiveDate) {
        this.combinedSCPercentEffectiveDate = combinedSCPercentEffectiveDate;
    }

    public ImpreciseDate getEligibilityStatusDate() {
        return this.eligibilityStatusDate;
    }

    public void setEligibilityStatusDate(ImpreciseDate eligibilityStatusDate) {
        this.eligibilityStatusDate = eligibilityStatusDate;
    }

    public ImpreciseDate getIneligibleDate() {
        return this.ineligibleDate;
    }

    public void setIneligibleDate(ImpreciseDate ineligibleDate) {
        this.ineligibleDate = ineligibleDate;
    }

    public ImpreciseDate getPAndTEffectiveDate() {
        return this.pAndTEffectiveDate;
    }

    public void setPAndTEffectiveDate(ImpreciseDate andTEffectiveDate) {
        this.pAndTEffectiveDate = andTEffectiveDate;
    }

    private void parseRatedDisabilities(String ratedDisabilitiesString) throws ParseException {
        if (StringUtils.isBlank((String)ratedDisabilitiesString)) {
            return;
        }
        Object[] groupedData = RawFileDataContainerUtils.parseMultipleValues((String)ratedDisabilitiesString, (String)"|", (String)"~", (int)6);
        String[] data = null;
        int j = 0;
        try {
            for (int i = 0; i < groupedData.length; ++i) {
                data = (String[])groupedData[i];
                RatedDisability rd = new RatedDisability();
                j = 0;
                rd.setDisability((Disability)RawFileDataContainerUtils.convertToLookup(Disability.class, (String)data[j++]));
                rd.setPercentage(Integer.valueOf(data[j++]));
                rd.setServiceConnected(Boolean.valueOf(data[j++]));
                rd.setDiagnosticExtremity((DiagnosticExtremity)RawFileDataContainerUtils.convertToLookup(DiagnosticExtremity.class, (String)data[j++]));
                RawFileDataContainerUtils.setConvertedField((Object)((Object)rd), (String)"originalEffectiveRatingDate", (String)data[j++]);
                RawFileDataContainerUtils.setConvertedField((Object)((Object)rd), (String)"ratingDate", (String)data[j++]);
                this.ratedDisabilities.add(rd);
            }
        }
        catch (Exception e) {
            ParseException e2 = new ParseException("Unable to parse text: " + data[j - 1], j - 1);
            e2.initCause(e);
            throw e2;
        }
    }

    private String formatRatedDisabilities() throws Exception {
        StringBuffer buf = new StringBuffer();
        Iterator itr = this.ratedDisabilities != null ? this.ratedDisabilities.iterator() : null;
        RatedDisability rd = null;
        DateFieldTransformer tran = new DateFieldTransformer();
        tran.setDateFormat("yyyyMMddHHmmssZ");
        while (itr != null && itr.hasNext()) {
            rd = (RatedDisability)((Object)itr.next());
            buf.append(RawFileDataContainerUtils.formatLookup((Lookup)rd.getDisability())).append("~");
            buf.append(rd.getPercentage() != null ? rd.getPercentage().toString() : "").append("~");
            buf.append(HECLegacyDataSynchronizationProducerProcess.TRUE).append("~");
            buf.append(RawFileDataContainerUtils.formatLookup((Lookup)rd.getDiagnosticExtremity())).append("~");
            buf.append(rd.getOriginalEffectiveRatingDate() != null ? tran.transformData("", rd.getOriginalEffectiveRatingDate()) : "").append("~");
            buf.append(rd.getRatingDate() != null ? tran.transformData("", rd.getRatingDate()) : "");
            if (!itr.hasNext()) continue;
            buf.append("|");
        }
        return buf.toString();
    }

    public void setRawFileData(String rawFileData, DataRow parsedRow, ClassMapping classMapping) throws Exception {
        int i = 1;
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this), (String)"eligibilityStatus", (String)parsedRow.getString(i++));
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this), (String)"eligibilityStatusDate", (String)parsedRow.getString(i++));
        this.eligibilityVerificationMethod = StringUtils.truncToMaxLength((String)parsedRow.getString(i++), (int)50);
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this), (String)"eligibilityCode", (String)parsedRow.getString(i++));
        this.otherEligibilityCodes = RawFileDataContainerUtils.parseMultipleLookupValues((String)parsedRow.getString(i++), (String)"|", EligibilityType.class);
        this.serviceConnected = parsedRow.getString(i++);
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this), (String)"serviceConnectedPercentage", (String)parsedRow.getString(i++));
        this.unemployable = parsedRow.getString(i++);
        this.pAndT = parsedRow.getString(i++);
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this), (String)"pAndTEffectiveDate", (String)parsedRow.getString(i++));
        this.parseRatedDisabilities(parsedRow.getString(i++));
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this), (String)"combinedSCPercentEffectiveDate", (String)parsedRow.getString(i++));
        this.receivingVAPension = parsedRow.getString(i++);
        this.receivingAABenefits = parsedRow.getString(i++);
        this.receivingHouseholdBenefits = parsedRow.getString(i++);
        this.eligibleForMedicaid = parsedRow.getString(i++);
        this.dischargeDueToDisability = parsedRow.getString(i++);
        this.militaryDisabilityRetirement = parsedRow.getString(i++);
        this.receivingVADisability = parsedRow.getString(i++);
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this), (String)"totalAnnualVACheckAmount", (String)parsedRow.getString(i++));
        this.powStatusIndicated = parsedRow.getString(i++);
        this.ratedIncompetent = parsedRow.getString(i++);
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this), (String)"ineligibleDate", (String)parsedRow.getString(i++));
        this.ineligibleReason = parsedRow.getString(i++);
        this.ineligibleVaroDecision = parsedRow.getString(i++);
        this.exposedToAgentOrange = parsedRow.getString(i++);
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this), (String)"agentOrangeExposureLocation", (String)parsedRow.getString(i++));
        this.radiationExposureIndicator = parsedRow.getString(i++);
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this), (String)"radiationExposureMethod", (String)parsedRow.getString(i++));
        this.environmentalContaminants = parsedRow.getString(i++);
        this.veteranIndicator = parsedRow.getString(i++);
        RawFileDataContainerUtils.setConvertedField((Object)((Object)this), (String)"emergencyResponse", (String)parsedRow.getString(i++));
    }

    public AgentOrangeExposureLocation getAgentOrangeExposureLocation() {
        return this.agentOrangeExposureLocation;
    }

    public void setAgentOrangeExposureLocation(AgentOrangeExposureLocation agentOrangeExposureLocation) {
        this.agentOrangeExposureLocation = agentOrangeExposureLocation;
    }

    public RadiationExposureMethod getRadiationExposureMethod() {
        return this.radiationExposureMethod;
    }

    public void setRadiationExposureMethod(RadiationExposureMethod radiationExposureMethod) {
        this.radiationExposureMethod = radiationExposureMethod;
    }

    public BigDecimal getTotalAnnualVACheckAmount() {
        return this.totalAnnualVACheckAmount;
    }

    public void setTotalAnnualVACheckAmount(BigDecimal totalAnnualVACheckAmount) {
        this.totalAnnualVACheckAmount = totalAnnualVACheckAmount;
    }

    public EligibilityType getEligibilityCode() {
        return this.eligibilityCode;
    }

    public void setEligibilityCode(EligibilityType eligibilityCode) {
        this.eligibilityCode = eligibilityCode;
    }

    public Set getOtherEligibilityCodes() {
        return this.otherEligibilityCodes;
    }

    public EligibilityStatus getEligibilityStatus() {
        return this.eligibilityStatus;
    }

    public void setEligibilityStatus(EligibilityStatus eligibilityStatus) {
        this.eligibilityStatus = eligibilityStatus;
    }

    public Set getRatedDisabilities() {
        return this.ratedDisabilities;
    }

    public EmergencyResponse getEmergencyResponse() {
        return this.emergencyResponse;
    }

    public void setEmergencyResponse(EmergencyResponse emergencyResponse) {
        this.emergencyResponse = emergencyResponse;
    }

    public OrderedMap getRawFileData() throws Exception {
        ListOrderedMap map = new ListOrderedMap();
        map.put((Object)"header", (Object)"ELI");
        map.put((Object)"eligibilityStatus", (Object)this.eligibilityStatus);
        map.put((Object)"eligibilityStatusDate", (Object)this.eligibilityStatusDate);
        map.put((Object)"eligibilityVerificationMethod", (Object)this.eligibilityVerificationMethod);
        map.put((Object)"eligibilityCode", (Object)this.eligibilityCode);
        map.put((Object)"otherEligibilityCodes", (Object)RawFileDataContainerUtils.formatMultipleValues((Collection)this.otherEligibilityCodes, (String)"|"));
        map.put((Object)"serviceConnected", (Object)this.serviceConnected);
        map.put((Object)"serviceConnectedPercentage", (Object)this.serviceConnectedPercentage);
        map.put((Object)"unemployable", (Object)this.unemployable);
        map.put((Object)"pAndT", (Object)this.pAndT);
        map.put((Object)"pAndTEffectiveDate", (Object)this.pAndTEffectiveDate);
        map.put((Object)"ratedDisabilities", (Object)this.formatRatedDisabilities());
        map.put((Object)"combinedSCPercentEffectiveDate", (Object)this.combinedSCPercentEffectiveDate);
        map.put((Object)"receivingVAPension", (Object)this.receivingVAPension);
        map.put((Object)"receivingAABenefits", (Object)this.receivingAABenefits);
        map.put((Object)"receivingHouseholdBenefits", (Object)this.receivingHouseholdBenefits);
        map.put((Object)"eligibleForMedicaid", (Object)this.eligibleForMedicaid);
        map.put((Object)"dischargeDueToDisability", (Object)this.dischargeDueToDisability);
        map.put((Object)"militaryDisabilityRetirement", (Object)this.militaryDisabilityRetirement);
        map.put((Object)"receivingVADisability", (Object)this.receivingVADisability);
        map.put((Object)"totalAnnualVACheckAmount", (Object)this.totalAnnualVACheckAmount);
        map.put((Object)"powStatusIndicated", (Object)this.powStatusIndicated);
        map.put((Object)"ratedIncompetent", (Object)this.ratedIncompetent);
        map.put((Object)"ineligibleDate", (Object)this.ineligibleDate);
        map.put((Object)"ineligibleReason", (Object)this.ineligibleReason);
        map.put((Object)"ineligibleVaroDecision", (Object)this.ineligibleVaroDecision);
        map.put((Object)"exposedToAgentOrange", (Object)this.exposedToAgentOrange);
        map.put((Object)"agentOrangeExposureLocation", (Object)this.agentOrangeExposureLocation);
        map.put((Object)"radiationExposureIndicator", (Object)this.radiationExposureIndicator);
        map.put((Object)"radiationExposureMethod", (Object)this.radiationExposureMethod);
        map.put((Object)"environmentalContaminants", (Object)this.environmentalContaminants);
        map.put((Object)"veteranIndicator", (Object)this.veteranIndicator);
        map.put((Object)"emergencyResponse", (Object)this.emergencyResponse);
        return map;
    }

    public void setOtherEligibilityCodes(Set otherEligibilityCodes) {
        this.otherEligibilityCodes = otherEligibilityCodes;
    }

    public void addOtherEligibilityCode(EligibilityType other) {
        this.otherEligibilityCodes.add(other);
    }

    public void setRatedDisabilities(Set ratedDisabilities) {
        this.ratedDisabilities = ratedDisabilities;
    }

    public void addRatedDisability(RatedDisability dis) {
        this.ratedDisabilities.add(dis);
    }

    public Integer getServiceConnectedPercentage() {
        return this.serviceConnectedPercentage;
    }

    public void setServiceConnectedPercentage(Integer serviceConnectedPercentage) {
        this.serviceConnectedPercentage = serviceConnectedPercentage;
    }

    public String getVeteranIndicator() {
        return this.veteranIndicator;
    }

    public void setVeteranIndicator(String veteranIndicator) {
        this.veteranIndicator = veteranIndicator;
    }

    static {
        RawFileDataContainerUtils.autoRegisterConvertersForClass();
    }
}

